/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj.callback.block;

import blusunrize.immersiveengineering.api.client.ieobj.BlockCallback;
import blusunrize.immersiveengineering.client.utils.ModelUtils;
import blusunrize.immersiveengineering.common.blocks.metal.StructuralArmBlockEntity;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

public class StructuralArmCallbacks
implements BlockCallback<Key> {
    public static final StructuralArmCallbacks INSTANCE = new StructuralArmCallbacks();
    private static final Matrix4 SHRINK = (Matrix4)Util.m_137469_((Object)new Matrix4(), mat -> {
        mat.translate(0.5, 0.5, 0.5);
        mat.scale(0.999, 0.999, 0.999);
        mat.translate(-0.5, -0.5, -0.5);
    });
    private static final Key INVALID = new Key(0, 1, false, Direction.NORTH);

    @Override
    public Key extractKey(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, BlockEntity blockEntity) {
        if (!(blockEntity instanceof StructuralArmBlockEntity)) {
            return this.getDefaultKey();
        }
        StructuralArmBlockEntity structuralArm = (StructuralArmBlockEntity)blockEntity;
        return new Key(structuralArm.getSlopePosition(), structuralArm.getTotalLength(), structuralArm.isOnCeiling(), structuralArm.getFacing());
    }

    @Override
    public Key getDefaultKey() {
        return INVALID;
    }

    @Override
    public List<BakedQuad> modifyQuads(Key object, List<BakedQuad> quads) {
        boolean onCeiling = object.onCeiling();
        int slopePosition = object.slopePosition();
        int totalLength = object.totalLength();
        float lowerHeight = (float)slopePosition / (float)totalLength;
        float upperHeight = ((float)slopePosition + 1.0f) / (float)totalLength;
        double lowerV = 16.0f * lowerHeight;
        double upperV = 16.0f * upperHeight;
        TextureAtlasSprite tas = quads.get(0).m_173410_();
        quads = new ArrayList<BakedQuad>();
        Matrix4 mat = new Matrix4(object.facing());
        float y03 = onCeiling ? 1.0f : upperHeight;
        float y12 = onCeiling ? 1.0f : lowerHeight;
        float y47 = onCeiling ? 1.0f - upperHeight : 0.0f;
        float y56 = onCeiling ? 1.0f - lowerHeight : 0.0f;
        Vec3[] vertices = new Vec3[]{new Vec3(0.0, (double)y03, 0.0), new Vec3(0.0, (double)y12, 1.0), new Vec3(1.0, (double)y12, 1.0), new Vec3(1.0, (double)y03, 0.0), new Vec3(0.0, (double)y47, 0.0), new Vec3(0.0, (double)y56, 1.0), new Vec3(1.0, (double)y56, 1.0), new Vec3(1.0, (double)y47, 0.0)};
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = mat.apply(vertices[i]);
        }
        this.addCulledQuad(quads, Arrays.copyOf(vertices, 4), Direction.UP, tas, new double[]{0.0, 0.0, 16.0, 16.0}, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, object.facing());
        this.addCulledQuad(quads, this.getArrayByIndices(vertices, 7, 6, 5, 4), Direction.DOWN, tas, new double[]{0.0, 0.0, 16.0, 16.0}, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, object.facing());
        this.addSides(quads, vertices, tas, lowerV, upperV, false, object.facing(), object.onCeiling());
        this.addSides(quads, vertices, tas, lowerV, upperV, true, object.facing(), object.onCeiling());
        if (object.slopePosition() + 1 == object.totalLength()) {
            this.addCulledQuad(quads, this.getArrayByIndices(vertices, 0, 3, 7, 4), Direction.NORTH, tas, new double[]{0.0, 0.0, 16.0, 16.0}, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, object.facing);
        }
        return quads;
    }

    private void addCulledQuad(List<BakedQuad> quads, Vec3[] vertices, Direction side, TextureAtlasSprite tas, double[] uvs, float[] alpha, Direction facing) {
        side = Utils.rotateFacingTowardsDir(side, facing);
        quads.add(ModelUtils.createBakedQuad(vertices, side, tas, uvs, alpha, false));
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = SHRINK.apply(vertices[i]);
        }
        quads.add(ModelUtils.createBakedQuad(vertices, side.m_122424_(), tas, uvs, alpha, true));
    }

    private void addSides(List<BakedQuad> quads, Vec3[] vertices, TextureAtlasSprite tas, double lowerV, double upperV, boolean invert, Direction facing, boolean onCeiling) {
        if (invert) {
            for (int i = 0; i < vertices.length; ++i) {
                vertices[i] = SHRINK.apply(vertices[i]);
            }
        }
        quads.add(this.createSide(this.getArrayByIndices(vertices, 5, 1, 0, 4), Direction.WEST, tas, lowerV, upperV, invert, facing, onCeiling));
        quads.add(this.createSide(this.getArrayByIndices(vertices, 7, 3, 2, 6), Direction.EAST, tas, upperV, lowerV, invert, facing, onCeiling));
    }

    private BakedQuad createSide(Vec3[] vertices, Direction facing, TextureAtlasSprite sprite, double leftV, double rightV, boolean invert, Direction blockFacing, boolean onCeiling) {
        facing = Utils.rotateFacingTowardsDir(facing, blockFacing);
        if (invert) {
            double tmp = leftV;
            leftV = rightV;
            rightV = tmp;
        }
        if (invert) {
            facing = facing.m_122424_();
        }
        float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(facing);
        Vec3 faceNormal = Vec3.m_82528_((Vec3i)facing.m_122436_());
        int vertexId = invert ? 3 : 0;
        double v = onCeiling ? 16.0 - leftV : 0.0;
        ModelUtils.putVertexData(builder, vertices[vertexId], faceNormal, vertexId > 1 ? 16.0 : 0.0, v, sprite, colour, 1.0f);
        vertexId = invert ? 2 : 1;
        v = onCeiling ? 16.0 : leftV;
        ModelUtils.putVertexData(builder, vertices[vertexId], faceNormal, vertexId > 1 ? 16.0 : 0.0, v, sprite, colour, 1.0f);
        vertexId = invert ? 1 : 2;
        v = onCeiling ? 16.0 : rightV;
        ModelUtils.putVertexData(builder, vertices[vertexId], faceNormal, vertexId > 1 ? 16.0 : 0.0, v, sprite, colour, 1.0f);
        vertexId = invert ? 0 : 3;
        v = onCeiling ? 16.0 - rightV : 0.0;
        ModelUtils.putVertexData(builder, vertices[vertexId], faceNormal, vertexId > 1 ? 16.0 : 0.0, v, sprite, colour, 1.0f);
        return builder.build();
    }

    private Vec3[] getArrayByIndices(Vec3[] in, int ... indices) {
        Vec3[] ret = new Vec3[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            ret[i] = in[indices[i]];
        }
        return ret;
    }

    public record Key(int slopePosition, int totalLength, boolean onCeiling, Direction facing) {
    }
}

