/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.client.models.ModelEarmuffs;
import blusunrize.immersiveengineering.client.models.ModelGlider;
import blusunrize.immersiveengineering.client.models.ModelPowerpack;
import blusunrize.immersiveengineering.client.render.entity.IEModelLayers;
import blusunrize.immersiveengineering.common.items.EarmuffsItem;
import blusunrize.immersiveengineering.common.items.GliderItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.PowerpackItem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class IEBipedLayerRenderer<E extends LivingEntity, M extends EntityModel<E>>
extends RenderLayer<E, M> {
    private static ModelEarmuffs earmuffModel;
    private static ModelGlider gliderModel;
    private static final ResourceLocation EARMUFF_OVERLAY;
    private static final ResourceLocation EARMUFF_TEXTURE;
    private static final ResourceLocation GLIDER_TEXTURE;

    public IEBipedLayerRenderer(RenderLayerParent<E, M> entityRendererIn, EntityModelSet models) {
        super(entityRendererIn);
        if (earmuffModel == null) {
            earmuffModel = new ModelEarmuffs(models.m_171103_(IEModelLayers.EARMUFFS));
        }
        if (gliderModel == null) {
            gliderModel = new ModelGlider(models.m_171103_(IEModelLayers.GLIDER));
        }
    }

    @ParametersAreNonnullByDefault
    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, E living, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack chest;
        ItemStack powerpack;
        ItemStack earmuffs = EarmuffsItem.EARMUFF_GETTERS.getFrom((LivingEntity)living);
        if (!earmuffs.m_41619_()) {
            earmuffModel.m_6973_((LivingEntity)living, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            RenderType type = earmuffModel.m_103119_(EARMUFF_OVERLAY);
            earmuffModel.m_7695_(matrixStackIn, bufferIn.m_6299_(type), packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            int colour = ((IEItemInterfaces.IColouredItem)earmuffs.m_41720_()).getColourForIEItem(earmuffs, 0);
            type = earmuffModel.m_103119_(EARMUFF_TEXTURE);
            earmuffModel.m_7695_(matrixStackIn, bufferIn.m_6299_(type), packedLightIn, OverlayTexture.f_118083_, (float)(colour >> 16 & 0xFF) / 255.0f, (float)(colour >> 8 & 0xFF) / 255.0f, (float)(colour & 0xFF) / 255.0f, 1.0f);
        }
        if (!(powerpack = PowerpackItem.POWERPACK_GETTER.getFrom((LivingEntity)living)).m_41619_()) {
            this.renderPowerpack(powerpack, matrixStackIn, bufferIn, packedLightIn, living, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
        if ((chest = living.m_6844_(EquipmentSlot.CHEST)).m_41720_() instanceof GliderItem) {
            gliderModel.m_6973_((LivingEntity)living, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            IEBipedLayerRenderer.gliderModel.f_102810_.m_171324_((String)"glider").f_104207_ = living.m_21255_();
            RenderType type = gliderModel.m_103119_(GLIDER_TEXTURE);
            gliderModel.m_7695_(matrixStackIn, bufferIn.m_6299_(type), packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private void renderPowerpack(ItemStack powerpack, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, E living, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!powerpack.m_41619_()) {
            ModelPowerpack.render(living, powerpack, matrixStackIn, bufferIn, packedLightIn, OverlayTexture.f_118083_, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }

    static {
        EARMUFF_OVERLAY = ImmersiveEngineering.rl("textures/models/earmuffs_overlay.png");
        EARMUFF_TEXTURE = ImmersiveEngineering.rl("textures/models/earmuffs.png");
        GLIDER_TEXTURE = ImmersiveEngineering.rl("textures/models/glider.png");
    }
}

