/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.utils.client.SinglePropertyModelData;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.obj.callback.DynamicSubmodelCallbacks;
import blusunrize.immersiveengineering.client.render.tile.BERenderUtils;
import blusunrize.immersiveengineering.client.render.tile.BlueprintRenderer;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.common.blocks.metal.AutoWorkbenchBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class AutoWorkbenchRenderer
extends IEBlockEntityRenderer<AutoWorkbenchBlockEntity> {
    public static final String NAME = "auto_workbench_animated";
    public static DynamicModel DYNAMIC;

    public void render(AutoWorkbenchBlockEntity blockEntity, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!blockEntity.formed || blockEntity.isDummy() || !blockEntity.getLevelNonnull().m_46805_(blockEntity.m_58899_())) {
            return;
        }
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        BlockPos blockPos = blockEntity.m_58899_();
        BlockState state = blockEntity.getLevelNonnull().m_8055_(blockPos);
        if (state.m_60734_() != IEBlocks.Multiblocks.AUTO_WORKBENCH.get()) {
            return;
        }
        BakedModel model = DYNAMIC.get();
        float[][] itemDisplays = new float[blockEntity.processQueue.size()][];
        float drill = 0.0f;
        float lift = 0.0f;
        float press = 0.0f;
        float liftPress = 0.0f;
        for (int i = 0; i < itemDisplays.length; ++i) {
            float processTimer;
            MultiblockProcess process = (MultiblockProcess)blockEntity.processQueue.get(i);
            if (process == null || process.processTick <= 0 || process.processTick == process.getMaxTicks(blockEntity.m_58904_()) || (processTimer = (float)process.processTick / (float)process.getMaxTicks(blockEntity.m_58904_()) * 180.0f) <= 9.0f) continue;
            float itemX = -1.0f;
            float itemY = -0.34375f;
            float itemZ = -0.9375f;
            float itemAngle = 90.0f;
            if (processTimer <= 24.0f) {
                itemAngle = 67.5f;
                if (processTimer <= 19.0f) {
                    itemZ = (float)((double)itemZ + (0.25 + (double)((19.0f - processTimer) / 10.0f * 0.5f)));
                    itemY = (float)((double)itemY + (0.25 + (double)((19.0f - processTimer) / 10.0f * 0.21875f)));
                } else {
                    itemZ += (24.0f - processTimer) / 5.0f * 0.25f;
                    itemY += (24.0f - processTimer) / 5.0f * 0.25f;
                }
            } else if (processTimer <= 40.0f) {
                itemX += (processTimer - 24.0f) / 16.0f;
            } else if (processTimer <= 100.0f) {
                itemX += 1.0f;
                float drillStep = 0.0f;
                if (processTimer <= 60.0f) {
                    lift = (processTimer - 40.0f) / 20.0f * 0.3125f;
                    drillStep = 4.0f + (60.0f - processTimer) * 4.0f;
                } else if (processTimer <= 80.0f) {
                    lift = 0.3125f;
                    drillStep = 4.0f;
                } else {
                    lift = (100.0f - processTimer) / 20.0f * 0.3125f;
                    drillStep = 4.0f + (processTimer - 80.0f) * 4.0f;
                }
                if (drillStep > 0.0f) {
                    drill = processTimer % drillStep / drillStep * 360.0f;
                }
                itemY = (float)((double)itemY + Math.max(0.0, (double)lift - 0.0625));
            } else if (processTimer <= 116.0f) {
                itemX += 1.0f;
                itemZ += (processTimer - 100.0f) / 16.0f;
            } else if (processTimer <= 132.0f) {
                itemX += 1.0f + (processTimer - 116.0f) / 16.0f;
                itemZ += 1.0f;
            } else if (processTimer <= 172.0f) {
                itemX += 2.0f;
                itemZ += 1.0f;
                press = processTimer <= 142.0f ? (processTimer - 132.0f) / 10.0f : (processTimer <= 162.0f ? 1.0f : (172.0f - processTimer) / 10.0f);
                liftPress = press * 0.0625f;
                itemY += liftPress;
            } else if (processTimer <= 180.0f) {
                itemX += 2.0f + (processTimer - 172.0f) / 16.0f;
                itemZ += 1.0f;
            }
            itemDisplays[i] = new float[]{processTimer, itemX, itemY, itemZ, itemAngle};
        }
        matrixStack.m_85836_();
        bufferIn = BERenderUtils.mirror(blockEntity, matrixStack, bufferIn);
        Direction facing = blockEntity.getFacing();
        if (blockEntity.getIsMirrored()) {
            if (facing.m_122434_() == Direction.Axis.Z) {
                matrixStack.m_85837_(-1.0, 0.0, 0.0);
            } else {
                matrixStack.m_85837_(0.0, 0.0, -1.0);
            }
        }
        AutoWorkbenchRenderer.rotateForFacing(matrixStack, facing);
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        matrixStack.m_85836_();
        ItemStack blueprintStack = (ItemStack)blockEntity.inventory.get(0);
        if (!blueprintStack.m_41619_()) {
            AutoWorkbenchRenderer.renderModelPart(matrixStack, blockRenderer, bufferIn, state, model, combinedLightIn, combinedOverlayIn, "blueprint");
        }
        matrixStack.m_85837_(0.0, (double)lift, 0.0);
        AutoWorkbenchRenderer.renderModelPart(matrixStack, blockRenderer, bufferIn, state, model, combinedLightIn, combinedOverlayIn, "lift");
        matrixStack.m_85837_(0.0, (double)(-lift), 0.0);
        float tx = 0.0f;
        float tz = -0.9375f;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)tx, 0.0, (double)tz);
        matrixStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), drill, true));
        AutoWorkbenchRenderer.renderModelPart(matrixStack, blockRenderer, bufferIn, state, model, combinedLightIn, combinedOverlayIn, "drill");
        matrixStack.m_85849_();
        tx = 0.0f;
        tz = -0.59375f;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)tx, -0.21875, (double)tz);
        matrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), press * 90.0f, true));
        AutoWorkbenchRenderer.renderModelPart(matrixStack, blockRenderer, bufferIn, state, model, combinedLightIn, combinedOverlayIn, "press");
        matrixStack.m_85849_();
        matrixStack.m_85837_(0.0, (double)liftPress, 0.0);
        AutoWorkbenchRenderer.renderModelPart(matrixStack, blockRenderer, bufferIn, state, model, combinedLightIn, combinedOverlayIn, "pressLift");
        matrixStack.m_85849_();
        for (int i = 0; i < itemDisplays.length; ++i) {
            MultiblockProcess process;
            if (itemDisplays[i] == null || !((process = (MultiblockProcess)blockEntity.processQueue.get(i)) instanceof MultiblockProcessInWorld)) continue;
            MultiblockProcessInWorld inWorld = (MultiblockProcessInWorld)process;
            float scale = 0.3125f;
            List<ItemStack> dList = inWorld.getDisplayItem(blockEntity.m_58904_());
            if (dList.isEmpty()) continue;
            if (dList.size() < 2) {
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)itemDisplays[i][1], (double)itemDisplays[i][2], (double)itemDisplays[i][3]);
                matrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), itemDisplays[i][4], true));
                matrixStack.m_85841_(scale, scale, 0.5f);
                ClientUtils.mc().m_91291_().m_174269_(dList.get(0), ItemTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, 0);
                matrixStack.m_85849_();
                continue;
            }
            int size = dList.size();
            int lines = (int)Math.ceil((float)size / 2.0f);
            float spacer = (float)(lines - 1) * 0.234375f;
            for (int d = 0; d < size; ++d) {
                float oX = (size > 2 ? -0.3125f : 0.0f) + (float)(lines - d / 2) * 0.0625f + (float)(d % 2) * 0.3125f;
                float oZ = -spacer / 2.0f + (float)(d / 2) * 0.234375f;
                float oY = 0.0f;
                float localItemX = itemDisplays[i][1] + oX;
                float localItemY = itemDisplays[i][2] + oY;
                float localItemZ = itemDisplays[i][3] + oZ;
                float subProcess = itemDisplays[i][0] - (float)(d / 2 * 4);
                float localAngle = itemDisplays[i][4];
                if (subProcess <= 24.0f) {
                    localAngle = 67.5f;
                    if (subProcess <= 19.0f) {
                        localItemZ = -0.75f + (19.0f - subProcess) / 10.0f * 0.5f;
                        localItemY = -0.09375f + (19.0f - subProcess) / 10.0f * 0.21875f;
                    } else {
                        localItemZ = -1.0f + (oZ - (24.0f - subProcess) / 5.0f * oZ);
                        localItemY = -0.34375f + (24.0f - subProcess) / 5.0f * 0.25f;
                    }
                }
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)localItemX, (double)localItemY, (double)localItemZ);
                matrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), localAngle, true));
                matrixStack.m_85841_(scale, scale, 0.5f);
                ClientUtils.mc().m_91291_().m_174269_(dList.get(d), ItemTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, 0);
                matrixStack.m_85849_();
            }
        }
        double playerDistanceSq = ClientUtils.mc().f_91074_.m_20238_(Vec3.m_82512_((Vec3i)blockPos));
        if (!blueprintStack.m_41619_() && playerDistanceSq < 1000.0) {
            BlueprintRenderer.BlueprintLines blueprint;
            BlueprintCraftingRecipe[] recipes = BlueprintCraftingRecipe.findRecipes(blockEntity.m_58904_(), ItemNBTHelper.getString(blueprintStack, "blueprint"));
            BlueprintCraftingRecipe recipe = blockEntity.selectedRecipe < 0 || blockEntity.selectedRecipe >= recipes.length ? null : recipes[blockEntity.selectedRecipe];
            BlueprintRenderer.BlueprintLines blueprintLines = blueprint = recipe == null ? null : BlueprintRenderer.getBlueprintDrawable(recipe, blockEntity.getLevelNonnull());
            if (blueprint != null) {
                matrixStack.m_85836_();
                matrixStack.m_85837_(-0.195, 0.125, 0.97);
                matrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), -45.0f, true));
                float scale = 0.5f / (float)blueprint.textureScale;
                matrixStack.m_85841_(scale, -scale, scale);
                matrixStack.m_85837_(0.5, 0.5, 0.5);
                blueprint.draw(matrixStack, bufferIn, combinedLightIn);
                matrixStack.m_85849_();
            }
        }
        matrixStack.m_85849_();
    }

    public static void renderModelPart(PoseStack matrix, BlockRenderDispatcher blockRenderer, MultiBufferSource buffers, BlockState state, BakedModel model, int light, int overlay, String parts) {
        matrix.m_85836_();
        matrix.m_85837_(-0.5, -0.5, -0.5);
        SinglePropertyModelData<IEProperties.VisibilityList> data = new SinglePropertyModelData<IEProperties.VisibilityList>(IEProperties.VisibilityList.show(parts), DynamicSubmodelCallbacks.getProperty());
        blockRenderer.m_110937_().renderModel(matrix.m_85850_(), buffers.m_6299_(RenderType.m_110451_()), state, model, 1.0f, 1.0f, 1.0f, light, overlay, data);
        matrix.m_85849_();
    }
}

