/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.register.IEContainerTypes;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.register.IEParticles;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.orientation.RelativeBlockFace;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.mutable.MutableInt;

public class ArcFurnaceBlockEntity
extends PoweredMultiblockBlockEntity<ArcFurnaceBlockEntity, ArcFurnaceRecipe>
implements IEBlockInterfaces.ISoundBE,
IEBlockInterfaces.IInteractionObjectIE<ArcFurnaceBlockEntity>,
IEBlockInterfaces.ISelectionBounds,
IEBlockInterfaces.ICollisionBounds,
IEClientTickableBE {
    public static final int FIRST_IN_SLOT = 0;
    public static final int IN_SLOT_COUNT = 12;
    public static final int FIRST_ADDITIVE_SLOT = 12;
    public static final int ADDITIVE_SLOT_COUNT = 4;
    public static final int FIRST_OUT_SLOT = 16;
    public static final int OUT_SLOT_COUNT = 6;
    public static final int SLAG_SLOT = 22;
    public static final int FIRST_ELECTRODE_SLOT = 23;
    public static final int ELECTRODE_COUNT = 3;
    private static final BlockPos SLAG_OUT_POS = new BlockPos(2, 0, 0);
    private static final BlockPos MAIN_OUT_POS = new BlockPos(2, 0, 4);
    private static final int[] OUTPUT_SLOTS = new int[6];
    public NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)26, (Object)ItemStack.f_41583_);
    public int pouringMetal = 0;
    private final CapabilityReference<IItemHandler> output = CapabilityReference.forBlockEntityAt(this, () -> new DirectionalBlockPos(this.getBlockPosForPos(MAIN_OUT_POS).m_5484_(this.getFacing(), -1), this.getFacing().m_122424_()), CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private final CapabilityReference<IItemHandler> slagOut = CapabilityReference.forBlockEntityAt(this, () -> new DirectionalBlockPos(this.getBlockPosForPos(SLAG_OUT_POS).m_142300_(this.getFacing()), this.getFacing().m_122424_()), CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private AABB renderAABB;
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> COLLISION_SHAPES;
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES;
    private static final BlockPos ELECTRODE_COMPARATOR_POS;
    private final MutableInt electrodeComparatorValue = new MutableInt(-1);
    private final MultiblockCapability<IItemHandler> inputHandler = MultiblockCapability.make(this, be -> be.inputHandler, MultiblockPartBlockEntity::master, this.registerCapability(new IEInventoryHandler(12, this, 0, true, false){

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.m_41619_()) {
                return stack;
            }
            stack = stack.m_41777_();
            ArrayList<Integer> possibleSlots = new ArrayList<Integer>(12);
            for (int i = 0; i < 12; ++i) {
                ItemStack here = (ItemStack)ArcFurnaceBlockEntity.this.inventory.get(i);
                if (here.m_41619_()) {
                    if (!simulate) {
                        ArcFurnaceBlockEntity.this.inventory.set(i, (Object)stack);
                    }
                    return ItemStack.f_41583_;
                }
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)here) || here.m_41613_() >= here.m_41741_()) continue;
                possibleSlots.add(i);
            }
            possibleSlots.sort(Comparator.comparingInt(a -> ((ItemStack)ArcFurnaceBlockEntity.this.inventory.get(a.intValue())).m_41613_()));
            Iterator iterator = possibleSlots.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                ItemStack here = (ItemStack)ArcFurnaceBlockEntity.this.inventory.get(i);
                int fillCount = Math.min(here.m_41741_() - here.m_41613_(), stack.m_41613_());
                if (!simulate) {
                    here.m_41769_(fillCount);
                }
                stack.m_41774_(fillCount);
                if (!stack.m_41619_()) continue;
                return ItemStack.f_41583_;
            }
            return stack;
        }
    }));
    private final MultiblockCapability<IItemHandler> additiveHandler = MultiblockCapability.make(this, be -> be.additiveHandler, MultiblockPartBlockEntity::master, this.registerCapability(new IEInventoryHandler(4, (IIEInventory)this, 12, true, false)));
    private final MultiblockCapability<IItemHandler> outputHandler = MultiblockCapability.make(this, be -> be.outputHandler, MultiblockPartBlockEntity::master, this.registerCapability(new IEInventoryHandler(6, (IIEInventory)this, 16, false, true)));
    private final MultiblockCapability<IItemHandler> slagHandler = MultiblockCapability.make(this, be -> be.slagHandler, MultiblockPartBlockEntity::master, this.registerCapability(new IEInventoryHandler(1, (IIEInventory)this, 22, false, true)));
    private static final Set<BlockPos> specialGuiPositions;

    public ArcFurnaceBlockEntity(BlockEntityType<ArcFurnaceBlockEntity> type, BlockPos pos, BlockState state) {
        super(IEMultiblocks.ARC_FURNACE, 64000, true, type, pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (!descPacket) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        } else {
            byte electrodeStatus = nbt.m_128445_("electrodeStatus");
            for (int i = 0; i < 3; ++i) {
                boolean hasElectrodeClient;
                boolean hasElectrodeServer = (electrodeStatus & 1) != 0;
                int slot = 23 + i;
                boolean bl = hasElectrodeClient = !((ItemStack)this.inventory.get(slot)).m_41619_();
                if (hasElectrodeServer && !hasElectrodeClient) {
                    this.inventory.set(slot, (Object)new ItemStack(IEItems.Misc.GRAPHITE_ELECTRODE));
                } else if (!hasElectrodeServer && hasElectrodeClient) {
                    this.inventory.set(slot, (Object)ItemStack.f_41583_);
                }
                electrodeStatus = (byte)(electrodeStatus >>> 1);
            }
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!descPacket) {
            ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        } else {
            byte packed = 0;
            byte mask = 1;
            for (int i = 0; i < 3; ++i) {
                if (!((ItemStack)this.inventory.get(23 + i)).m_41619_()) {
                    packed = (byte)(packed + mask);
                }
                mask = (byte)(mask * 2);
            }
            nbt.m_128344_("electrodeStatus", packed);
        }
    }

    @Override
    public void tickClient() {
        if (this.isDummy()) {
            return;
        }
        if (this.pouringMetal > 0) {
            --this.pouringMetal;
        }
        if (this.shouldRenderAsActive()) {
            int i = 0;
            while ((double)i < Math.max(1.0, (double)this.processQueue.size() * 0.51)) {
                if (Utils.RAND.nextInt(6) == 0) {
                    this.f_58857_.m_7107_((ParticleOptions)IEParticles.SPARKS.get(), (double)this.m_58899_().m_123341_() + 0.5 - 0.25 * (double)this.getFacing().m_122429_(), (double)this.m_58899_().m_123342_() + 2.9, (double)this.m_58899_().m_123343_() + 0.5 - 0.25 * (double)this.getFacing().m_122431_(), Utils.RAND.nextDouble() * 0.05 - 0.025, 0.025, Utils.RAND.nextDouble() * 0.05 - 0.025);
                    this.f_58857_.m_7107_((ParticleOptions)IEParticles.SPARKS.get(), (double)this.m_58899_().m_123341_() + 0.5 + 0.25 * (double)this.getFacing().m_122429_() + 0.375 * (double)this.getFacing().m_122431_(), (double)this.m_58899_().m_123342_() + 2.9, (double)this.m_58899_().m_123343_() + 0.5 + 0.25 * (double)this.getFacing().m_122431_() + 0.375 * (double)this.getFacing().m_122429_(), Utils.RAND.nextDouble() * 0.05 - 0.025, 0.025, Utils.RAND.nextDouble() * 0.05 - 0.025);
                    this.f_58857_.m_7107_((ParticleOptions)IEParticles.SPARKS.get(), (double)this.m_58899_().m_123341_() + 0.5 + 0.25 * (double)this.getFacing().m_122429_() - 0.375 * (double)this.getFacing().m_122431_(), (double)this.m_58899_().m_123342_() + 2.9, (double)this.m_58899_().m_123343_() + 0.5 + 0.25 * (double)this.getFacing().m_122431_() - 0.375 * (double)this.getFacing().m_122429_(), Utils.RAND.nextDouble() * 0.05 - 0.025, 0.025, Utils.RAND.nextDouble() * 0.05 - 0.025);
                    this.f_58857_.m_7107_((ParticleOptions)IEParticles.SPARKS.get(), (double)this.m_58899_().m_123341_() + 0.5 - 0.25 * (double)this.getFacing().m_122429_(), (double)this.m_58899_().m_123342_() + 2.9, (double)this.m_58899_().m_123343_() + 0.5 - 0.25 * (double)this.getFacing().m_122431_(), Utils.RAND.nextDouble() * 0.05 - 0.025, 0.05, Utils.RAND.nextDouble() * 0.05 - 0.025);
                    this.f_58857_.m_7107_((ParticleOptions)IEParticles.SPARKS.get(), (double)this.m_58899_().m_123341_() + 0.5 + 0.25 * (double)this.getFacing().m_122429_() + 0.375 * (double)this.getFacing().m_122431_(), (double)this.m_58899_().m_123342_() + 2.9, (double)this.m_58899_().m_123343_() + 0.5 + 0.25 * (double)this.getFacing().m_122431_() + 0.375 * (double)this.getFacing().m_122429_(), Utils.RAND.nextDouble() * 0.05 - 0.025, 0.05, Utils.RAND.nextDouble() * 0.05 - 0.025);
                    this.f_58857_.m_7107_((ParticleOptions)IEParticles.SPARKS.get(), (double)this.m_58899_().m_123341_() + 0.5 + 0.25 * (double)this.getFacing().m_122429_() - 0.375 * (double)this.getFacing().m_122431_(), (double)this.m_58899_().m_123342_() + 2.9, (double)this.m_58899_().m_123343_() + 0.5 + 0.25 * (double)this.getFacing().m_122431_() - 0.375 * (double)this.getFacing().m_122429_(), Utils.RAND.nextDouble() * 0.05 - 0.025, 0.05, Utils.RAND.nextDouble() * 0.05 - 0.025);
                }
                this.f_58857_.m_7107_((ParticleOptions)ParticleTypes.f_123777_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 2.9, (double)this.m_58899_().m_123343_() + 0.5, Utils.RAND.nextDouble() * 0.01875 - 0.009375, 0.0625, Utils.RAND.nextDouble() * 0.01875 - 0.009375);
                ++i;
            }
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.isDummy()) {
            return;
        }
        if (!this.isRSDisabled() && this.energyStorage.getEnergyStored() > 0) {
            if (this.tickedProcesses > 0) {
                for (int i = 23; i < 26; ++i) {
                    if (!((ItemStack)this.inventory.get(i)).m_41629_(1, Utils.RAND, null)) continue;
                    this.inventory.set(i, (Object)ItemStack.f_41583_);
                }
            }
            ArcFurnaceBlockEntity.updateComparators(this, (Collection<BlockPos>)ImmutableList.of((Object)ELECTRODE_COMPARATOR_POS), this.electrodeComparatorValue, this.getElectrodeComparatorValueOnMaster());
            if (this.processQueue.size() < this.getProcessQueueMaxLength()) {
                HashMap<Integer, Integer> usedInvSlots = new HashMap<Integer, Integer>();
                for (MultiblockProcess process : this.processQueue) {
                    if (!(process instanceof MultiblockProcessInMachine)) continue;
                    int[] inputSlots = ((MultiblockProcessInMachine)process).getInputSlots();
                    int[] inputAmounts = ((MultiblockProcessInMachine)process).getInputAmounts();
                    if (inputAmounts == null) continue;
                    for (int i = 0; i < inputSlots.length; ++i) {
                        if (inputAmounts[i] <= 0) continue;
                        if (usedInvSlots.containsKey(inputSlots[i])) {
                            usedInvSlots.put(inputSlots[i], (Integer)usedInvSlots.get(inputSlots[i]) + inputAmounts[i]);
                            continue;
                        }
                        usedInvSlots.put(inputSlots[i], inputAmounts[i]);
                    }
                }
                NonNullList additives = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
                for (int i = 0; i < 4; ++i) {
                    if (((ItemStack)this.inventory.get(12 + i)).m_41619_()) continue;
                    additives.set(i, (Object)((ItemStack)this.inventory.get(12 + i)).m_41777_());
                    if (!usedInvSlots.containsKey(12 + i)) continue;
                    ((ItemStack)additives.get(i)).m_41774_(((Integer)usedInvSlots.get(12 + i)).intValue());
                }
                for (int slot = 0; slot < 12; ++slot) {
                    MultiblockProcessArcFurnace process;
                    ArcFurnaceRecipe recipe;
                    ItemStack stack;
                    if (usedInvSlots.containsKey(slot) || (stack = (ItemStack)this.getInventory().get(slot)).m_41619_() || stack.m_41613_() <= 0 || (recipe = ArcFurnaceRecipe.findRecipe(this.f_58857_, stack, (NonNullList<ItemStack>)additives)) == null || !this.addProcessToQueue(process = new MultiblockProcessArcFurnace(recipe, this::getRecipeForId, ApiUtils.RANDOM.nextLong(), slot, 12, 13, 14, 15), true)) continue;
                    this.addProcessToQueue(process, false);
                    int[] consumedAdditives = recipe.getConsumedAdditives((NonNullList<ItemStack>)additives, true);
                    if (consumedAdditives == null) continue;
                    process.setInputAmounts(recipe.input.getCount(), consumedAdditives[0], consumedAdditives[1], consumedAdditives[2], consumedAdditives[3]);
                }
            }
            if (this.f_58857_.m_46467_() % 8L == 0L) {
                this.outputItems();
            }
        }
    }

    private void outputItems() {
        IItemHandler outputHandler = this.output.getNullable();
        if (outputHandler != null) {
            for (int j : OUTPUT_SLOTS) {
                if (((ItemStack)this.inventory.get(j)).m_41619_()) continue;
                ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)((ItemStack)this.inventory.get(j)), (int)1);
                if (!(stack = ItemHandlerHelper.insertItem((IItemHandler)outputHandler, (ItemStack)stack, (boolean)false)).m_41619_()) continue;
                ((ItemStack)this.inventory.get(j)).m_41774_(1);
                if (((ItemStack)this.inventory.get(j)).m_41613_() > 0) continue;
                this.inventory.set(j, (Object)ItemStack.f_41583_);
            }
        }
        if (((ItemStack)this.inventory.get(22)).m_41619_()) {
            return;
        }
        IItemHandler slagOutputHandler = this.slagOut.getNullable();
        if (slagOutputHandler != null) {
            int out = Math.min(((ItemStack)this.inventory.get(22)).m_41613_(), 16);
            ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)((ItemStack)this.inventory.get(22)), (int)out);
            if (!(stack = ItemHandlerHelper.insertItem((IItemHandler)slagOutputHandler, (ItemStack)stack, (boolean)false)).m_41619_()) {
                out -= stack.m_41613_();
            }
            ((ItemStack)this.inventory.get(22)).m_41774_(out);
            if (((ItemStack)this.inventory.get(22)).m_41613_() <= 0) {
                this.inventory.set(22, (Object)ItemStack.f_41583_);
            }
        }
    }

    @Override
    public boolean m_7531_(int id, int type) {
        if (id == 0) {
            this.pouringMetal = type;
        }
        return super.m_7531_(id, type);
    }

    @Override
    public AABB getRenderBoundingBox() {
        return new AABB((double)(this.m_58899_().m_123341_() - (this.getFacing().m_122434_() == Direction.Axis.Z ? 2 : 1)), (double)this.m_58899_().m_123342_(), (double)(this.m_58899_().m_123343_() - (this.getFacing().m_122434_() == Direction.Axis.X ? 2 : 1)), (double)(this.m_58899_().m_123341_() + (this.getFacing().m_122434_() == Direction.Axis.Z ? 3 : 2)), (double)(this.m_58899_().m_123342_() + 3), (double)(this.m_58899_().m_123343_() + (this.getFacing().m_122434_() == Direction.Axis.X ? 3 : 2)));
    }

    @Override
    @Nonnull
    public VoxelShape getCollisionShape(CollisionContext ctx) {
        return this.getShape(COLLISION_SHAPES);
    }

    private static List<AABB> getCollisionShape(BlockPos posInMultiblock) {
        if (ImmutableSet.of((Object)new BlockPos(3, 0, 4), (Object)new BlockPos(1, 0, 4)).contains((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 0.5625));
        }
        if (posInMultiblock.m_123342_() == 0 && posInMultiblock.m_123343_() > 0 && !posInMultiblock.equals((Object)new BlockPos(2, 0, 4))) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        }
        if (new BlockPos(0, 1, 4).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0));
        }
        if (new BoundingBox(1, 1, 1, 3, 1, 2).m_71051_((Vec3i)posInMultiblock)) {
            AABB aabb = posInMultiblock.m_123341_() == 2 ? new AABB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0) : Utils.flipBox(false, posInMultiblock.m_123341_() == 3, new AABB(0.125, 0.5, 0.125, 1.0, 1.0, 0.875));
            if (posInMultiblock.m_123343_() == 2) {
                aabb = aabb.m_82386_(0.0, 0.0, 0.875);
            }
            return ImmutableList.of((Object)aabb);
        }
        if (ImmutableSet.of((Object)new BlockPos(4, 1, 1), (Object)new BlockPos(0, 1, 1)).contains((Object)posInMultiblock)) {
            return Utils.flipBoxes(false, posInMultiblock.m_123341_() == 4, new AABB(0.125, 0.125, 0.0, 0.375, 0.375, 1.0));
        }
        if (posInMultiblock.m_123343_() == 0 && posInMultiblock.m_123342_() == 1 && posInMultiblock.m_123341_() >= 1 && posInMultiblock.m_123341_() <= 3) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.25, 1.0, 1.0, 1.0));
        }
        if (new BlockPos(2, 3, 0).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625));
        }
        if (new BlockPos(2, 4, 0).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.3125, 1.0, 0.9375, 1.0));
        }
        if (new BlockPos(2, 4, 1).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AABB(0.0, 0.625, 0.0, 1.0, 0.9375, 1.0));
        }
        if (new BlockPos(2, 4, 2).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.0, 1.0, 0.9375, 0.875));
        }
        if (ImmutableSet.of((Object)new BlockPos(3, 2, 4), (Object)new BlockPos(1, 2, 4), (Object)new BlockPos(3, 3, 0), (Object)new BlockPos(1, 3, 0), (Object)new BlockPos(3, 4, 0), (Object)new BlockPos(1, 4, 0), (Object[])new BlockPos[0]).contains((Object)posInMultiblock)) {
            return Utils.flipBoxes(false, posInMultiblock.m_123341_() == 3, new AABB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0));
        }
        return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    @Override
    public VoxelShape getSelectionShape(@Nullable CollisionContext ctx) {
        return this.getShape(SHAPES);
    }

    private static List<AABB> getShape(BlockPos posInMultiblock) {
        if (new BlockPos(0, 0, 4).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), (Object)new AABB(0.125, 0.5, 0.625, 0.25, 1.0, 0.875), (Object)new AABB(0.75, 0.5, 0.625, 0.875, 1.0, 0.875));
        }
        if (posInMultiblock.m_123343_() == 0 && posInMultiblock.m_123342_() == 1 && posInMultiblock.m_123341_() >= 1 && posInMultiblock.m_123341_() <= 3) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.25, 1.0, 1.0, 1.0), (Object)new AABB(0.25, 0.25, 0.0, 0.75, 0.75, 0.25));
        }
        if (posInMultiblock.m_123341_() % 4 == 0 && posInMultiblock.m_123343_() <= 2) {
            double maxX;
            ArrayList list = posInMultiblock.m_123342_() == 0 ? Lists.newArrayList((Object[])new AABB[]{new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)}) : new ArrayList(2);
            boolean flip = posInMultiblock.m_123341_() == 4;
            double minX = !flip ? 0.5 : 0.0;
            double d = maxX = flip ? 0.5 : 1.0;
            if (posInMultiblock.m_123341_() != 3) {
                list.add(new AABB(minX, posInMultiblock.m_123342_() == 0 ? 0.5 : 0.0, 0.0, maxX, 1.0, 1.0));
            }
            if (posInMultiblock.m_123342_() == 0) {
                int move = 4 - posInMultiblock.m_123343_() - 2;
                minX = !flip ? 0.125 : 0.625;
                maxX = !flip ? 0.375 : 0.875;
                AABB aabb = new AABB(minX, 0.6875, -1.625, maxX, 0.9375, 0.625);
                aabb = aabb.m_82386_(0.0, 0.0, (double)move);
                list.add(aabb);
                minX = !flip ? 0.375 : 0.5;
                maxX = !flip ? 0.5 : 0.625;
                aabb = new AABB(minX, 0.6875, 0.375, maxX, 0.9375, 0.625);
                aabb = aabb.m_82386_(0.0, 0.0, (double)move);
                list.add(aabb);
                minX = !flip ? 0.375 : 0.5;
                maxX = !flip ? 0.5 : 0.625;
                aabb = new AABB(minX, 0.6875, -1.625, maxX, 0.9375, -1.375);
                aabb = aabb.m_82386_(0.0, 0.0, (double)move);
                list.add(aabb);
            } else if (posInMultiblock.m_123342_() == 1) {
                int move = 4 - posInMultiblock.m_123343_() - 2;
                minX = !flip ? 0.125 : 0.625;
                maxX = !flip ? 0.375 : 0.875;
                AABB aabb = new AABB(minX, 0.125, -1.625, maxX, 0.375, 0.625);
                aabb = aabb.m_82386_(0.0, 0.0, (double)move);
                list.add(aabb);
                minX = !flip ? 0.375 : 0.5;
                maxX = !flip ? 0.5 : 0.625;
                aabb = new AABB(minX, 0.125, 0.375, maxX, 0.375, 0.625);
                aabb = aabb.m_82386_(0.0, 0.0, (double)move);
                if (posInMultiblock.m_123341_() == 0) {
                    aabb = aabb.m_82386_(0.0, 0.6875, 0.0);
                }
                list.add(aabb);
                if (posInMultiblock.m_123341_() == 0) {
                    minX = !flip ? 0.125 : 0.625;
                    maxX = !flip ? 0.375 : 0.875;
                    aabb = new AABB(minX, 0.375, 0.375, maxX, 1.0625, 0.625);
                    aabb = aabb.m_82386_(0.0, 0.0, (double)move);
                    list.add(aabb);
                }
                minX = !flip ? 0.375 : 0.5;
                maxX = !flip ? 0.5 : 0.625;
                aabb = new AABB(minX, 0.125, -1.625, maxX, 0.375, -1.375);
                aabb = aabb.m_82386_(0.0, 0.0, (double)move);
                list.add(aabb);
            } else if (ImmutableSet.of((Object)new BlockPos(4, 2, 2), (Object)new BlockPos(0, 2, 2)).contains((Object)posInMultiblock)) {
                minX = !flip ? 0.375 : 0.5;
                maxX = !flip ? 0.5 : 0.625;
                list.add(new AABB(minX, 0.25, 0.25, maxX, 0.75, 0.75));
            }
            return list;
        }
        return ArcFurnaceBlockEntity.getCollisionShape(posInMultiblock);
    }

    @Override
    public Set<PoweredMultiblockBlockEntity.MultiblockFace> getEnergyPos() {
        return ImmutableSet.of((Object)new PoweredMultiblockBlockEntity.MultiblockFace(1, 1, 0, RelativeBlockFace.BACK), (Object)new PoweredMultiblockBlockEntity.MultiblockFace(2, 1, 0, RelativeBlockFace.BACK), (Object)new PoweredMultiblockBlockEntity.MultiblockFace(3, 1, 0, RelativeBlockFace.BACK));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(0, 1, 4));
    }

    private int getElectrodeComparatorValueOnMaster() {
        float f = 0.0f;
        for (int i = 23; i < 26; ++i) {
            if (((ItemStack)this.inventory.get(i)).m_41619_()) continue;
            f += 1.0f - (float)((ItemStack)this.inventory.get(i)).m_41773_() / (float)((ItemStack)this.inventory.get(i)).m_41776_();
        }
        return Mth.m_14167_((float)(Math.max(f / 3.0f, 0.0f) * 15.0f));
    }

    @Override
    public int getComparatorInputOverride() {
        ArcFurnaceBlockEntity master;
        if (ELECTRODE_COMPARATOR_POS.equals((Object)this.posInMultiblock) && (master = (ArcFurnaceBlockEntity)this.master()) != null) {
            return master.getElectrodeComparatorValueOnMaster();
        }
        return super.getComparatorInputOverride();
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean shouldRenderAsActiveImpl() {
        return this.hasElectrodes() && super.shouldRenderAsActiveImpl();
    }

    @Override
    public boolean additionalCanProcessCheck(MultiblockProcess<ArcFurnaceRecipe> process) {
        if (!this.hasElectrodes()) {
            return false;
        }
        ArcFurnaceRecipe recipe = process.getRecipe(this.f_58857_);
        if (recipe != null && !((ItemStack)recipe.slag.get()).m_41619_()) {
            if (((ItemStack)this.inventory.get(22)).m_41619_()) {
                return true;
            }
            return ItemHandlerHelper.canItemStacksStack((ItemStack)((ItemStack)this.inventory.get(22)), (ItemStack)((ItemStack)recipe.slag.get())) && ((ItemStack)this.inventory.get(22)).m_41613_() + ((ItemStack)recipe.slag.get()).m_41613_() <= this.getSlotLimit(22);
        }
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.output, output, false)).m_41619_()) {
            BlockPos pos = this.m_58899_().m_142082_(0, -1, 0).m_5484_(this.getFacing(), -2);
            Utils.dropStackAtPos(this.f_58857_, pos, output, this.getFacing());
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(MultiblockProcess<ArcFurnaceRecipe> process) {
        ArcFurnaceRecipe recipe = process.getRecipe(this.f_58857_);
        if (recipe != null && !((ItemStack)recipe.slag.get()).m_41619_()) {
            if (((ItemStack)this.inventory.get(22)).m_41619_()) {
                this.inventory.set(22, (Object)((ItemStack)recipe.slag.get()).m_41777_());
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)((ItemStack)this.inventory.get(22)), (ItemStack)((ItemStack)recipe.slag.get())) || ((ItemStack)this.inventory.get(22)).m_41613_() + ((ItemStack)recipe.slag.get()).m_41613_() > this.getSlotLimit(22)) {
                ((ItemStack)this.inventory.get(22)).m_41769_(((ItemStack)recipe.slag.get()).m_41613_());
            }
        }
    }

    @Override
    public int getMaxProcessPerTick() {
        return 12;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 12;
    }

    @Override
    public float getMinProcessDistance(MultiblockProcess<ArcFurnaceRecipe> process) {
        return 0.0f;
    }

    @Override
    public int getComparatedSize() {
        return 12;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return slot > 22 ? 1 : 64;
    }

    @Override
    public int[] getOutputSlots() {
        return OUTPUT_SLOTS;
    }

    @Override
    public int[] getOutputTanks() {
        return null;
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return null;
    }

    @Override
    public void doGraphicalUpdates() {
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.posInMultiblock == MAIN_OUT_POS) {
                return this.outputHandler.getAndCast();
            }
            if (this.posInMultiblock == SLAG_OUT_POS) {
                return this.slagHandler.getAndCast();
            }
            if (new BlockPos(1, 3, 2).equals((Object)this.posInMultiblock)) {
                return this.inputHandler.getAndCast();
            }
            if (new BlockPos(3, 3, 2).equals((Object)this.posInMultiblock)) {
                return this.additiveHandler.getAndCast();
            }
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public ArcFurnaceRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected ArcFurnaceRecipe getRecipeForId(Level level, ResourceLocation id) {
        return ArcFurnaceRecipe.RECIPES.getById(level, id);
    }

    @Override
    @Nullable
    protected MultiblockProcess<ArcFurnaceRecipe> loadProcessFromNBT(CompoundTag tag) {
        ResourceLocation id = new ResourceLocation(tag.m_128461_("recipe"));
        long seed = tag.m_128454_("seed");
        MultiblockProcessArcFurnace process = new MultiblockProcessArcFurnace(id, this::getRecipeForId, seed, tag.m_128465_("process_inputSlots"));
        if (tag.m_128425_("process_inputAmounts", 11)) {
            process.setInputAmounts(tag.m_128465_("process_inputAmounts"));
        }
        return process;
    }

    @Override
    protected CompoundTag writeProcessToNBT(MultiblockProcess<?> process) {
        CompoundTag processNBT = super.writeProcessToNBT(process);
        if (process instanceof MultiblockProcessArcFurnace) {
            MultiblockProcessArcFurnace arcProcess = (MultiblockProcessArcFurnace)process;
            processNBT.m_128356_("seed", arcProcess.seed);
        }
        return processNBT;
    }

    @Override
    public boolean canUseGui(Player player) {
        return this.formed && (specialGuiPositions.contains(this.posInMultiblock) || this.posInMultiblock.m_123342_() > 0 && this.posInMultiblock.m_123341_() > 0 && this.posInMultiblock.m_123341_() < 4 && this.posInMultiblock.m_123343_() == 4 || !this.isDummy());
    }

    @Override
    public ArcFurnaceBlockEntity getGuiMaster() {
        return (ArcFurnaceBlockEntity)this.master();
    }

    @Override
    public IEContainerTypes.BEContainer<ArcFurnaceBlockEntity, ?> getContainerType() {
        return IEContainerTypes.ARC_FURNACE;
    }

    @Override
    public boolean shouldPlaySound(String sound) {
        return false;
    }

    public boolean hasElectrodes() {
        for (int i = 23; i < 26; ++i) {
            if (!((ItemStack)this.inventory.get(i)).m_41619_()) continue;
            return false;
        }
        return true;
    }

    static {
        for (int i = 0; i < 6; ++i) {
            ArcFurnaceBlockEntity.OUTPUT_SLOTS[i] = 16 + i;
        }
        COLLISION_SHAPES = CachedShapesWithTransform.createForMultiblock(ArcFurnaceBlockEntity::getCollisionShape);
        SHAPES = CachedShapesWithTransform.createForMultiblock(ArcFurnaceBlockEntity::getShape);
        ELECTRODE_COMPARATOR_POS = new BlockPos(2, 4, 2);
        specialGuiPositions = ImmutableSet.of((Object)new BlockPos(2, 0, 4), (Object)new BlockPos(0, 1, 4));
    }

    public static class MultiblockProcessArcFurnace
    extends MultiblockProcessInMachine<ArcFurnaceRecipe> {
        private final long seed;

        public MultiblockProcessArcFurnace(ResourceLocation id, BiFunction<Level, ResourceLocation, ArcFurnaceRecipe> getRecipe, long seed, int ... inputSlots) {
            super(id, getRecipe, inputSlots);
            this.seed = seed;
        }

        public MultiblockProcessArcFurnace(ArcFurnaceRecipe recipe, BiFunction<Level, ResourceLocation, ArcFurnaceRecipe> getRecipe, long seed, int ... inputSlots) {
            super(recipe, getRecipe, inputSlots);
            this.seed = seed;
        }

        protected NonNullList<ItemStack> getRecipeItemOutputs(PoweredMultiblockBlockEntity<?, ArcFurnaceRecipe> multiblock) {
            ArcFurnaceRecipe recipe = (ArcFurnaceRecipe)this.getRecipe(multiblock.m_58904_());
            if (recipe == null) {
                return NonNullList.m_122779_();
            }
            ItemStack input = (ItemStack)multiblock.getInventory().get(this.inputSlots[0]);
            NonNullList additives = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
            for (int i = 0; i < 4; ++i) {
                additives.set(i, (Object)((ItemStack)multiblock.getInventory().get(12 + i)).m_41777_());
            }
            return recipe.generateActualOutput(input, (NonNullList<ItemStack>)additives, this.seed);
        }

        @Override
        protected void processFinish(PoweredMultiblockBlockEntity<?, ArcFurnaceRecipe> te) {
            super.processFinish(te);
            te.getLevelNonnull().m_7696_(te.m_58899_(), te.m_58900_().m_60734_(), 0, 40);
        }
    }
}

