/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.blocks.metal.TurretBlockEntity;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.network.MessageBlockEntitySync;
import blusunrize.immersiveengineering.common.register.IEContainerTypes;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;

public class TurretGunBlockEntity
extends TurretBlockEntity<TurretGunBlockEntity> {
    public int cycleRender;
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    public boolean expelCasings = false;
    private final ResettableCapability<IItemHandler> itemHandler = this.registerCapability(new IEInventoryHandler(2, (IIEInventory)this, 0, new boolean[]{true, false}, new boolean[]{false, true}));
    public final ResettableCapability<IItemHandler> containerHandler = this.registerCapability(new IEInventoryHandler(2, this));

    public TurretGunBlockEntity(BlockEntityType<TurretGunBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected double getRange() {
        return 16.0;
    }

    @Override
    protected boolean canActivate() {
        return this.energyStorage.getEnergyStored() >= (Integer)IEServerConfig.MACHINES.turret_gun_consumption.get() && !((ItemStack)this.inventory.get(0)).m_41619_();
    }

    @Override
    protected int getChargeupTicks() {
        return 5;
    }

    @Override
    protected int getActiveTicks() {
        return 5;
    }

    @Override
    protected boolean loopActivation() {
        return false;
    }

    @Override
    protected void activate() {
        BulletHandler.IBullet bullet;
        int energy = (Integer)IEServerConfig.MACHINES.turret_gun_consumption.get();
        ItemStack bulletStack = (ItemStack)this.inventory.get(0);
        if (bulletStack.m_41720_() instanceof BulletItem && this.energyStorage.extractEnergy(energy, true) == energy && (bullet = ((BulletItem)bulletStack.m_41720_()).getType()) != null && bullet.isValidForTurret()) {
            ItemStack casing = bullet.getCasing(bulletStack);
            if (this.expelCasings || casing.m_41619_() || ((ItemStack)this.inventory.get(1)).m_41619_() || ItemStack.m_41746_((ItemStack)casing, (ItemStack)((ItemStack)this.inventory.get(1))) && ((ItemStack)this.inventory.get(1)).m_41613_() + casing.m_41613_() <= ((ItemStack)this.inventory.get(1)).m_41741_()) {
                SoundEvent sound;
                this.energyStorage.extractEnergy(energy, false);
                this.sendRenderPacket();
                Vec3 vec = this.getGunToTargetVec(this.target).m_82541_();
                int count = bullet.getProjectileCount(null);
                if (count == 1) {
                    RevolvershotEntity entBullet = this.getBulletEntity(this.f_58857_, vec, bullet);
                    this.f_58857_.m_7967_(bullet.getProjectile(null, bulletStack, (Entity)entBullet, false));
                } else {
                    for (int i = 0; i < count; ++i) {
                        Vec3 vecDir = vec.m_82520_(Utils.RAND.nextGaussian() * 0.1, Utils.RAND.nextGaussian() * 0.1, Utils.RAND.nextGaussian() * 0.1);
                        RevolvershotEntity entBullet = this.getBulletEntity(this.f_58857_, vecDir, bullet);
                        this.f_58857_.m_7967_(bullet.getProjectile(null, bulletStack, (Entity)entBullet, false));
                    }
                }
                bulletStack.m_41774_(1);
                if (bulletStack.m_41613_() <= 0) {
                    this.inventory.set(0, (Object)ItemStack.f_41583_);
                }
                if (!casing.m_41619_()) {
                    if (this.expelCasings) {
                        double cX = (double)this.m_58899_().m_123341_() + 0.5;
                        double cY = (double)this.m_58899_().m_123342_() + 1.375;
                        double cZ = (double)this.m_58899_().m_123343_() + 0.5;
                        Vec3 vCasing = vec.m_82524_(-1.57f);
                        this.f_58857_.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, cX + vCasing.f_82479_, cY + vCasing.f_82480_, cZ + vCasing.f_82481_, 0.0, 0.0, 0.0);
                        ItemEntity entCasing = new ItemEntity(this.f_58857_, cX + vCasing.f_82479_, cY + vCasing.f_82480_, cZ + vCasing.f_82481_, casing.m_41777_());
                        entCasing.m_20334_(0.0, -0.01, 0.0);
                        this.f_58857_.m_7967_((Entity)entCasing);
                    } else if (((ItemStack)this.inventory.get(1)).m_41619_()) {
                        this.inventory.set(1, (Object)casing.m_41777_());
                    } else {
                        ((ItemStack)this.inventory.get(1)).m_41769_(casing.m_41613_());
                    }
                }
                if ((sound = bullet.getSound()) == null) {
                    sound = IESounds.revolverFire;
                }
                this.f_58857_.m_5594_(null, this.m_58899_(), sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    protected void sendRenderPacket() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("cycle", true);
        ImmersiveEngineering.packetHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.getLevelNonnull().m_46745_(this.f_58858_)), (Object)new MessageBlockEntitySync(this, tag));
    }

    RevolvershotEntity getBulletEntity(Level world, Vec3 vecDir, BulletHandler.IBullet type) {
        Vec3 gunPos = this.getGunPosition();
        RevolvershotEntity bullet = new RevolvershotEntity(world, gunPos.f_82479_ + vecDir.f_82479_, gunPos.f_82480_ + vecDir.f_82480_, gunPos.f_82481_ + vecDir.f_82481_, 0.0, 0.0, 0.0, type);
        bullet.m_20256_(vecDir);
        return bullet;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        if (slot == 0) {
            return stack.m_41720_() instanceof BulletItem;
        }
        return true;
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (!this.isDummy() && this.cycleRender > 0) {
            --this.cycleRender;
        }
    }

    @Override
    public void receiveMessageFromServer(CompoundTag message) {
        if (message.m_128441_("cycle")) {
            this.cycleRender = 5;
        }
    }

    @Override
    public void receiveMessageFromClient(CompoundTag message) {
        super.receiveMessageFromClient(message);
        if (message.m_128425_("expelCasings", 1)) {
            this.expelCasings = message.m_128471_("expelCasings");
        }
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (!descPacket) {
            this.expelCasings = nbt.m_128471_("expelCasings");
            ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!descPacket) {
            nbt.m_128379_("expelCasings", this.expelCasings);
            ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        }
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (!(this.isDummy() || capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || facing != null && facing != Direction.DOWN && facing != this.getFacing().m_122424_())) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public IEContainerTypes.BEContainer<TurretGunBlockEntity, ?> getContainerType() {
        return IEContainerTypes.GUN_TURRET;
    }
}

