/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.register;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.fluids.ConcreteFluid;
import blusunrize.immersiveengineering.common.fluids.IEFluid;
import blusunrize.immersiveengineering.common.fluids.IEFluidBlock;
import blusunrize.immersiveengineering.common.fluids.PotionFluid;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class IEFluids {
    public static final DeferredRegister<Fluid> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"immersiveengineering");
    public static final List<FluidEntry> ALL_ENTRIES = new ArrayList<FluidEntry>();
    public static final Set<IEBlocks.BlockEntry<? extends LiquidBlock>> ALL_FLUID_BLOCKS = new HashSet<IEBlocks.BlockEntry<? extends LiquidBlock>>();
    public static final FluidEntry CREOSOTE = new FluidEntry("creosote", 800, ImmersiveEngineering.rl("block/fluid/creosote_still"), ImmersiveEngineering.rl("block/fluid/creosote_flow"));
    public static final FluidEntry PLANTOIL = new FluidEntry("plantoil", ImmersiveEngineering.rl("block/fluid/plantoil_still"), ImmersiveEngineering.rl("block/fluid/plantoil_flow"));
    public static final FluidEntry ETHANOL = new FluidEntry("ethanol", ImmersiveEngineering.rl("block/fluid/ethanol_still"), ImmersiveEngineering.rl("block/fluid/ethanol_flow"));
    public static final FluidEntry BIODIESEL = new FluidEntry("biodiesel", ImmersiveEngineering.rl("block/fluid/biodiesel_still"), ImmersiveEngineering.rl("block/fluid/biodiesel_flow"));
    public static final FluidEntry CONCRETE = new FluidEntry("concrete", ImmersiveEngineering.rl("block/fluid/concrete_still"), ImmersiveEngineering.rl("block/fluid/concrete_flow"), ConcreteFluid::new, ConcreteFluid.Flowing::new, IEFluid.createBuilder(2400, 4000), ImmutableList.of((Object)IEProperties.INT_32));
    public static final FluidEntry HERBICIDE = new FluidEntry("herbicide", ImmersiveEngineering.rl("block/fluid/herbicide_still"), ImmersiveEngineering.rl("block/fluid/herbicide_flow"));
    public static final FluidEntry REDSTONE_ACID = new FluidEntry("redstone_acid", ImmersiveEngineering.rl("block/fluid/redstone_acid_still"), ImmersiveEngineering.rl("block/fluid/redstone_acid_flow"));
    public static final RegistryObject<PotionFluid> POTION = REGISTER.register("potion", PotionFluid::new);
    public static final FluidEntry ACETALDEHYDE = new FluidEntry("acetaldehyde", ImmersiveEngineering.rl("block/fluid/acetaldehyde_still"), ImmersiveEngineering.rl("block/fluid/acetaldehyde_flow"), IEFluid.createGasBuilder(788, 210));
    public static final FluidEntry PHENOLIC_RESIN = new FluidEntry("phenolic_resin", ImmersiveEngineering.rl("block/fluid/resin_still"), ImmersiveEngineering.rl("block/fluid/resin_flow"), IEFluid.createBuilder(1100, 2800));

    public static class FluidEntry {
        private final RegistryObject<IEFluid> flowing;
        private final RegistryObject<IEFluid> still;
        private final IEBlocks.BlockEntry<IEFluidBlock> block;
        private final RegistryObject<BucketItem> bucket;
        private final List<Property<?>> properties;

        private FluidEntry(String name, ResourceLocation stillTex, ResourceLocation flowingTex) {
            this(name, 0, stillTex, flowingTex);
        }

        private FluidEntry(String name, ResourceLocation stillTex, ResourceLocation flowingTex, Consumer<FluidAttributes.Builder> buildAttributes) {
            this(name, 0, stillTex, flowingTex, buildAttributes);
        }

        private FluidEntry(String name, int burnTime, ResourceLocation stillTex, ResourceLocation flowingTex) {
            this(name, burnTime, stillTex, flowingTex, null);
        }

        private FluidEntry(String name, int burnTime, ResourceLocation stillTex, ResourceLocation flowingTex, @Nullable Consumer<FluidAttributes.Builder> buildAttributes) {
            this(name, burnTime, stillTex, flowingTex, IEFluid::new, IEFluid.Flowing::new, buildAttributes, (List<Property<?>>)ImmutableList.of());
        }

        private FluidEntry(String name, ResourceLocation stillTex, ResourceLocation flowingTex, IEFluid.FluidConstructor makeStill, IEFluid.FluidConstructor makeFlowing, @Nullable Consumer<FluidAttributes.Builder> buildAttributes, ImmutableList<Property<?>> properties) {
            this(name, 0, stillTex, flowingTex, makeStill, makeFlowing, buildAttributes, (List<Property<?>>)properties);
        }

        private FluidEntry(String name, int burnTime, ResourceLocation stillTex, ResourceLocation flowingTex, IEFluid.FluidConstructor makeStill, IEFluid.FluidConstructor makeFlowing, @Nullable Consumer<FluidAttributes.Builder> buildAttributes, List<Property<?>> properties) {
            this.properties = properties;
            MutableObject thisMutable = new MutableObject();
            this.still = REGISTER.register(name, () -> FluidEntry.lambda$new$0(makeStill, (Mutable)thisMutable, stillTex, flowingTex, buildAttributes));
            this.flowing = REGISTER.register(name + "_flowing", () -> FluidEntry.lambda$new$1(makeFlowing, (Mutable)thisMutable, stillTex, flowingTex, buildAttributes));
            this.block = new IEBlocks.BlockEntry<IEFluidBlock>(name + "_fluid_block", () -> BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_), arg_0 -> FluidEntry.lambda$new$3((Mutable)thisMutable, arg_0));
            this.bucket = IEItems.REGISTER.register(name + "_bucket", () -> FluidEntry.makeBucket(this.still, burnTime));
            thisMutable.setValue((Object)this);
            ALL_FLUID_BLOCKS.add(this.block);
            ALL_ENTRIES.add(this);
        }

        public IEFluid getFlowing() {
            return (IEFluid)((Object)this.flowing.get());
        }

        public IEFluid getStill() {
            return (IEFluid)((Object)this.still.get());
        }

        public IEFluidBlock getBlock() {
            return this.block.get();
        }

        public BucketItem getBucket() {
            return (BucketItem)this.bucket.get();
        }

        public List<Property<?>> getProperties() {
            return this.properties;
        }

        private static BucketItem makeBucket(RegistryObject<IEFluid> still, final int burnTime) {
            BucketItem result = new BucketItem((Supplier)still, new Item.Properties().m_41487_(1).m_41491_(ImmersiveEngineering.ITEM_GROUP).m_41495_(Items.f_42446_)){

                public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
                    return new FluidBucketWrapper(stack);
                }

                public int getBurnTime(ItemStack itemStack, RecipeType<?> type) {
                    return burnTime;
                }
            };
            return result;
        }

        public RegistryObject<IEFluid> getStillGetter() {
            return this.still;
        }

        private static /* synthetic */ IEFluidBlock lambda$new$3(Mutable thisMutable, BlockBehaviour.Properties p) {
            return new IEFluidBlock((FluidEntry)thisMutable.getValue(), p);
        }

        private static /* synthetic */ IEFluid lambda$new$1(IEFluid.FluidConstructor makeFlowing, Mutable thisMutable, ResourceLocation stillTex, ResourceLocation flowingTex, Consumer buildAttributes) {
            return IEFluid.makeFluid(makeFlowing, (FluidEntry)thisMutable.getValue(), stillTex, flowingTex, buildAttributes);
        }

        private static /* synthetic */ IEFluid lambda$new$0(IEFluid.FluidConstructor makeStill, Mutable thisMutable, ResourceLocation stillTex, ResourceLocation flowingTex, Consumer buildAttributes) {
            return IEFluid.makeFluid(makeStill, (FluidEntry)thisMutable.getValue(), stillTex, flowingTex, buildAttributes);
        }
    }
}

