/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.worldsave.biome;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import xaero.map.biome.BiomeKey;
import xaero.map.biome.BiomeKeyManager;
import xaero.map.file.worldsave.biome.WorldDataReaderChunkBiomeData;
import xaero.map.file.worldsave.biome.WorldDataReaderSectionBiomeData;

public class WorldDataBiomeManager
implements BiomeManager.NoiseBiomeSource {
    private final WorldDataReaderChunkBiomeData[] chunkBiomeData = new WorldDataReaderChunkBiomeData[1156];
    private final BiomeKeyManager biomeKeyManager;
    private int regionX;
    private int regionZ;
    private Biome theVoid;
    private Biome defaultBiome;
    private Registry<Biome> biomeRegistry;
    private BlockPos.MutableBlockPos mutableBlockPos;

    public WorldDataBiomeManager(BiomeKeyManager biomeKeyManager) {
        for (int i = 0; i < this.chunkBiomeData.length; ++i) {
            this.chunkBiomeData[i] = new WorldDataReaderChunkBiomeData();
        }
        this.biomeKeyManager = biomeKeyManager;
        this.mutableBlockPos = new BlockPos.MutableBlockPos();
    }

    public void resetChunkBiomeData(int regionX, int regionZ, Biome defaultBiome, Registry<Biome> biomeRegistry) {
        this.regionX = regionX;
        this.regionZ = regionZ;
        this.biomeRegistry = biomeRegistry;
        this.theVoid = (Biome)biomeRegistry.m_6246_(Biomes.f_48173_);
    }

    public void clear() {
        for (int i = 0; i < this.chunkBiomeData.length; ++i) {
            this.chunkBiomeData[i].clear();
        }
    }

    private WorldDataReaderChunkBiomeData getChunkBiomeData(int chunkX, int chunkZ) {
        if (chunkX < -1 || chunkZ < -1 || chunkX > 32 || chunkZ > 32) {
            return null;
        }
        return this.chunkBiomeData[(chunkZ + 1) * 34 + chunkX + 1];
    }

    public void addBiomeSectionForRegionChunk(int chunkX, int chunkZ, int sectionIndex, WorldDataReaderSectionBiomeData section) {
        this.getChunkBiomeData(chunkX, chunkZ).addSection(sectionIndex, section);
    }

    public Biome getBiome(BiomeManager biomeZoomer, int x, int y, int z) {
        this.defaultBiome = null;
        this.defaultBiome = (Biome)this.m_203495_(x >> 2, y >> 2, z >> 2).m_203334_();
        if (this.defaultBiome == null) {
            this.defaultBiome = this.theVoid;
        }
        this.mutableBlockPos.m_122178_(x, y, z);
        return (Biome)biomeZoomer.m_204214_((BlockPos)this.mutableBlockPos).m_203334_();
    }

    public Holder<Biome> m_203495_(int x, int y, int z) {
        int relativeX = x - this.regionX * 128;
        int relativeZ = z - this.regionZ * 128;
        int chunkX = relativeX >> 2;
        int chunkZ = relativeZ >> 2;
        int quadX = relativeX & 3;
        int quadZ = relativeZ & 3;
        WorldDataReaderChunkBiomeData chunkBiomeData = this.getChunkBiomeData(chunkX, chunkZ);
        if (chunkBiomeData == null) {
            return Holder.m_205709_((Object)this.defaultBiome);
        }
        BiomeKey key = chunkBiomeData.getNoiseBiomeKey(quadX, y, quadZ, this.biomeKeyManager);
        if (key == null) {
            return Holder.m_205709_((Object)this.defaultBiome);
        }
        return Holder.m_205709_((Object)this.biomeKeyManager.getBiome(key, this.biomeRegistry));
    }
}

