/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.modular_accumulator;

import com.mrh0.createaddition.blocks.modular_accumulator.ModularAccumulatorTileEntity;
import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.simibubi.create.foundation.tileEntity.IMultiTileContainer;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.energy.CapabilityEnergy;
import org.apache.commons.lang3.tuple.Pair;

public class CAConnectivityHandler {
    public static <T extends BlockEntity> void formMulti(T be) {
        SearchCache cache = new SearchCache();
        ArrayList<T> frontier = new ArrayList<T>();
        frontier.add(be);
        CAConnectivityHandler.formMulti(be.m_58903_(), (BlockGetter)be.m_58904_(), cache, frontier);
    }

    private static <T extends BlockEntity> void formMulti(BlockEntityType<?> type, BlockGetter level, SearchCache<T> cache, List<T> frontier) {
        PriorityQueue<Pair<Integer, T>> creationQueue = CAConnectivityHandler.makeCreationQueue();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        Direction.Axis mainAxis = ((IMultiTileContainer)((BlockEntity)frontier.get(0))).getMainConnectionAxis();
        int minX = mainAxis == Direction.Axis.Y ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        int minY = mainAxis != Direction.Axis.Y ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        int minZ = mainAxis == Direction.Axis.Y ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        for (BlockEntity be : frontier) {
            BlockPos pos = be.m_58899_();
            minX = Math.min(pos.m_123341_(), minX);
            minY = Math.min(pos.m_123342_(), minY);
            minZ = Math.min(pos.m_123343_(), minZ);
        }
        if (mainAxis == Direction.Axis.Y) {
            minX -= ((IMultiTileContainer)((BlockEntity)frontier.get(0))).getMaxWidth();
        }
        if (mainAxis != Direction.Axis.Y) {
            minY -= ((IMultiTileContainer)((BlockEntity)frontier.get(0))).getMaxWidth();
        }
        if (mainAxis == Direction.Axis.Y) {
            minZ -= ((IMultiTileContainer)((BlockEntity)frontier.get(0))).getMaxWidth();
        }
        while (!frontier.isEmpty()) {
            BlockEntity part = (BlockEntity)frontier.remove(0);
            BlockPos partPos = part.m_58899_();
            if (visited.contains(partPos)) continue;
            visited.add(partPos);
            int amount = CAConnectivityHandler.tryToFormNewMulti(part, cache, true);
            if (amount > 1) {
                creationQueue.add(Pair.of((Object)amount, (Object)part));
            }
            for (Direction.Axis axis : Iterate.axes) {
                T nextBe;
                Direction dir = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis);
                BlockPos next = partPos.m_142300_(dir);
                if (next.m_123341_() <= minX || next.m_123342_() <= minY || next.m_123343_() <= minZ || visited.contains(next) || (nextBe = CAConnectivityHandler.partAt(type, level, next)) == null || nextBe.m_58901_()) continue;
                frontier.add(nextBe);
            }
        }
        visited.clear();
        while (!creationQueue.isEmpty()) {
            Pair<Integer, T> next = creationQueue.poll();
            BlockEntity toCreate = (BlockEntity)next.getValue();
            if (visited.contains(toCreate.m_58899_())) continue;
            visited.add(toCreate.m_58899_());
            CAConnectivityHandler.tryToFormNewMulti(toCreate, cache, false);
        }
    }

    private static <T extends BlockEntity> int tryToFormNewMulti(T be, SearchCache<T> cache, boolean simulate) {
        int bestWidth = 1;
        int bestAmount = -1;
        if (!((IMultiTileContainer)be).isController()) {
            return 0;
        }
        int radius = ((IMultiTileContainer)be).getMaxWidth();
        for (int w = 1; w <= radius; ++w) {
            int amount = CAConnectivityHandler.tryToFormNewMultiOfWidth(be, w, cache, true);
            if (amount < bestAmount) continue;
            bestWidth = w;
            bestAmount = amount;
        }
        if (!simulate) {
            ModularAccumulatorTileEntity ienergy;
            int beWidth = ((IMultiTileContainer)be).getWidth();
            if (beWidth == bestWidth && beWidth * beWidth * ((IMultiTileContainer)be).getHeight() == bestAmount) {
                return bestAmount;
            }
            CAConnectivityHandler.splitMultiAndInvalidate(be, cache, false);
            if (be instanceof ModularAccumulatorTileEntity && (ienergy = (ModularAccumulatorTileEntity)be).hasAccumulator()) {
                ienergy.setSize(0, bestAmount);
            }
            CAConnectivityHandler.tryToFormNewMultiOfWidth(be, bestWidth, cache, false);
            ((IMultiTileContainer)be).preventConnectivityUpdate();
            ((IMultiTileContainer)be).setWidth(bestWidth);
            ((IMultiTileContainer)be).setHeight(bestAmount / bestWidth / bestWidth);
            ((IMultiTileContainer)be).notifyMultiUpdated();
        }
        return bestAmount;
    }

    private static <T extends BlockEntity> int tryToFormNewMultiOfWidth(T be, int width, SearchCache<T> cache, boolean simulate) {
        ModularAccumulatorTileEntity ienergy;
        int amount = 0;
        int height = 0;
        BlockEntityType type = be.m_58903_();
        Level level = be.m_58904_();
        if (level == null) {
            return 0;
        }
        BlockPos origin = be.m_58899_();
        InternalEnergyStorage beEnergy = null;
        if (be instanceof ModularAccumulatorTileEntity && (ienergy = (ModularAccumulatorTileEntity)be).hasAccumulator()) {
            beEnergy = ienergy.getEnergy(0);
        }
        Direction.Axis axis = ((IMultiTileContainer)be).getMainConnectionAxis();
        block10: for (int yOffset = 0; yOffset < ((IMultiTileContainer)be).getMaxLength(axis, width); ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    ModularAccumulatorTileEntity ienergyCon;
                    BlockPos conPos;
                    Direction.Axis conAxis;
                    BlockEntity controller;
                    int otherWidth;
                    BlockPos pos = switch (axis) {
                        default -> throw new IncompatibleClassChangeError();
                        case Direction.Axis.X -> origin.m_142082_(yOffset, xOffset, zOffset);
                        case Direction.Axis.Y -> origin.m_142082_(xOffset, yOffset, zOffset);
                        case Direction.Axis.Z -> origin.m_142082_(xOffset, zOffset, yOffset);
                    };
                    Optional<T> part = cache.getOrCache(type, (BlockGetter)level, pos);
                    if (part.isEmpty() || (otherWidth = ((IMultiTileContainer)(controller = (BlockEntity)part.get())).getWidth()) > width || otherWidth == width && ((IMultiTileContainer)controller).getHeight() == ((IMultiTileContainer)be).getMaxLength(axis, width) || axis != (conAxis = ((IMultiTileContainer)controller).getMainConnectionAxis()) || !(conPos = controller.m_58899_()).equals((Object)origin) && (axis != Direction.Axis.Y ? axis == Direction.Axis.Z && conPos.m_123341_() < origin.m_123341_() || conPos.m_123342_() < origin.m_123342_() || axis == Direction.Axis.X && conPos.m_123343_() < origin.m_123343_() || axis == Direction.Axis.Z && conPos.m_123341_() + otherWidth > origin.m_123341_() + width || conPos.m_123342_() + otherWidth > origin.m_123342_() + width || axis == Direction.Axis.X && conPos.m_123343_() + otherWidth > origin.m_123343_() + width : conPos.m_123341_() < origin.m_123341_() || conPos.m_123343_() < origin.m_123343_() || conPos.m_123341_() + otherWidth > origin.m_123341_() + width || conPos.m_123343_() + otherWidth > origin.m_123343_() + width)) break block10;
                    if (controller instanceof ModularAccumulatorTileEntity && !(ienergyCon = (ModularAccumulatorTileEntity)controller).hasAccumulator()) continue;
                }
            }
            amount += width * width;
            ++height;
        }
        if (simulate) {
            return amount;
        }
        Object extraData = ((IMultiTileContainer)be).getExtraData();
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    ModularAccumulatorTileEntity ienergyPart;
                    BlockPos pos = switch (axis) {
                        default -> throw new IncompatibleClassChangeError();
                        case Direction.Axis.X -> origin.m_142082_(yOffset, xOffset, zOffset);
                        case Direction.Axis.Y -> origin.m_142082_(xOffset, yOffset, zOffset);
                        case Direction.Axis.Z -> origin.m_142082_(xOffset, zOffset, yOffset);
                    };
                    T part = CAConnectivityHandler.partAt(type, (BlockGetter)level, pos);
                    if (part == null || part == be) continue;
                    extraData = ((IMultiTileContainer)be).modifyExtraData(extraData);
                    if (part instanceof ModularAccumulatorTileEntity && (ienergyPart = (ModularAccumulatorTileEntity)part).hasAccumulator()) {
                        ModularAccumulatorTileEntity ienergyBE;
                        InternalEnergyStorage storageAt = ienergyPart.getEnergy(0);
                        int energyAt = storageAt.getEnergyStored();
                        if (energyAt > 0 && be instanceof ModularAccumulatorTileEntity && (ienergyBE = (ModularAccumulatorTileEntity)be).hasAccumulator() && beEnergy != null) {
                            beEnergy.internalProduceEnergy(energyAt);
                        }
                        storageAt.internalConsumeEnergy(storageAt.getMaxEnergyStored());
                    }
                    CAConnectivityHandler.splitMultiAndInvalidate(part, cache, false);
                    ((IMultiTileContainer)part).setController(origin);
                    ((IMultiTileContainer)part).preventConnectivityUpdate();
                    cache.put(pos, be);
                    ((IMultiTileContainer)part).setHeight(height);
                    ((IMultiTileContainer)part).setWidth(width);
                    ((IMultiTileContainer)part).notifyMultiUpdated();
                }
            }
        }
        ((IMultiTileContainer)be).setExtraData(extraData);
        ((IMultiTileContainer)be).notifyMultiUpdated();
        return amount;
    }

    public static <T extends BlockEntity> void splitMulti(T be) {
        CAConnectivityHandler.splitMultiAndInvalidate(be, null, false);
    }

    private static <T extends BlockEntity> void splitMultiAndInvalidate(T be, @Nullable SearchCache<T> cache, boolean tryReconnect) {
        ModularAccumulatorTileEntity ienergy;
        ModularAccumulatorTileEntity ienergyBE;
        ModularAccumulatorTileEntity ienergyBE2;
        Level level = be.m_58904_();
        if (level == null) {
            return;
        }
        if ((be = ((IMultiTileContainer)be).getControllerTE()) == null) {
            return;
        }
        int height = ((IMultiTileContainer)be).getHeight();
        int width = ((IMultiTileContainer)be).getWidth();
        if (width == 1 && height == 1) {
            return;
        }
        BlockPos origin = be.m_58899_();
        ArrayList<T> frontier = new ArrayList<T>();
        Direction.Axis axis = ((IMultiTileContainer)be).getMainConnectionAxis();
        int toDistribute = 0;
        int maxCapacity = 0;
        if (be instanceof ModularAccumulatorTileEntity && (ienergyBE2 = (ModularAccumulatorTileEntity)be).hasAccumulator()) {
            toDistribute = ienergyBE2.getEnergy(0).getEnergyStored();
            maxCapacity = ienergyBE2.getSize(0);
            if (!be.m_58901_()) {
                ienergyBE2.getEnergy(0).internalConsumeEnergy(maxCapacity);
            }
            ienergyBE2.setSize(0, 1);
        }
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    BlockPos pos = switch (axis) {
                        default -> throw new IncompatibleClassChangeError();
                        case Direction.Axis.X -> origin.m_142082_(yOffset, xOffset, zOffset);
                        case Direction.Axis.Y -> origin.m_142082_(xOffset, yOffset, zOffset);
                        case Direction.Axis.Z -> origin.m_142082_(xOffset, zOffset, yOffset);
                    };
                    T partAt = CAConnectivityHandler.partAt(be.m_58903_(), (BlockGetter)level, pos);
                    if (partAt == null || !((IMultiTileContainer)partAt).getController().equals((Object)origin)) continue;
                    BlockEntity controllerBE = ((IMultiTileContainer)partAt).getControllerTE();
                    ((IMultiTileContainer)partAt).setExtraData(controllerBE == null ? null : ((IMultiTileContainer)controllerBE).getExtraData());
                    ((IMultiTileContainer)partAt).removeController(true);
                    if (partAt != be) {
                        int split;
                        InternalEnergyStorage internalEnergyStorage;
                        int copy = toDistribute;
                        if (partAt instanceof ModularAccumulatorTileEntity) {
                            ModularAccumulatorTileEntity ienergyPart = (ModularAccumulatorTileEntity)partAt;
                            internalEnergyStorage = ienergyPart.getEnergy(0);
                        } else {
                            internalEnergyStorage = null;
                        }
                        InternalEnergyStorage tank = internalEnergyStorage;
                        copy = split = Math.min(maxCapacity, toDistribute);
                        toDistribute -= split;
                        if (tank != null) {
                            tank.internalProduceEnergy(copy);
                        }
                    }
                    if (tryReconnect) {
                        frontier.add(partAt);
                        ((IMultiTileContainer)partAt).preventConnectivityUpdate();
                    }
                    if (cache == null) continue;
                    cache.put(pos, partAt);
                }
            }
        }
        if (be instanceof ModularAccumulatorTileEntity && (ienergyBE = (ModularAccumulatorTileEntity)be).hasAccumulator()) {
            ienergyBE.getEnergy(0).setEnergy(toDistribute);
        }
        if (be instanceof ModularAccumulatorTileEntity && (ienergy = (ModularAccumulatorTileEntity)be).hasAccumulator()) {
            be.getCapability(CapabilityEnergy.ENERGY).invalidate();
        }
        if (tryReconnect) {
            CAConnectivityHandler.formMulti(be.m_58903_(), (BlockGetter)level, cache == null ? new SearchCache<T>() : cache, frontier);
        }
    }

    private static <T extends BlockEntity> PriorityQueue<Pair<Integer, T>> makeCreationQueue() {
        return new PriorityQueue<Pair<Integer, T>>((one, two) -> (Integer)two.getKey() - (Integer)one.getKey());
    }

    @Nullable
    public static <T extends BlockEntity> T partAt(BlockEntityType<?> type, BlockGetter level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be != null && be.m_58903_() == type && !be.m_58901_()) {
            return CAConnectivityHandler.checked(be);
        }
        return null;
    }

    @Nullable
    private static <T extends BlockEntity> T checked(BlockEntity be) {
        if (be instanceof IMultiTileContainer) {
            return (T)be;
        }
        return null;
    }

    private static class SearchCache<T extends BlockEntity> {
        Map<BlockPos, Optional<T>> controllerMap = new HashMap<BlockPos, Optional<T>>();

        void put(BlockPos pos, T target) {
            this.controllerMap.put(pos, Optional.of(target));
        }

        void putEmpty(BlockPos pos) {
            this.controllerMap.put(pos, Optional.empty());
        }

        boolean hasVisited(BlockPos pos) {
            return this.controllerMap.containsKey(pos);
        }

        Optional<T> getOrCache(BlockEntityType<?> type, BlockGetter level, BlockPos pos) {
            if (this.hasVisited(pos)) {
                return this.controllerMap.get(pos);
            }
            Object partAt = CAConnectivityHandler.partAt(type, level, pos);
            if (partAt == null) {
                this.putEmpty(pos);
                return Optional.empty();
            }
            Object controller = CAConnectivityHandler.checked(level.m_7702_(((IMultiTileContainer)partAt).getController()));
            if (controller == null) {
                this.putEmpty(pos);
                return Optional.empty();
            }
            this.put(pos, controller);
            return Optional.of(controller);
        }
    }
}

