/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.util;

import dev.tr7zw.notenoughanimations.animations.BodyPart;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;

public class AnimationUtil {
    private static Item crossbow = (Item)Registry.f_122827_.m_7745_(new ResourceLocation("minecraft", "crossbow"));

    public static boolean isUsingboothHands(HumanoidModel.ArmPose pose) {
        return pose == HumanoidModel.ArmPose.BOW_AND_ARROW || pose == HumanoidModel.ArmPose.CROSSBOW_CHARGE || pose == HumanoidModel.ArmPose.CROSSBOW_HOLD;
    }

    public static HumanoidModel.ArmPose getArmPose(AbstractClientPlayer abstractClientPlayerEntity, InteractionHand hand) {
        ItemStack itemStack = abstractClientPlayerEntity.m_21120_(hand);
        if (itemStack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (abstractClientPlayerEntity.m_7655_() == hand && abstractClientPlayerEntity.m_21212_() > 0) {
            UseAnim useAction = itemStack.m_41780_();
            if (useAction == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useAction == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useAction == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useAction == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
            if (useAction == UseAnim.CROSSBOW && hand.equals((Object)abstractClientPlayerEntity.m_7655_())) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (!abstractClientPlayerEntity.f_20911_ && itemStack.m_41720_().equals(crossbow) && AnimationUtil.isChargedCrossbow(itemStack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    public static boolean isChargedCrossbow(ItemStack item) {
        return CrossbowItem.m_40932_((ItemStack)item);
    }

    public static void applyArmTransforms(PlayerModel<AbstractClientPlayer> model, HumanoidArm arm, float pitch, float yaw, float roll) {
        ModelPart part = arm == HumanoidArm.RIGHT ? model.f_102811_ : model.f_102812_;
        part.f_104203_ = pitch;
        part.f_104204_ = yaw;
        if (arm == HumanoidArm.LEFT) {
            part.f_104204_ *= -1.0f;
        }
        part.f_104205_ = roll;
        if (arm == HumanoidArm.LEFT) {
            part.f_104205_ *= -1.0f;
        }
    }

    public static void applyTransforms(PlayerModel<AbstractClientPlayer> model, BodyPart bodyPart, float pitch, float yaw, float roll) {
        boolean mirror = false;
        switch (bodyPart) {
            case LEFT_ARM: {
                mirror = true;
                ModelPart part = model.f_102812_;
                break;
            }
            case RIGHT_ARM: {
                ModelPart part = model.f_102811_;
                break;
            }
            case LEFT_LEG: {
                mirror = true;
                ModelPart part = model.f_102814_;
                break;
            }
            case RIGHT_LEG: {
                ModelPart part = model.f_102813_;
                break;
            }
            default: {
                return;
            }
        }
        part.f_104203_ = pitch;
        part.f_104204_ = yaw;
        if (mirror) {
            part.f_104204_ *= -1.0f;
        }
        part.f_104205_ = roll;
        if (mirror) {
            part.f_104205_ *= -1.0f;
        }
    }

    public static void minMaxHeadRotation(Player livingEntity, PlayerModel<AbstractClientPlayer> model) {
        float value = AnimationUtil.wrapDegrees(model.f_102808_.f_104204_);
        float min = AnimationUtil.wrapDegrees(model.f_102810_.f_104204_ - 1.5707964f);
        float max = AnimationUtil.wrapDegrees(model.f_102810_.f_104204_ + 1.5707964f);
        value = Math.min(value, max);
        model.f_102808_.f_104204_ = value = Math.max(value, min);
        model.f_102809_.f_104204_ = value;
    }

    public static float wrapDegrees(float f) {
        float g = f % 6.283185f;
        if (g >= 3.1415925f) {
            g -= 6.283185f;
        }
        if (g < -3.1415925f) {
            g += 6.283185f;
        }
        return g;
    }
}

