/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import fionathemortal.betterbiomeblend.common.debug.Debug;
import fionathemortal.betterbiomeblend.common.debug.DebugSummary;
import fionathemortal.betterbiomeblend.mixin.AccessorOptionSlider;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Option;
import net.minecraft.client.Options;
import net.minecraft.client.ProgressOption;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.VideoSettingsScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BetterBiomeBlendClient {
    public static final Logger LOGGER = LogManager.getLogger((String)"betterbiomeblend");
    private static final Options gameSettings = Minecraft.m_91087_().f_91066_;
    private static final Component biomeBlendOptionTooltip = new TranslatableComponent("options.biomeBlendRadiusTooltip");
    private static final ProgressOption BIOME_BLEND_RADIUS = new ProgressOption("options.biomeBlendRadius", 0.0, 7.0, 1.0f, BetterBiomeBlendClient::biomeBlendRadiusOptionGetValue, BetterBiomeBlendClient::biomeBlendRadiusOptionSetValue, BetterBiomeBlendClient::biomeBlendRadiusOptionGetDisplayText, BetterBiomeBlendClient::biomeBlendRadiusOptionGetFormattedTooltip);

    public static List<FormattedCharSequence> biomeBlendRadiusOptionGetFormattedTooltip(Minecraft instance) {
        List result = instance.f_91062_.m_92923_((FormattedText)biomeBlendOptionTooltip, 200);
        return result;
    }

    public static Double biomeBlendRadiusOptionGetValue(Options settings) {
        double result = settings.f_92032_;
        return result;
    }

    public static void biomeBlendRadiusOptionSetValue(Options settings, Double optionValues) {
        int currentValue = (int)optionValues.doubleValue();
        int newSetting = Mth.m_14045_((int)currentValue, (int)0, (int)7);
        if (settings.f_92032_ != newSetting) {
            settings.f_92032_ = newSetting;
            Minecraft.m_91087_().f_91060_.m_109818_();
        }
    }

    public static Component biomeBlendRadiusOptionGetDisplayText(Options settings, ProgressOption optionValues) {
        int currentValue = (int)optionValues.m_92221_(settings);
        int blendDiameter = 2 * currentValue + 1;
        TranslatableComponent result = new TranslatableComponent("options.generic_value", new Object[]{new TranslatableComponent("options.biomeBlendRadius"), new TranslatableComponent("options.biomeBlendRadius." + blendDiameter)});
        return result;
    }

    @SubscribeEvent
    public static void postInitGUIEvent(ScreenEvent.InitScreenEvent.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof VideoSettingsScreen) {
            VideoSettingsScreen videoSettingsScreen = (VideoSettingsScreen)screen;
            BetterBiomeBlendClient.replaceBiomeBlendRadiusOption(videoSettingsScreen);
        }
    }

    @SubscribeEvent
    public static void registerCommandsEvent(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        LiteralArgumentBuilder benchmarkCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"betterbiomeblend").then(Commands.m_82127_((String)"toggleBenchmark").executes(context -> {
            boolean benchmarking = Debug.toggleBenchmark();
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (benchmarking) {
                if (player != null) {
                    player.m_6352_((Component)new TextComponent("Started benchmark. Stop with /betterbiomeblend toggleBenchmark"), Util.f_137441_);
                }
            } else {
                if (player != null) {
                    player.m_6352_((Component)new TextComponent("Stopped benchmark"), Util.f_137441_);
                }
                DebugSummary summary = Debug.collateDebugEvents();
                String[] lines = new String[]{"", String.format("Call Count: %d", summary.totalCalls), String.format("Wall Time: %.2f s", summary.elapsedWallTimeInSeconds), String.format("Calls/sec: %.2f", summary.callsPerSecond), String.format("Avg. CPU Time: %.2f ns", summary.averageTime), String.format("Avg. 1%%: %.2f ns", summary.averageOnePercentTime), String.format("Total CPU time: %.2f ms", summary.totalCPUTimeInMilliseconds), ""};
                if (player != null) {
                    for (String line : lines) {
                        player.m_6352_((Component)new TextComponent(line), Util.f_137441_);
                    }
                }
                Debug.teardown();
            }
            return 0;
        }));
        dispatcher.register(benchmarkCommand);
    }

    public static int getBlendRadiusSetting() {
        int result = BetterBiomeBlendClient.gameSettings.f_92032_;
        return result;
    }

    public static void replaceBiomeBlendRadiusOption(VideoSettingsScreen screen) {
        List children = screen.m_6702_();
        block0: for (GuiEventListener child : children) {
            if (!(child instanceof OptionsList)) continue;
            OptionsList rowList = (OptionsList)child;
            List rowListEntries = rowList.m_6702_();
            boolean replacedOption = false;
            for (int index = 0; index < rowListEntries.size(); ++index) {
                OptionsList.Entry row = (OptionsList.Entry)rowListEntries.get(index);
                List rowChildren = row.m_6702_();
                for (GuiEventListener rowChild : rowChildren) {
                    AccessorOptionSlider accessor;
                    if (!(rowChild instanceof AccessorOptionSlider) || (accessor = (AccessorOptionSlider)rowChild).getOption() != Option.f_91653_) continue;
                    OptionsList.Entry newRow = OptionsList.Entry.m_94506_((Options)gameSettings, (int)screen.f_96543_, (Option)BIOME_BLEND_RADIUS);
                    rowListEntries.set(index, newRow);
                    replacedOption = true;
                }
                if (replacedOption) continue block0;
            }
        }
    }

    public static void overwriteOptifineGUIBlendRadiusOption() {
        boolean success;
        block7: {
            success = false;
            try {
                Class<?> guiDetailSettingsOFClass = Class.forName("net.optifine.gui.GuiDetailSettingsOF");
                try {
                    Field enumOptionsField = guiDetailSettingsOFClass.getDeclaredField("enumOptions");
                    enumOptionsField.setAccessible(true);
                    Option[] enumOptions = (Option[])enumOptionsField.get(null);
                    boolean found = false;
                    for (int index = 0; index < enumOptions.length; ++index) {
                        Option option = enumOptions[index];
                        if (option != Option.f_91653_) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        success = true;
                        break block7;
                    }
                    LOGGER.warn("Optifine GUI option was not found.");
                }
                catch (Exception e) {
                    LOGGER.warn((Object)e);
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.info("Otifine does not seem to be loaded, so no need to overwrite anything.");
            }
        }
        if (success) {
            LOGGER.info("Optifine GUI option was successfully replaced.");
        }
    }
}

