/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend.common;

public final class Color {
    public static final float[] sRGBLUT = new float[256];

    public static int makeRGBAWithFullAlpha(int R, int G, int B) {
        int result = (0xFF & R) << 16 | (0xFF & G) << 8 | (0xFF & B) << 0 | 0xFF000000;
        return result;
    }

    public static int RGBAGetR(int color) {
        int result = color >> 16 & 0xFF;
        return result;
    }

    public static int RGBAGetG(int color) {
        int result = color >> 8 & 0xFF;
        return result;
    }

    public static int RGBAGetB(int color) {
        int result = color & 0xFF;
        return result;
    }

    public static float byteToNormalizedFloat(int color) {
        float result = (float)(0xFF & color) / 255.0f;
        return result;
    }

    public static byte normalizedFloatToByte(float color) {
        byte result = (byte)Math.round(color * 255.0f);
        return result;
    }

    public static float sRGBToLinear(float color) {
        float clamped = Math.max(Math.min(color, 1.0f), 0.0f);
        float result = clamped <= 0.040448237f ? color / 12.92f : (float)Math.pow((clamped + 0.055f) / 1.055f, 2.4f);
        return result;
    }

    public static float linearTosRGB(float color) {
        float clamped = Math.max(Math.min(color, 1.0f), 0.0f);
        float result = clamped <= 0.0031306685f ? clamped * 12.92f : 1.055f * (float)Math.pow(clamped, 0.4166666567325592) - 0.055f;
        return result;
    }

    public static float sRGBByteToLinearFloat(int color) {
        float result = sRGBLUT[0xFF & color];
        return result;
    }

    public static byte linearFloatTosRGBByte(float color) {
        float sRGB = Color.linearTosRGB(color);
        byte result = Color.normalizedFloatToByte(sRGB);
        return result;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            float color = Color.byteToNormalizedFloat(i);
            Color.sRGBLUT[i] = Color.sRGBToLinear(color);
        }
    }
}

