/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend.common;

import fionathemortal.betterbiomeblend.common.Color;
import fionathemortal.betterbiomeblend.common.ColorBlendBuffer;
import fionathemortal.betterbiomeblend.common.Random;
import fionathemortal.betterbiomeblend.common.cache.BiomeCache;
import fionathemortal.betterbiomeblend.common.cache.BiomeSlice;
import fionathemortal.betterbiomeblend.common.cache.ColorCache;
import fionathemortal.betterbiomeblend.common.cache.ColorSlice;
import fionathemortal.betterbiomeblend.common.debug.Debug;
import fionathemortal.betterbiomeblend.common.debug.DebugEvent;
import java.util.Stack;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;

public final class ColorBlending {
    public static final int SECTION_SIZE_LOG2 = 2;
    public static final int SECTION_SIZE = 4;
    public static final int SECTION_MASK = 3;
    public static final int SECTION_OFFSET = 2;
    public static final int BLEND_BUFFER_DIM = 11;
    public static final int BLEND_BUFFER_MAX = 10;
    public static final int COLOR_CHUNK_DIM = 4;
    public static final int COLOR_CHUNK_MAX = 3;
    public static final int SAMPLE_SEED_X = 1664525;
    public static final int SAMPLE_SEED_Y = 214013;
    public static final int SAMPLE_SEED_Z = 16807;
    public static final ReentrantLock freeBlendBuffersLock = new ReentrantLock();
    public static final Stack<ColorBlendBuffer> freeBlendBuffers = new Stack();
    public static final byte[] neighborParams = new byte[]{4, 0, 4, 4, 3, 8};

    public static int getNeighborRectMin(int index) {
        return 0;
    }

    public static int getNeighborRectMax(int index) {
        int offset = 2 * (index + 1);
        byte result = neighborParams[offset + 0];
        return result;
    }

    public static int getNeighborRectBlendBufferMin(int index) {
        int offset = 2 * (index + 1);
        byte result = neighborParams[offset + 1];
        return result;
    }

    public static int getCacheArrayIndex(int dim, int x, int y, int z) {
        int result = x + z * dim + y * dim * dim;
        return result;
    }

    public static ColorBlendBuffer acquireBlendBuffer() {
        ColorBlendBuffer result = null;
        freeBlendBuffersLock.lock();
        if (!freeBlendBuffers.empty()) {
            ColorBlendBuffer buffer;
            result = buffer = freeBlendBuffers.pop();
        }
        freeBlendBuffersLock.unlock();
        if (result == null) {
            result = new ColorBlendBuffer();
        }
        return result;
    }

    public static void releaseBlendBuffer(ColorBlendBuffer cache) {
        freeBlendBuffersLock.lock();
        freeBlendBuffers.push(cache);
        freeBlendBuffersLock.unlock();
    }

    public static int getRandomSamplePosition(int section, int seed) {
        int random = Random.noise(section, seed);
        int offset = random & 3;
        int result = 2 + (section << 2) + offset;
        return result;
    }

    public static void fillBlendBufferWithDefaultColor(int indexX, int indexY, int indexZ, int defaultColor, float[] blendBuffer) {
        int colorR = Color.RGBAGetR(defaultColor);
        int colorG = Color.RGBAGetG(defaultColor);
        int colorB = Color.RGBAGetB(defaultColor);
        int cacheMinX = ColorBlending.getNeighborRectMin(indexX);
        int cacheMinY = ColorBlending.getNeighborRectMin(indexY);
        int cacheMinZ = ColorBlending.getNeighborRectMin(indexZ);
        int cacheMaxX = ColorBlending.getNeighborRectMax(indexX);
        int cacheMaxY = ColorBlending.getNeighborRectMax(indexY);
        int cacheMaxZ = ColorBlending.getNeighborRectMax(indexZ);
        int blendMinX = ColorBlending.getNeighborRectBlendBufferMin(indexX);
        int blendMinY = ColorBlending.getNeighborRectBlendBufferMin(indexY);
        int blendMinZ = ColorBlending.getNeighborRectBlendBufferMin(indexZ);
        int cacheSizeX = cacheMaxX - cacheMinX;
        int cacheSizeY = cacheMaxY - cacheMinY;
        int cacheSizeZ = cacheMaxZ - cacheMinZ;
        int blendDim = 11;
        for (int y = 0; y < cacheSizeY; ++y) {
            for (int z = 0; z < cacheSizeZ; ++z) {
                for (int x = 0; x < cacheSizeX; ++x) {
                    int blendX = x + blendMinX;
                    int blendY = y + blendMinY;
                    int blendZ = z + blendMinZ;
                    int blendIndex = ColorBlending.getCacheArrayIndex(11, blendX, blendY, blendZ);
                    blendBuffer[3 * blendIndex + 0] = Color.sRGBByteToLinearFloat((byte)colorR);
                    blendBuffer[3 * blendIndex + 1] = Color.sRGBByteToLinearFloat((byte)colorG);
                    blendBuffer[3 * blendIndex + 2] = Color.sRGBByteToLinearFloat((byte)colorB);
                }
            }
        }
    }

    public static void gatherColors(Level world, ColorResolver colorResolver, int chunkX, int chunkY, int chunkZ, int indexX, int indexY, int indexZ, byte[] cachedColors, Biome[] cachedBiomes, float[] blendBuffer, boolean genNewColors, int defaultColor) {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        int cacheMinX = ColorBlending.getNeighborRectMin(indexX);
        int cacheMinY = ColorBlending.getNeighborRectMin(indexY);
        int cacheMinZ = ColorBlending.getNeighborRectMin(indexZ);
        int cacheMaxX = ColorBlending.getNeighborRectMax(indexX);
        int cacheMaxY = ColorBlending.getNeighborRectMax(indexY);
        int cacheMaxZ = ColorBlending.getNeighborRectMax(indexZ);
        int blendMinX = ColorBlending.getNeighborRectBlendBufferMin(indexX);
        int blendMinY = ColorBlending.getNeighborRectBlendBufferMin(indexY);
        int blendMinZ = ColorBlending.getNeighborRectBlendBufferMin(indexZ);
        int cacheSizeX = cacheMaxX - cacheMinX;
        int cacheSizeY = cacheMaxY - cacheMinY;
        int cacheSizeZ = cacheMaxZ - cacheMinZ;
        int cacheDim = 4;
        int blendDim = 11;
        int sectionX = 4 * chunkX;
        int sectionY = 4 * chunkY;
        int sectionZ = 4 * chunkZ;
        for (int y = 0; y < cacheSizeY; ++y) {
            for (int z = 0; z < cacheSizeZ; ++z) {
                for (int x = 0; x < cacheSizeX; ++x) {
                    int cacheX = x + cacheMinX;
                    int cacheY = y + cacheMinY;
                    int cacheZ = z + cacheMinZ;
                    int blendX = x + blendMinX;
                    int blendY = y + blendMinY;
                    int blendZ = z + blendMinZ;
                    int cacheIndex = ColorBlending.getCacheArrayIndex(4, cacheX, cacheY, cacheZ);
                    int blendIndex = ColorBlending.getCacheArrayIndex(11, blendX, blendY, blendZ);
                    int cachedR = 0xFF & cachedColors[3 * cacheIndex + 0];
                    int cachedG = 0xFF & cachedColors[3 * cacheIndex + 1];
                    int cachedB = 0xFF & cachedColors[3 * cacheIndex + 2];
                    int commonBits = cachedR & cachedG & cachedB;
                    if (commonBits == 255) {
                        if (genNewColors) {
                            Biome biome = cachedBiomes[cacheIndex];
                            int sampleX = ColorBlending.getRandomSamplePosition(sectionX + x, 1664525);
                            int sampleY = ColorBlending.getRandomSamplePosition(sectionY + y, 214013);
                            int sampleZ = ColorBlending.getRandomSamplePosition(sectionZ + z, 16807);
                            if (biome == null) {
                                blockPos.m_122178_(sampleX, sampleY, sampleZ);
                                cachedBiomes[cacheIndex] = biome = ColorBlending.getBiomeAtPositionOrDefaultOrThrow(world, (BlockPos)blockPos);
                            }
                            double blockXF64 = sampleX;
                            double blockZF64 = sampleZ;
                            int color = colorResolver.m_130045_(biome, blockXF64, blockZF64);
                            cachedR = Color.RGBAGetR(color);
                            cachedG = Color.RGBAGetG(color);
                            cachedB = Color.RGBAGetB(color);
                            cachedColors[3 * cacheIndex + 0] = (byte)cachedR;
                            cachedColors[3 * cacheIndex + 1] = (byte)cachedG;
                            cachedColors[3 * cacheIndex + 2] = (byte)cachedB;
                        } else {
                            cachedR = Color.RGBAGetR(defaultColor);
                            cachedG = Color.RGBAGetG(defaultColor);
                            cachedB = Color.RGBAGetB(defaultColor);
                        }
                    }
                    blendBuffer[3 * blendIndex + 0] = Color.sRGBByteToLinearFloat((byte)cachedR);
                    blendBuffer[3 * blendIndex + 1] = Color.sRGBByteToLinearFloat((byte)cachedG);
                    blendBuffer[3 * blendIndex + 2] = Color.sRGBByteToLinearFloat((byte)cachedB);
                }
            }
        }
    }

    public static Biome getBiomeAtPositionOrDefault(Level world, BlockPos blockPosition) {
        Holder biomeHolder = world.m_204166_(blockPosition);
        Biome result = null;
        if (biomeHolder.m_203633_()) {
            result = (Biome)biomeHolder.m_203334_();
        } else {
            biomeHolder = world.m_5962_().m_175515_(Registry.f_122885_).m_206081_(Biomes.f_48202_);
            if (biomeHolder.m_203633_()) {
                result = (Biome)biomeHolder.m_203334_();
            }
        }
        return result;
    }

    public static Biome getBiomeAtPositionOrDefaultOrThrow(Level world, BlockPos blockPos) {
        Biome result = ColorBlending.getBiomeAtPositionOrDefault(world, blockPos);
        if (result == null) {
            throw new IllegalStateException("Biome could not be retrieved for block position.");
        }
        return result;
    }

    public static int gatherColorsForCenterChunk(Level world, ColorResolver colorResolver, int chunkX, int chunkY, int chunkZ, byte[] cachedColors, Biome[] cachedBiomes, float[] blendBuffer, boolean skipBoundary) {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        int cacheMinX = ColorBlending.getNeighborRectMin(0);
        int cacheMinY = ColorBlending.getNeighborRectMin(0);
        int cacheMinZ = ColorBlending.getNeighborRectMin(0);
        int cacheMaxX = ColorBlending.getNeighborRectMax(0);
        int cacheMaxY = ColorBlending.getNeighborRectMax(0);
        int cacheMaxZ = ColorBlending.getNeighborRectMax(0);
        int blendMinX = ColorBlending.getNeighborRectBlendBufferMin(0);
        int blendMinY = ColorBlending.getNeighborRectBlendBufferMin(0);
        int blendMinZ = ColorBlending.getNeighborRectBlendBufferMin(0);
        if (skipBoundary) {
            --cacheMaxX;
            --cacheMaxZ;
        }
        int cacheSizeX = cacheMaxX - cacheMinX;
        int cacheSizeY = cacheMaxY - cacheMinY;
        int cacheSizeZ = cacheMaxZ - cacheMinZ;
        int cacheDim = 4;
        int blendDim = 11;
        int sectionX = 4 * chunkX;
        int sectionY = 4 * chunkY;
        int sectionZ = 4 * chunkZ;
        float accumulatedR = 0.0f;
        float accumulatedG = 0.0f;
        float accumulatedB = 0.0f;
        for (int y = 0; y < cacheSizeY; ++y) {
            for (int z = 0; z < cacheSizeZ; ++z) {
                for (int x = 0; x < cacheSizeX; ++x) {
                    int cacheX = x + cacheMinX;
                    int cacheY = y + cacheMinY;
                    int cacheZ = z + cacheMinZ;
                    int blendX = x + blendMinX;
                    int blendY = y + blendMinY;
                    int blendZ = z + blendMinZ;
                    int cacheIndex = ColorBlending.getCacheArrayIndex(4, cacheX, cacheY, cacheZ);
                    int blendIndex = ColorBlending.getCacheArrayIndex(11, blendX, blendY, blendZ);
                    int cachedR = 0xFF & cachedColors[3 * cacheIndex + 0];
                    int cachedG = 0xFF & cachedColors[3 * cacheIndex + 1];
                    int cachedB = 0xFF & cachedColors[3 * cacheIndex + 2];
                    int commonBits = cachedR & cachedG & cachedB;
                    if (commonBits == 255) {
                        Biome biome = cachedBiomes[cacheIndex];
                        int sampleX = ColorBlending.getRandomSamplePosition(sectionX + x, 1664525);
                        int sampleY = ColorBlending.getRandomSamplePosition(sectionY + y, 214013);
                        int sampleZ = ColorBlending.getRandomSamplePosition(sectionZ + z, 16807);
                        if (biome == null) {
                            blockPos.m_122178_(sampleX, sampleY, sampleZ);
                            cachedBiomes[cacheIndex] = biome = ColorBlending.getBiomeAtPositionOrDefaultOrThrow(world, (BlockPos)blockPos);
                        }
                        double blockXF64 = sampleX;
                        double blockZF64 = sampleZ;
                        int color = colorResolver.m_130045_(biome, blockXF64, blockZF64);
                        cachedR = Color.RGBAGetR(color);
                        cachedG = Color.RGBAGetG(color);
                        cachedB = Color.RGBAGetB(color);
                        cachedColors[3 * cacheIndex + 0] = (byte)cachedR;
                        cachedColors[3 * cacheIndex + 1] = (byte)cachedG;
                        cachedColors[3 * cacheIndex + 2] = (byte)cachedB;
                    }
                    accumulatedR += Color.sRGBByteToLinearFloat(cachedR);
                    accumulatedG += Color.sRGBByteToLinearFloat(cachedG);
                    accumulatedB += Color.sRGBByteToLinearFloat(cachedB);
                    blendBuffer[3 * blendIndex + 0] = Color.sRGBByteToLinearFloat((byte)cachedR);
                    blendBuffer[3 * blendIndex + 1] = Color.sRGBByteToLinearFloat((byte)cachedG);
                    blendBuffer[3 * blendIndex + 2] = Color.sRGBByteToLinearFloat((byte)cachedB);
                }
            }
        }
        float averageR = accumulatedR / (float)(cacheSizeX * cacheSizeY * cacheSizeZ);
        float averageG = accumulatedG / (float)(cacheSizeX * cacheSizeY * cacheSizeZ);
        float averageB = accumulatedB / (float)(cacheSizeX * cacheSizeY * cacheSizeZ);
        byte sRGBAverageR = Color.linearFloatTosRGBByte(averageR);
        byte sRGBAverageG = Color.linearFloatTosRGBByte(averageG);
        byte sRGBAverageB = Color.linearFloatTosRGBByte(averageB);
        int result = Color.makeRGBAWithFullAlpha(sRGBAverageR, sRGBAverageG, sRGBAverageB);
        return result;
    }

    public static void fillCenterChunkBoundaryWithDefaultColor(float[] blendBuffer, int defaultColor) {
        int blendMinX = ColorBlending.getNeighborRectBlendBufferMin(0);
        int blendMinY = ColorBlending.getNeighborRectBlendBufferMin(0);
        int blendMinZ = ColorBlending.getNeighborRectBlendBufferMin(0);
        int defaultR = Color.RGBAGetR(defaultColor);
        int defaultG = Color.RGBAGetG(defaultColor);
        int defaultB = Color.RGBAGetB(defaultColor);
        for (int y = 0; y < 4; ++y) {
            for (int z = 0; z < 4; ++z) {
                for (int x = 0; x < 4; ++x) {
                    if (x != 3 && z != 3) continue;
                    int blendX = x + blendMinX;
                    int blendY = y + blendMinY;
                    int blendZ = z + blendMinZ;
                    int blendIndex = ColorBlending.getCacheArrayIndex(11, blendX, blendY, blendZ);
                    blendBuffer[3 * blendIndex + 0] = Color.sRGBByteToLinearFloat((byte)defaultR);
                    blendBuffer[3 * blendIndex + 1] = Color.sRGBByteToLinearFloat((byte)defaultG);
                    blendBuffer[3 * blendIndex + 2] = Color.sRGBByteToLinearFloat((byte)defaultB);
                }
            }
        }
    }

    public static void gatherRawColorsToCaches(Level world, ColorResolver colorResolver, int colorType, int chunkX, int chunkY, int chunkZ, ColorCache colorCache, BiomeCache biomeCache, float[] blendBuffer) {
        boolean neighborsAreLoaded = true;
        ChunkAccess[] neighbors = new ChunkAccess[9];
        int neighborIndex = 0;
        for (int z = -1; z <= 1; ++z) {
            for (int x = -1; x <= 1; ++x) {
                int neighborX = chunkX + x;
                int neighborZ = chunkZ + z;
                ChunkAccess chunk = world.m_6522_(neighborX, neighborZ, ChunkStatus.f_62317_, false);
                if (chunk != null) {
                    neighbors[neighborIndex] = chunk;
                } else {
                    neighborsAreLoaded = false;
                }
                ++neighborIndex;
            }
        }
        BiomeSlice biomeChunk = (BiomeSlice)biomeCache.getOrDefaultInitializeChunk(chunkX, chunkY, chunkZ, 0);
        ColorSlice colorChunk = (ColorSlice)colorCache.getOrDefaultInitializeChunk(chunkX, chunkY, chunkZ, colorType);
        boolean skipBoundary = !neighborsAreLoaded;
        int defaultColor = ColorBlending.gatherColorsForCenterChunk(world, colorResolver, chunkX, chunkY, chunkZ, colorChunk.data, biomeChunk.data, blendBuffer, skipBoundary);
        colorCache.releaseChunk(colorChunk);
        biomeCache.releaseChunk(biomeChunk);
        if (skipBoundary) {
            ColorBlending.fillCenterChunkBoundaryWithDefaultColor(blendBuffer, defaultColor);
        }
        neighborIndex = 0;
        for (int z = -1; z <= 1; ++z) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    int neighborX = chunkX + x;
                    int neighborY = chunkY + y;
                    int neighborZ = chunkZ + z;
                    if (neighbors[neighborIndex] != null) {
                        BiomeSlice neighborBiomeChunk = (BiomeSlice)biomeCache.getOrDefaultInitializeChunk(neighborX, neighborY, neighborZ, 0);
                        ColorSlice neighborColorChunk = (ColorSlice)colorCache.getOrDefaultInitializeChunk(neighborX, neighborY, neighborZ, colorType);
                        boolean genNewColors = neighborsAreLoaded;
                        ColorBlending.gatherColors(world, colorResolver, neighborX, neighborY, neighborZ, x, y, z, neighborColorChunk.data, neighborBiomeChunk.data, blendBuffer, genNewColors, defaultColor);
                        colorCache.releaseChunk(neighborColorChunk);
                        biomeCache.releaseChunk(neighborBiomeChunk);
                        continue;
                    }
                    ColorBlending.fillBlendBufferWithDefaultColor(x, y, z, defaultColor, blendBuffer);
                }
                ++neighborIndex;
            }
        }
    }

    public static void blendColorsForChunk(byte[] result, float[] colors) {
        int x;
        int outIndex;
        float delB;
        float delG;
        float delR;
        int addIndex;
        int delIndex;
        int blendIndex;
        float accumulatedB;
        float accumulatedG;
        float accumulatedR;
        int y;
        int BLEND_RADIUS = 3;
        int BLEND_DIM = 2 * BLEND_RADIUS + 1;
        int BLEND_COUNT = BLEND_DIM * BLEND_DIM * BLEND_DIM;
        int BLEND_COLOR_CHUNK_DIM = 5;
        for (y = 0; y < 11; ++y) {
            for (int z = 0; z < 11; ++z) {
                int x2;
                accumulatedR = 0.0f;
                accumulatedG = 0.0f;
                accumulatedB = 0.0f;
                for (x2 = 0; x2 < BLEND_DIM; ++x2) {
                    blendIndex = ColorBlending.getCacheArrayIndex(11, x2, y, z);
                    accumulatedR += colors[3 * blendIndex + 0];
                    accumulatedG += colors[3 * blendIndex + 1];
                    accumulatedB += colors[3 * blendIndex + 2];
                }
                for (x2 = 0; x2 < BLEND_COLOR_CHUNK_DIM; ++x2) {
                    delIndex = ColorBlending.getCacheArrayIndex(11, x2, y, z);
                    addIndex = ColorBlending.getCacheArrayIndex(11, x2 + BLEND_DIM, y, z);
                    delR = colors[3 * delIndex + 0];
                    delG = colors[3 * delIndex + 1];
                    delB = colors[3 * delIndex + 2];
                    outIndex = delIndex;
                    colors[3 * outIndex + 0] = accumulatedR;
                    colors[3 * outIndex + 1] = accumulatedG;
                    colors[3 * outIndex + 2] = accumulatedB;
                    if (x2 >= BLEND_COLOR_CHUNK_DIM - 1) continue;
                    accumulatedR -= delR;
                    accumulatedG -= delG;
                    accumulatedB -= delB;
                    accumulatedR += colors[3 * addIndex + 0];
                    accumulatedG += colors[3 * addIndex + 1];
                    accumulatedB += colors[3 * addIndex + 2];
                }
            }
        }
        for (y = 0; y < 11; ++y) {
            for (x = 0; x < BLEND_COLOR_CHUNK_DIM; ++x) {
                int z;
                accumulatedR = 0.0f;
                accumulatedG = 0.0f;
                accumulatedB = 0.0f;
                for (z = 0; z < BLEND_DIM; ++z) {
                    blendIndex = ColorBlending.getCacheArrayIndex(11, x, y, z);
                    accumulatedR += colors[3 * blendIndex + 0];
                    accumulatedG += colors[3 * blendIndex + 1];
                    accumulatedB += colors[3 * blendIndex + 2];
                }
                for (z = 0; z < BLEND_COLOR_CHUNK_DIM; ++z) {
                    delIndex = ColorBlending.getCacheArrayIndex(11, x, y, z);
                    addIndex = ColorBlending.getCacheArrayIndex(11, x, y, z + BLEND_DIM);
                    delR = colors[3 * delIndex + 0];
                    delG = colors[3 * delIndex + 1];
                    delB = colors[3 * delIndex + 2];
                    outIndex = delIndex;
                    colors[3 * outIndex + 0] = accumulatedR;
                    colors[3 * outIndex + 1] = accumulatedG;
                    colors[3 * outIndex + 2] = accumulatedB;
                    if (z >= BLEND_COLOR_CHUNK_DIM - 1) continue;
                    accumulatedR -= delR;
                    accumulatedG -= delG;
                    accumulatedB -= delB;
                    accumulatedR += colors[3 * addIndex + 0];
                    accumulatedG += colors[3 * addIndex + 1];
                    accumulatedB += colors[3 * addIndex + 2];
                }
            }
        }
        for (int z = 0; z < BLEND_COLOR_CHUNK_DIM; ++z) {
            for (x = 0; x < BLEND_COLOR_CHUNK_DIM; ++x) {
                int y2;
                accumulatedR = 0.0f;
                accumulatedG = 0.0f;
                accumulatedB = 0.0f;
                for (y2 = 0; y2 < BLEND_DIM; ++y2) {
                    blendIndex = ColorBlending.getCacheArrayIndex(11, x, y2, z);
                    accumulatedR += colors[3 * blendIndex + 0];
                    accumulatedG += colors[3 * blendIndex + 1];
                    accumulatedB += colors[3 * blendIndex + 2];
                }
                for (y2 = 0; y2 < BLEND_COLOR_CHUNK_DIM; ++y2) {
                    delIndex = ColorBlending.getCacheArrayIndex(11, x, y2, z);
                    addIndex = ColorBlending.getCacheArrayIndex(11, x, y2 + BLEND_DIM, z);
                    delR = colors[3 * delIndex + 0];
                    delG = colors[3 * delIndex + 1];
                    delB = colors[3 * delIndex + 2];
                    outIndex = ColorBlending.getCacheArrayIndex(BLEND_COLOR_CHUNK_DIM, x, y2, z);
                    result[3 * outIndex + 0] = Color.linearFloatTosRGBByte(accumulatedR / (float)BLEND_COUNT);
                    result[3 * outIndex + 1] = Color.linearFloatTosRGBByte(accumulatedG / (float)BLEND_COUNT);
                    result[3 * outIndex + 2] = Color.linearFloatTosRGBByte(accumulatedB / (float)BLEND_COUNT);
                    if (y2 >= BLEND_COLOR_CHUNK_DIM - 1) continue;
                    accumulatedR -= delR;
                    accumulatedG -= delG;
                    accumulatedB -= delB;
                    accumulatedR += colors[3 * addIndex + 0];
                    accumulatedG += colors[3 * addIndex + 1];
                    accumulatedB += colors[3 * addIndex + 2];
                }
            }
        }
    }

    public static void generateBlendedColorChunk(Level world, ColorResolver colorResolverIn, int colorType, int chunkX, int chunkY, int chunkZ, ColorCache colorCache, BiomeCache biomeCache, byte[] result) {
        ColorBlendBuffer blendBuffer = ColorBlending.acquireBlendBuffer();
        boolean debugEnabled = Debug.measurePerformance;
        DebugEvent debugEvent = null;
        if (debugEnabled) {
            debugEvent = Debug.pushGenBegin(chunkX, chunkY, chunkZ, colorType);
        }
        ColorBlending.gatherRawColorsToCaches(world, colorResolverIn, colorType, chunkX, chunkY, chunkZ, colorCache, biomeCache, blendBuffer.color);
        ColorBlending.blendColorsForChunk(result, blendBuffer.color);
        if (debugEnabled) {
            Debug.pushGenEnd(debugEvent);
        }
        ColorBlending.releaseBlendBuffer(blendBuffer);
    }
}

