/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend.common.cache;

import fionathemortal.betterbiomeblend.common.ColorCaching;
import fionathemortal.betterbiomeblend.common.cache.Slice;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class SliceCache<T extends Slice> {
    public final ReentrantLock lock = new ReentrantLock();
    public final Long2ObjectLinkedOpenHashMap<T> hash;
    public final Long2ObjectOpenHashMap<T> invalidationHash;
    public T firstFree;
    private static final byte[] invalidatedRectParams = new byte[]{3, 4, 0, 4, 0, 0};

    public static int getInvalidatedRectMin(int index) {
        int offset = 2 * (index + 1);
        byte result = invalidatedRectParams[offset + 0];
        return result;
    }

    public static int getInvalidatedRectMax(int index) {
        int offset = 2 * (index + 1);
        byte result = invalidatedRectParams[offset + 1];
        return result;
    }

    public static void linkedListUnlink(Slice slice) {
        if (slice.prev != null) {
            slice.prev.next = slice.next;
        }
        if (slice.next != null) {
            slice.next.prev = slice.prev;
        }
        slice.prev = null;
        slice.next = null;
    }

    public static void linkedListLinkAfter(Slice list, Slice slice) {
        slice.next = list.next;
        slice.prev = list;
        if (list.next != null) {
            list.next.prev = slice;
        }
        list.next = slice;
    }

    public SliceCache(int count, Supplier<T> supplier) {
        this.hash = new Long2ObjectLinkedOpenHashMap(count);
        this.invalidationHash = new Long2ObjectOpenHashMap(count);
        for (int index = 0; index < count; ++index) {
            Slice slice = (Slice)supplier.get();
            this.freeListPush(slice);
        }
    }

    public boolean freeListEmpty() {
        boolean result = this.firstFree == null;
        return result;
    }

    public void freeListPush(T slice) {
        ((Slice)slice).prev = null;
        ((Slice)slice).next = this.firstFree;
        if (this.firstFree != null) {
            ((Slice)this.firstFree).prev = slice;
        }
        this.firstFree = slice;
    }

    public T freeListPop() {
        T result = this.firstFree;
        if (result != null) {
            this.firstFree = ((Slice)result).next;
            if (this.firstFree != null) {
                ((Slice)this.firstFree).prev = null;
            }
            ((Slice)result).next = null;
        }
        return result;
    }

    public final void releaseChunkWithoutLocking(T chunk) {
        int refCount = ((Slice)chunk).release();
        if (refCount == 0) {
            this.freeListPush(chunk);
        }
    }

    public final void releaseChunk(T chunk) {
        int refCount = ((Slice)chunk).release();
        if (refCount == 0) {
            this.lock.lock();
            this.freeListPush(chunk);
            this.lock.unlock();
        }
    }

    public final void invalidateAll() {
        this.lock.lock();
        for (Slice chunk : this.hash.values()) {
            this.releaseChunkWithoutLocking(chunk);
            chunk.markAsInvalid();
        }
        this.hash.clear();
        this.invalidationHash.clear();
        this.lock.unlock();
    }

    public final void addToInvalidationHash(T chunk) {
        Slice otherChunk = (Slice)this.invalidationHash.get(((Slice)chunk).columnKey);
        if (otherChunk != null) {
            SliceCache.linkedListLinkAfter(otherChunk, chunk);
        } else {
            this.invalidationHash.put(((Slice)chunk).columnKey, chunk);
        }
    }

    public final void removeFromInvalidationHash(T chunk) {
        if (((Slice)chunk).prev == null) {
            this.invalidationHash.remove(((Slice)chunk).columnKey);
            if (((Slice)chunk).next != null) {
                this.invalidationHash.put(((Slice)chunk).columnKey, (Object)((Slice)chunk).next);
            }
        }
        SliceCache.linkedListUnlink(chunk);
    }

    public final void invalidateSmallNeighborhood(int chunkX, int chunkZ) {
        this.lock.lock();
        for (int z = -1; z <= 0; ++z) {
            for (int x = -1; x <= 0; ++x) {
                Slice first;
                long key = ColorCaching.getChunkKey(chunkX + x, 0, chunkZ + z, 0);
                Slice current = first = (Slice)this.invalidationHash.get(key);
                while (current != null) {
                    Slice next = current.next;
                    if (x == 0 && z == 0) {
                        this.hash.remove(current.key);
                        this.removeFromInvalidationHash(current);
                        this.releaseChunkWithoutLocking(current);
                        current.markAsInvalid();
                    } else {
                        int minX = SliceCache.getInvalidatedRectMin(x);
                        int minY = 0;
                        int minZ = SliceCache.getInvalidatedRectMin(z);
                        int maxX = SliceCache.getInvalidatedRectMax(x);
                        int maxY = 4;
                        int maxZ = SliceCache.getInvalidatedRectMax(z);
                        current.invalidateRegion(minX, minY, minZ, maxX, maxY, maxZ);
                    }
                    current = next;
                }
            }
        }
        this.lock.unlock();
    }

    public final T getOrDefaultInitializeChunk(int chunkX, int chunkY, int chunkZ, int colorType) {
        long key = ColorCaching.getChunkKey(chunkX, chunkY, chunkZ, colorType);
        this.lock.lock();
        Slice result = (Slice)this.hash.getAndMoveToFirst(key);
        if (result == null) {
            if (!this.freeListEmpty()) {
                result = this.freeListPop();
            } else {
                while (true) {
                    long lastKey = this.hash.lastLongKey();
                    result = (Slice)this.hash.removeLast();
                    if (result.getReferenceCount() == 1) break;
                    this.hash.putAndMoveToFirst(lastKey, (Object)result);
                }
                result.release();
                this.removeFromInvalidationHash(result);
            }
            long invalidationKey = ColorCaching.getChunkKey(chunkX, 0, chunkZ, 0);
            result.key = key;
            result.columnKey = invalidationKey;
            result.prev = null;
            result.next = null;
            result.invalidateData();
            result.acquire();
            this.hash.putAndMoveToFirst(result.key, (Object)result);
            this.addToInvalidationHash(result);
        }
        result.acquire();
        this.lock.unlock();
        return (T)result;
    }
}

