/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.network.packet;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.network.packet.IThreadsafePacket;

public class OpenNamedBookPacket
implements IThreadsafePacket {
    private static final String BOOK_ERROR = "command.mantle.book_test.not_found";
    private final ResourceLocation book;

    public OpenNamedBookPacket(FriendlyByteBuf buffer) {
        this.book = buffer.m_130281_();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.book);
    }

    @Override
    public void handleThreadsafe(NetworkEvent.Context context) {
        BookData bookData = BookLoader.getBook(this.book);
        if (bookData != null) {
            bookData.openGui((Component)new TextComponent("Book"), "", null, null);
        } else {
            ClientOnly.errorStatus(this.book);
        }
    }

    public OpenNamedBookPacket(ResourceLocation book) {
        this.book = book;
    }

    private static class ClientOnly {
        private ClientOnly() {
        }

        private static void errorStatus(ResourceLocation book) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                player.m_5661_((Component)new TranslatableComponent(OpenNamedBookPacket.BOOK_ERROR, new Object[]{book}).m_130940_(ChatFormatting.RED), false);
            }
        }
    }
}

