/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.block.entity.device;

import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.lib.api.block.entity.IAreaEffectTile;
import cofh.lib.api.block.entity.ITickableTile;
import cofh.thermal.core.client.ThermalTextures;
import cofh.thermal.core.init.TCoreTileEntities;
import cofh.thermal.lib.block.entity.DeviceBlockEntity;
import cofh.thermal.lib.common.ThermalAugmentRules;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;

public class DeviceXpCondenserTile
extends DeviceBlockEntity
implements ITickableTile.IServerTickable,
IAreaEffectTile {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "Area");
    protected static final IModelData MODEL_DATA = new ModelDataMap.Builder().withInitial(ModelUtils.UNDERLAY, (Object)ThermalTextures.DEVICE_COLLECTOR_UNDERLAY_LOC).build();
    protected static final int RADIUS = 4;
    public int radius = 4;
    protected AABB area;

    public DeviceXpCondenserTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super((BlockEntityType)TCoreTileEntities.DEVICE_XP_CONDENSER_TILE.get(), pos, state);
    }

    @Override
    protected void updateActiveState(boolean prevActive) {
        super.updateActiveState(prevActive);
    }

    public void tickServer() {
    }

    @Nonnull
    public IModelData getModelData() {
        return MODEL_DATA;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return null;
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }

    @Override
    protected void resetAttributes() {
        super.resetAttributes();
        this.radius = 4;
    }

    @Override
    protected void setAttributesFromAugment(CompoundTag augmentData) {
        super.setAttributesFromAugment(augmentData);
        this.radius = (int)((float)this.radius + AugmentableHelper.getAttributeMod((CompoundTag)augmentData, (String)"Radius"));
    }

    @Override
    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        super.finalizeAttributes(enchantmentMap);
        this.area = null;
    }

    public AABB getArea() {
        if (this.area == null) {
            this.area = new AABB(this.f_58858_.m_142082_(-this.radius, -1, -this.radius), this.f_58858_.m_142082_(1 + this.radius, 1 + this.radius, 1 + this.radius));
        }
        return this.area;
    }

    public int getColor() {
        return this.isActive ? 11017314 : 0x555555;
    }
}

