/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.item;

import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.lib.api.ContainerType;
import cofh.lib.api.item.IEnergyContainerItem;
import cofh.lib.energy.EnergyStorageCoFH;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.lib.item.BlockItemAugmentable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyCellBlockItem
extends BlockItemAugmentable
implements IEnergyContainerItem {
    public EnergyCellBlockItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
        this.setEnchantability(5);
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        boolean creative = this.isCreative(stack, ContainerType.ENERGY);
        if (this.getMaxEnergyStored(stack) > 0) {
            tooltip.add((Component)(creative ? StringHelper.getTextComponent((String)"info.cofh.infinite_source") : StringHelper.getTextComponent((String)(StringHelper.localize((String)"info.cofh.energy") + ": " + StringHelper.getScaledNumber((long)this.getEnergyStored(stack)) + " / " + StringHelper.getScaledNumber((long)this.getMaxEnergyStored(stack)) + " RF"))));
        }
        this.addEnergyTooltip(stack, worldIn, tooltip, flagIn, this.getExtract(stack), this.getReceive(stack), creative);
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundTag augmentData) {
        CompoundTag subTag = container.m_41737_("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)subTag, (CompoundTag)augmentData, (String)"BaseMod");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)subTag, (CompoundTag)augmentData, (String)"RFMax");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)subTag, (CompoundTag)augmentData, (String)"RFXfer");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)subTag, (CompoundTag)augmentData, (String)"RFCre");
    }

    public Capability<? extends IEnergyStorage> getEnergyCapability() {
        return CapabilityEnergy.ENERGY;
    }

    public CompoundTag getOrCreateEnergyTag(ItemStack container) {
        CompoundTag blockTag = container.m_41698_("BlockEntityTag");
        if (!blockTag.m_128441_("EnergyMax")) {
            new EnergyStorageCoFH(1000000, 1000, 1000).writeWithParams(container.m_41698_("BlockEntityTag"));
        }
        return container.m_41698_("BlockEntityTag");
    }

    public int getExtract(ItemStack container) {
        CompoundTag tag = this.getOrCreateEnergyTag(container);
        return Math.round(tag.m_128451_("EnergySend"));
    }

    public int getReceive(ItemStack container) {
        CompoundTag tag = this.getOrCreateEnergyTag(container);
        return Math.round(tag.m_128451_("EnergyRecv"));
    }

    public int getMaxEnergyStored(ItemStack container) {
        CompoundTag tag = this.getOrCreateEnergyTag(container);
        float base = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"BaseMod", (float)1.0f);
        float mod = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"RFMax", (float)1.0f);
        return this.getMaxStored(container, Math.round((float)tag.m_128451_("EnergyMax") * mod * base));
    }

    @Override
    public void updateAugmentState(ItemStack container, List<ItemStack> augments) {
        container.m_41784_().m_128365_("Properties", (Tag)new CompoundTag());
        for (ItemStack augment : augments) {
            CompoundTag augmentData = AugmentDataHelper.getAugmentData((ItemStack)augment);
            if (augmentData == null) continue;
            this.setAttributesFromAugment(container, augmentData);
        }
        int energyExcess = this.getEnergyStored(container) - this.getMaxEnergyStored(container);
        if (energyExcess > 0) {
            this.setEnergyStored(container, this.getMaxEnergyStored(container));
        }
    }
}

