/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.machine;

import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.lib.util.managers.SingleItemRecipeManager;
import cofh.thermal.lib.util.recipes.ThermalCatalyst;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import cofh.thermal.lib.util.recipes.internal.BaseMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.CatalyzedMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.DisenchantMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.IMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.IRecipeCatalyst;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.fluids.FluidStack;

public class PulverizerRecipeManager
extends SingleItemRecipeManager.Catalyzed {
    private static final PulverizerRecipeManager INSTANCE = new PulverizerRecipeManager();
    protected static final int DEFAULT_ENERGY = 4000;

    public static PulverizerRecipeManager instance() {
        return INSTANCE;
    }

    private PulverizerRecipeManager() {
        super(4000, 4, 0);
    }

    @Override
    protected IMachineRecipe addRecipe(int energy, float experience, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids, BaseMachineRecipe.RecipeType type) {
        BaseMachineRecipe recipe;
        if (inputItems.isEmpty() || outputItems.isEmpty() && outputFluids.isEmpty() || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        ItemStack input = inputItems.get(0);
        if (input.m_41619_()) {
            return null;
        }
        for (ItemStack itemStack : outputItems) {
            if (!itemStack.m_41619_()) continue;
            return null;
        }
        for (FluidStack fluidStack : outputFluids) {
            if (!fluidStack.isEmpty()) continue;
            return null;
        }
        energy = (int)((float)energy * this.getDefaultScale());
        if (type == BaseMachineRecipe.RecipeType.DISENCHANT) {
            recipe = new DisenchantMachineRecipe(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
            this.recipeMap.put(PulverizerRecipeManager.makeComparable(input), recipe);
        } else {
            recipe = new InternalPulverizerRecipe(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
            this.recipeMap.put(PulverizerRecipeManager.makeNBTComparable(input), recipe);
        }
        return recipe;
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map recipes = recipeManager.m_44054_(TCoreRecipeTypes.RECIPE_PULVERIZER);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addRecipe((ThermalRecipe)((Object)entry.getValue()));
        }
        Map recycle = recipeManager.m_44054_(TCoreRecipeTypes.RECIPE_PULVERIZER_RECYCLE);
        for (Map.Entry entry : recycle.entrySet()) {
            this.addRecipe((ThermalRecipe)((Object)entry.getValue()), BaseMachineRecipe.RecipeType.DISENCHANT);
        }
        Map map = recipeManager.m_44054_(TCoreRecipeTypes.CATALYST_PULVERIZER);
        for (Map.Entry entry : map.entrySet()) {
            this.addCatalyst((ThermalCatalyst)((Object)entry.getValue()));
        }
    }

    protected static class InternalPulverizerRecipe
    extends CatalyzedMachineRecipe {
        public InternalPulverizerRecipe(int energy, float experience, @Nullable List<ItemStack> inputItems, @Nullable List<FluidStack> inputFluids, @Nullable List<ItemStack> outputItems, @Nullable List<Float> chance, @Nullable List<FluidStack> outputFluids) {
            super(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
        }

        @Override
        public IRecipeCatalyst getCatalyst(ItemStack input) {
            return PulverizerRecipeManager.instance().getCatalyst(input);
        }
    }
}

