/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.block.entity;

import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.lib.api.block.entity.ITickableTile;
import cofh.lib.energy.EnergyStorageCoFH;
import cofh.lib.util.Constants;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.BlockStatePropertiesCoFH;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.lib.block.entity.AugmentableBlockEntity;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.common.util.LazyOptional;

public abstract class DynamoBlockEntity
extends AugmentableBlockEntity
implements ITickableTile.IServerTickable {
    protected Direction facing;
    protected int fuel;
    protected int fuelMax;
    protected int coolant;
    protected int coolantMax;
    protected int baseProcessTick;
    protected int processTick;
    protected int minProcessTick;
    protected float energyMod;
    protected boolean throttleFeature;

    public DynamoBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.processTick = this.baseProcessTick = this.getBaseProcessTick();
        this.minProcessTick = this.processTick / 10;
        this.energyMod = 1.0f;
        this.throttleFeature = false;
        this.energyStorage = new EnergyStorageCoFH(this.getBaseEnergyStorage(), 0, this.getBaseEnergyXfer()){

            public boolean canExtract() {
                return false;
            }
        };
        this.facing = (Direction)state.m_61143_((Property)BlockStatePropertiesCoFH.FACING_ALL);
    }

    @Override
    protected int getBaseEnergyStorage() {
        return this.getBaseProcessTick() * 100;
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        this.updateHandlers();
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.updateFacing();
    }

    public void tickServer() {
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.processTick();
            if (this.canProcessFinish()) {
                this.processFinish();
                if (!this.redstoneControl.getState() || !this.canProcessStart()) {
                    this.isActive = false;
                } else {
                    this.processStart();
                }
            }
        } else if (Utils.timeCheckQuarter()) {
            if (this.redstoneControl.getState() && this.canProcessStart()) {
                this.processStart();
                this.processTick();
                this.isActive = true;
            } else {
                this.energyStorage.modify(-this.minProcessTick);
            }
        }
        this.updateActiveState(curActive);
    }

    protected abstract boolean canProcessStart();

    protected boolean canProcessFinish() {
        return this.fuel <= 0;
    }

    protected abstract void processStart();

    protected void processFinish() {
    }

    protected int processTick() {
        if (this.fuel <= 0) {
            return 0;
        }
        int energy = this.calcEnergy();
        this.energyStorage.modify(energy);
        this.fuel -= energy;
        this.transferRF();
        return energy;
    }

    protected int calcEnergy() {
        return Math.min(this.processTick, this.minProcessTick + (int)((double)this.processTick * (1.0 - this.energyStorage.getRatio())));
    }

    protected void transferRF() {
        BlockEntity adjTile = BlockHelper.getAdjacentTileEntity((BlockEntity)this, (Direction)this.getFacing());
        if (adjTile != null) {
            Direction opposite = this.getFacing().m_122424_();
            int maxTransfer = Math.min(this.energyStorage.getMaxExtract(), this.energyStorage.getEnergyStored());
            adjTile.getCapability(ThermalEnergyHelper.getBaseEnergySystem(), opposite).ifPresent(e -> this.energyStorage.modify(-e.receiveEnergy(maxTransfer, false)));
        }
    }

    protected Direction getFacing() {
        if (this.facing == null) {
            this.updateFacing();
        }
        return this.facing;
    }

    protected void updateFacing() {
        this.facing = (Direction)this.m_58900_().m_61143_((Property)BlockStatePropertiesCoFH.FACING_ALL);
        this.updateHandlers();
    }

    @Override
    public int getCurSpeed() {
        return this.isActive ? this.calcEnergy() : 0;
    }

    @Override
    public int getMaxSpeed() {
        return this.baseProcessTick;
    }

    @Override
    public double getEfficiency() {
        if (this.getEnergyMod() <= 0.0f) {
            return Double.MIN_VALUE;
        }
        return this.getEnergyMod();
    }

    @Override
    public int getScaledDuration(int scale) {
        if (this.fuelMax <= 0 || this.fuel <= 0) {
            return 0;
        }
        return scale * this.fuel / this.fuelMax;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        ModelDataManager.requestModelDataRefresh((BlockEntity)this);
    }

    @Override
    public void handleControlPacket(FriendlyByteBuf buffer) {
        super.handleControlPacket(buffer);
        ModelDataManager.requestModelDataRefresh((BlockEntity)this);
    }

    @Override
    public FriendlyByteBuf getGuiPacket(FriendlyByteBuf buffer) {
        super.getGuiPacket(buffer);
        buffer.writeInt(this.fuelMax);
        buffer.writeInt(this.fuel);
        return buffer;
    }

    @Override
    public void handleGuiPacket(FriendlyByteBuf buffer) {
        super.handleGuiPacket(buffer);
        this.fuelMax = buffer.readInt();
        this.fuel = buffer.readInt();
    }

    @Override
    public void handleStatePacket(FriendlyByteBuf buffer) {
        super.handleStatePacket(buffer);
        ModelDataManager.requestModelDataRefresh((BlockEntity)this);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.fuelMax = nbt.m_128451_("FuelMax");
        this.fuel = nbt.m_128451_("Fuel");
        this.coolantMax = nbt.m_128451_("CoolantMax");
        this.coolant = nbt.m_128451_("Coolant");
        this.processTick = nbt.m_128451_("ProcTick");
        this.updateHandlers();
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("FuelMax", this.fuelMax);
        nbt.m_128405_("Fuel", this.fuel);
        nbt.m_128405_("CoolantMax", this.coolantMax);
        nbt.m_128405_("Coolant", this.coolant);
        nbt.m_128405_("ProcTick", this.processTick);
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        BiPredicate<ItemStack, List<ItemStack>> validator = this.tankInv.hasTanks() ? ThermalAugmentRules.DYNAMO_VALIDATOR : ThermalAugmentRules.DYNAMO_NO_FLUID_VALIDATOR;
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && validator.test((ItemStack)item, this.getAugmentsAsList());
    }

    @Override
    protected void resetAttributes() {
        super.resetAttributes();
        AugmentableHelper.setAttribute((CompoundTag)this.augmentNBT, (String)"DynamoPower", (float)1.0f);
        this.energyMod = 1.0f;
        this.throttleFeature = false;
    }

    @Override
    protected void setAttributesFromAugment(CompoundTag augmentData) {
        super.setAttributesFromAugment(augmentData);
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundTag)this.augmentNBT, (CompoundTag)augmentData, (String)"DynamoPower");
        this.energyMod *= AugmentableHelper.getAttributeModWithDefault((CompoundTag)augmentData, (String)"DynamoEnergy", (float)1.0f);
        this.throttleFeature |= AugmentableHelper.getAttributeMod((CompoundTag)augmentData, (String)"DynamoThrottle") > 0.0f;
    }

    @Override
    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        this.creativeEnergy = false;
        super.finalizeAttributes(enchantmentMap);
        float baseMod = AugmentableHelper.getAttributeModWithDefault((CompoundTag)this.augmentNBT, (String)"BaseMod", (float)1.0f);
        float processMod = AugmentableHelper.getAttributeModWithDefault((CompoundTag)this.augmentNBT, (String)"DynamoPower", (float)1.0f);
        float totalMod = baseMod * processMod;
        this.energyStorage.applyModifiers(totalMod, totalMod);
        this.baseProcessTick = Math.round((float)this.getBaseProcessTick() * totalMod);
        this.energyMod = MathHelper.clamp((float)this.energyMod, (float)Constants.AUG_SCALE_MIN, (float)Constants.AUG_SCALE_MAX);
        this.processTick = this.baseProcessTick;
        this.minProcessTick = this.throttleFeature ? 0 : this.baseProcessTick / 10;
    }

    protected final float getEnergyMod() {
        return this.energyMod;
    }

    @Override
    protected <T> LazyOptional<T> getEnergyCapability(@Nullable Direction side) {
        if (side == null || side.equals((Object)this.getFacing())) {
            return super.getEnergyCapability(side);
        }
        return LazyOptional.empty();
    }

    @Override
    protected <T> LazyOptional<T> getItemHandlerCapability(@Nullable Direction side) {
        if (side != null && side.equals((Object)this.getFacing())) {
            return LazyOptional.empty();
        }
        return super.getItemHandlerCapability(side);
    }

    @Override
    protected <T> LazyOptional<T> getFluidHandlerCapability(@Nullable Direction side) {
        if (side != null && side.equals((Object)this.getFacing())) {
            return LazyOptional.empty();
        }
        return super.getFluidHandlerCapability(side);
    }
}

