/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei;

import com.simibubi.create.content.logistics.item.filter.AttributeFilterScreen;
import com.simibubi.create.foundation.gui.container.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.container.GhostItemContainer;
import com.simibubi.create.foundation.gui.container.GhostItemSubmitPacket;
import com.simibubi.create.foundation.networking.AllPackets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GhostIngredientHandler<T extends GhostItemContainer<?>>
implements IGhostIngredientHandler<AbstractSimiContainerScreen<T>> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(AbstractSimiContainerScreen<T> gui, I ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        boolean isAttributeFilter = gui instanceof AttributeFilterScreen;
        if (ingredient instanceof ItemStack) {
            for (int i = 36; i < ((GhostItemContainer)gui.m_6262_()).f_38839_.size(); ++i) {
                if (((Slot)((GhostItemContainer)gui.m_6262_()).f_38839_.get(i)).m_6659_()) {
                    targets.add(new GhostTarget(gui, i - 36, isAttributeFilter));
                }
                if (isAttributeFilter) break;
            }
        }
        return targets;
    }

    public void onComplete() {
    }

    public boolean shouldHighlightTargets() {
        return true;
    }

    private static class GhostTarget<I, T extends GhostItemContainer<?>>
    implements IGhostIngredientHandler.Target<I> {
        private final Rect2i area;
        private final AbstractSimiContainerScreen<T> gui;
        private final int slotIndex;
        private final boolean isAttributeFilter;

        public GhostTarget(AbstractSimiContainerScreen<T> gui, int slotIndex, boolean isAttributeFilter) {
            this.gui = gui;
            this.slotIndex = slotIndex;
            this.isAttributeFilter = isAttributeFilter;
            Slot slot = (Slot)((GhostItemContainer)gui.m_6262_()).f_38839_.get(slotIndex + 36);
            this.area = new Rect2i(gui.getGuiLeft() + slot.f_40220_, gui.getGuiTop() + slot.f_40221_, 16, 16);
        }

        public Rect2i getArea() {
            return this.area;
        }

        public void accept(I ingredient) {
            ItemStack stack = ((ItemStack)ingredient).m_41777_();
            stack.m_41764_(1);
            ((GhostItemContainer)this.gui.m_6262_()).ghostInventory.setStackInSlot(this.slotIndex, stack);
            if (this.isAttributeFilter) {
                return;
            }
            AllPackets.channel.sendToServer((Object)new GhostItemSubmitPacket(stack, this.slotIndex));
        }
    }
}

