/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.saw;

import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.components.actors.DrillBlock;
import com.simibubi.create.content.contraptions.components.saw.SawTileEntity;
import com.simibubi.create.foundation.block.ITE;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SawBlock
extends DirectionalAxisKineticBlock
implements ITE<SawTileEntity> {
    public static DamageSource damageSourceSaw = new DamageSource("create.mechanical_saw").m_19380_();

    public SawBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        Direction facing = (Direction)stateForPlacement.m_61143_((Property)FACING);
        if (facing.m_122434_().m_122478_()) {
            return stateForPlacement;
        }
        return (BlockState)stateForPlacement.m_61124_((Property)AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(facing.m_122434_() == Direction.Axis.X));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.CASING_12PX.get((Direction)state.m_61143_((Property)FACING));
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof ItemEntity) {
            return;
        }
        if (!new AABB(pos).m_82406_((double)0.1f).m_82381_(entityIn.m_142469_())) {
            return;
        }
        this.withTileEntityDo((BlockGetter)worldIn, pos, te -> {
            if (te.getSpeed() == 0.0f) {
                return;
            }
            entityIn.m_6469_(damageSourceSaw, (float)DrillBlock.getDamage(te.getSpeed()));
        });
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        super.m_5548_(worldIn, entityIn);
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (entityIn.f_19853_.f_46443_) {
            return;
        }
        BlockPos pos = entityIn.m_142538_();
        this.withTileEntityDo((BlockGetter)entityIn.f_19853_, pos, te -> {
            if (te.getSpeed() == 0.0f) {
                return;
            }
            te.insertItem((ItemEntity)entityIn);
        });
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.NORMAL;
    }

    public static boolean isHorizontal(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_().m_122479_();
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return SawBlock.isHorizontal(state) ? ((Direction)state.m_61143_((Property)FACING)).m_122434_() : super.getRotationAxis(state);
    }

    @Override
    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return SawBlock.isHorizontal(state) ? face == ((Direction)state.m_61143_((Property)FACING)).m_122424_() : super.hasShaftTowards(world, pos, state, face);
    }

    @Override
    public Class<SawTileEntity> getTileEntityClass() {
        return SawTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends SawTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.SAW.get();
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }
}

