/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids;

import com.simibubi.create.AllFluids;
import com.simibubi.create.content.contraptions.fluids.FlowSource;
import com.simibubi.create.content.contraptions.fluids.FluidReactions;
import com.simibubi.create.content.contraptions.fluids.pipes.VanillaFluidTargets;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluidHandler;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.BlockFace;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class OpenEndedPipe
extends FlowSource {
    private static final List<IEffectHandler> EFFECT_HANDLERS = new ArrayList<IEffectHandler>();
    private Level world;
    private BlockPos pos;
    private AABB aoe;
    private OpenEndFluidHandler fluidHandler = new OpenEndFluidHandler();
    private BlockPos outputPos;
    private boolean wasPulling;
    private FluidStack cachedFluid;
    private List<MobEffectInstance> cachedEffects;

    public OpenEndedPipe(BlockFace face) {
        super(face);
        this.outputPos = face.getConnectedPos();
        this.pos = face.getPos();
        this.aoe = new AABB(this.outputPos).m_82363_(0.0, -1.0, 0.0);
        if (face.getFace() == Direction.DOWN) {
            this.aoe = this.aoe.m_82363_(0.0, -1.0, 0.0);
        }
    }

    public static void registerEffectHandler(IEffectHandler handler) {
        EFFECT_HANDLERS.add(handler);
    }

    public Level getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockPos getOutputPos() {
        return this.outputPos;
    }

    public AABB getAOE() {
        return this.aoe;
    }

    @Override
    public void manageSource(Level world) {
        this.world = world;
    }

    @Override
    public LazyOptional<IFluidHandler> provideHandler() {
        return LazyOptional.of(() -> this.fluidHandler);
    }

    @Override
    public boolean isEndpoint() {
        return true;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        this.fluidHandler.writeToNBT(compound);
        compound.m_128379_("Pulling", this.wasPulling);
        compound.m_128365_("Location", (Tag)this.location.serializeNBT());
        return compound;
    }

    public static OpenEndedPipe fromNBT(CompoundTag compound, BlockPos tilePos) {
        BlockFace fromNBT = BlockFace.fromNBT(compound.m_128469_("Location"));
        OpenEndedPipe oep = new OpenEndedPipe(new BlockFace(tilePos, fromNBT.getFace()));
        oep.fluidHandler.readFromNBT(compound);
        oep.wasPulling = compound.m_128471_("Pulling");
        return oep;
    }

    private FluidStack removeFluidFromSpace(boolean simulate) {
        FluidStack empty = FluidStack.EMPTY;
        if (this.world == null) {
            return empty;
        }
        if (!this.world.m_46749_(this.outputPos)) {
            return empty;
        }
        BlockState state = this.world.m_8055_(this.outputPos);
        FluidState fluidState = state.m_60819_();
        boolean waterlog = state.m_61138_((Property)BlockStateProperties.f_61362_);
        FluidStack drainBlock = VanillaFluidTargets.drainBlock(this.world, this.outputPos, state, simulate);
        if (!drainBlock.isEmpty()) {
            if (!simulate && state.m_61138_((Property)BlockStateProperties.f_61421_) && AllFluids.HONEY.is((IForgeRegistryEntry)drainBlock.getFluid())) {
                AdvancementBehaviour.tryAward((BlockGetter)this.world, this.pos, AllAdvancements.HONEY_DRAIN);
            }
            return drainBlock;
        }
        if (!waterlog && !state.m_60767_().m_76336_()) {
            return empty;
        }
        if (fluidState.m_76178_() || !fluidState.m_76170_()) {
            return empty;
        }
        FluidStack stack = new FluidStack(fluidState.m_76152_(), 1000);
        if (simulate) {
            return stack;
        }
        if (FluidHelper.isWater(stack.getFluid())) {
            AdvancementBehaviour.tryAward((BlockGetter)this.world, this.pos, AllAdvancements.WATER_SUPPLY);
        }
        if (waterlog) {
            this.world.m_7731_(this.outputPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 3);
            this.world.m_186469_(this.outputPos, (Fluid)Fluids.f_76193_, 1);
            return stack;
        }
        this.world.m_7731_(this.outputPos, (BlockState)fluidState.m_76188_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(14)), 3);
        return stack;
    }

    private boolean provideFluidToSpace(FluidStack fluid, boolean simulate) {
        if (this.world == null) {
            return false;
        }
        if (!this.world.m_46749_(this.outputPos)) {
            return false;
        }
        BlockState state = this.world.m_8055_(this.outputPos);
        FluidState fluidState = state.m_60819_();
        boolean waterlog = state.m_61138_((Property)BlockStateProperties.f_61362_);
        if (!waterlog && !state.m_60767_().m_76336_()) {
            return false;
        }
        if (fluid.isEmpty()) {
            return false;
        }
        if (!FluidHelper.hasBlockState(fluid.getFluid())) {
            return true;
        }
        if (!fluidState.m_76178_() && fluidState.m_76152_() != fluid.getFluid()) {
            FluidReactions.handlePipeSpillCollision(this.world, this.outputPos, fluid.getFluid(), fluidState);
            return false;
        }
        if (fluidState.m_76170_()) {
            return false;
        }
        if (waterlog && fluid.getFluid() != Fluids.f_76193_) {
            return false;
        }
        if (simulate) {
            return true;
        }
        if (this.world.m_6042_().m_63951_() && FluidHelper.isTag(fluid, (TagKey<Fluid>)FluidTags.f_13131_)) {
            int i = this.outputPos.m_123341_();
            int j = this.outputPos.m_123342_();
            int k = this.outputPos.m_123343_();
            this.world.m_6263_(null, (double)i, (double)j, (double)k, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (this.world.f_46441_.nextFloat() - this.world.f_46441_.nextFloat()) * 0.8f);
            return true;
        }
        if (waterlog) {
            this.world.m_7731_(this.outputPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)), 3);
            this.world.m_186469_(this.outputPos, (Fluid)Fluids.f_76193_, 1);
            return true;
        }
        if (!((Boolean)AllConfigs.SERVER.fluids.placeFluidSourceBlocks.get()).booleanValue()) {
            return true;
        }
        this.world.m_7731_(this.outputPos, fluid.getFluid().m_76145_().m_76188_(), 3);
        return true;
    }

    private boolean canApplyEffects(FluidStack fluid) {
        for (IEffectHandler handler : EFFECT_HANDLERS) {
            if (!handler.canApplyEffects(this, fluid)) continue;
            return true;
        }
        return false;
    }

    private void applyEffects(FluidStack fluid) {
        for (IEffectHandler handler : EFFECT_HANDLERS) {
            if (!handler.canApplyEffects(this, fluid)) continue;
            handler.applyEffects(this, fluid);
        }
    }

    static {
        OpenEndedPipe.registerEffectHandler(new PotionEffectHandler());
        OpenEndedPipe.registerEffectHandler(new MilkEffectHandler());
        OpenEndedPipe.registerEffectHandler(new WaterEffectHandler());
        OpenEndedPipe.registerEffectHandler(new LavaEffectHandler());
    }

    private class OpenEndFluidHandler
    extends FluidTank {
        public OpenEndFluidHandler() {
            super(1000);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (OpenEndedPipe.this.world == null) {
                return 0;
            }
            if (!OpenEndedPipe.this.world.m_46749_(OpenEndedPipe.this.outputPos)) {
                return 0;
            }
            if (resource.isEmpty()) {
                return 0;
            }
            if (!OpenEndedPipe.this.provideFluidToSpace(resource, true)) {
                return 0;
            }
            FluidStack containedFluidStack = this.getFluid();
            boolean hasBlockState = FluidHelper.hasBlockState(containedFluidStack.getFluid());
            if (!containedFluidStack.isEmpty() && !containedFluidStack.isFluidEqual(resource)) {
                this.setFluid(FluidStack.EMPTY);
            }
            if (OpenEndedPipe.this.wasPulling) {
                OpenEndedPipe.this.wasPulling = false;
            }
            if (OpenEndedPipe.this.canApplyEffects(resource) && !hasBlockState) {
                resource = FluidHelper.copyStackWithAmount(resource, 1);
            }
            int fill = super.fill(resource, action);
            if (action.simulate()) {
                return fill;
            }
            if (!resource.isEmpty()) {
                OpenEndedPipe.this.applyEffects(resource);
            }
            if ((this.getFluidAmount() == 1000 || !hasBlockState) && OpenEndedPipe.this.provideFluidToSpace(containedFluidStack, false)) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fill;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.drainInner(resource.getAmount(), resource, action);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.drainInner(maxDrain, null, action);
        }

        private FluidStack drainInner(int amount, @Nullable FluidStack filter, IFluidHandler.FluidAction action) {
            FluidStack drainedFromInternal;
            boolean filterPresent;
            FluidStack empty = FluidStack.EMPTY;
            boolean bl = filterPresent = filter != null;
            if (OpenEndedPipe.this.world == null) {
                return empty;
            }
            if (!OpenEndedPipe.this.world.m_46749_(OpenEndedPipe.this.outputPos)) {
                return empty;
            }
            if (amount == 0) {
                return empty;
            }
            if (amount > 1000) {
                amount = 1000;
                if (filterPresent) {
                    filter = FluidHelper.copyStackWithAmount(filter, amount);
                }
            }
            if (!OpenEndedPipe.this.wasPulling) {
                OpenEndedPipe.this.wasPulling = true;
            }
            FluidStack fluidStack = drainedFromInternal = filterPresent ? super.drain(filter, action) : super.drain(amount, action);
            if (!drainedFromInternal.isEmpty()) {
                return drainedFromInternal;
            }
            FluidStack drainedFromWorld = OpenEndedPipe.this.removeFluidFromSpace(action.simulate());
            if (drainedFromWorld.isEmpty()) {
                return FluidStack.EMPTY;
            }
            if (filterPresent && !drainedFromWorld.isFluidEqual(filter)) {
                return FluidStack.EMPTY;
            }
            int remainder = drainedFromWorld.getAmount() - amount;
            drainedFromWorld.setAmount(amount);
            if (!action.simulate() && remainder > 0) {
                if (!this.getFluid().isEmpty() && !this.getFluid().isFluidEqual(drainedFromWorld)) {
                    this.setFluid(FluidStack.EMPTY);
                }
                super.fill(FluidHelper.copyStackWithAmount(drainedFromWorld, remainder), IFluidHandler.FluidAction.EXECUTE);
            }
            return drainedFromWorld;
        }
    }

    public static interface IEffectHandler {
        public boolean canApplyEffects(OpenEndedPipe var1, FluidStack var2);

        public void applyEffects(OpenEndedPipe var1, FluidStack var2);
    }

    public static class PotionEffectHandler
    implements IEffectHandler {
        @Override
        public boolean canApplyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            return fluid.getFluid().m_6212_((Fluid)AllFluids.POTION.get());
        }

        @Override
        public void applyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            if (pipe.cachedFluid == null || pipe.cachedEffects == null || !fluid.isFluidEqual(pipe.cachedFluid)) {
                FluidStack copy = fluid.copy();
                copy.setAmount(250);
                ItemStack bottle = PotionFluidHandler.fillBottle(new ItemStack((ItemLike)Items.f_42590_), fluid);
                pipe.cachedEffects = PotionUtils.m_43547_((ItemStack)bottle);
            }
            if (pipe.cachedEffects.isEmpty()) {
                return;
            }
            List entities = pipe.getWorld().m_6443_(LivingEntity.class, pipe.getAOE(), LivingEntity::m_5801_);
            for (LivingEntity entity : entities) {
                for (MobEffectInstance effectInstance : pipe.cachedEffects) {
                    MobEffect effect = effectInstance.m_19544_();
                    if (effect.m_8093_()) {
                        effect.m_19461_(null, null, entity, effectInstance.m_19564_(), 0.5);
                        continue;
                    }
                    entity.m_7292_(new MobEffectInstance(effectInstance));
                }
            }
        }
    }

    public static class MilkEffectHandler
    implements IEffectHandler {
        @Override
        public boolean canApplyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            return FluidHelper.isTag(fluid, (TagKey<Fluid>)Tags.Fluids.MILK);
        }

        @Override
        public void applyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            Level world = pipe.getWorld();
            if (world.m_46467_() % 5L != 0L) {
                return;
            }
            List entities = world.m_6443_(LivingEntity.class, pipe.getAOE(), LivingEntity::m_5801_);
            ItemStack curativeItem = new ItemStack((ItemLike)Items.f_42455_);
            for (LivingEntity entity : entities) {
                entity.curePotionEffects(curativeItem);
            }
        }
    }

    public static class WaterEffectHandler
    implements IEffectHandler {
        @Override
        public boolean canApplyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            return FluidHelper.isTag(fluid, (TagKey<Fluid>)FluidTags.f_13131_);
        }

        @Override
        public void applyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            Level world = pipe.getWorld();
            if (world.m_46467_() % 5L != 0L) {
                return;
            }
            List entities = world.m_6249_((Entity)null, pipe.getAOE(), Entity::m_6060_);
            for (Entity entity : entities) {
                entity.m_20095_();
            }
            BlockPos.m_121921_((AABB)pipe.getAOE()).forEach(pos -> WaterEffectHandler.dowseFire(world, pos));
        }

        private static void dowseFire(Level level, BlockPos pos) {
            BlockState state = level.m_8055_(pos);
            if (state.m_204336_(BlockTags.f_13076_)) {
                level.m_7471_(pos, false);
            } else if (AbstractCandleBlock.m_151933_((BlockState)state)) {
                AbstractCandleBlock.m_151899_(null, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
            } else if (CampfireBlock.m_51319_((BlockState)state)) {
                level.m_5898_(null, 1009, pos, 0);
                CampfireBlock.m_152749_(null, (LevelAccessor)level, (BlockPos)pos, (BlockState)state);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public static class LavaEffectHandler
    implements IEffectHandler {
        @Override
        public boolean canApplyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            return FluidHelper.isTag(fluid, (TagKey<Fluid>)FluidTags.f_13132_);
        }

        @Override
        public void applyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            Level world = pipe.getWorld();
            if (world.m_46467_() % 5L != 0L) {
                return;
            }
            List entities = world.m_6249_((Entity)null, pipe.getAOE(), entity -> !entity.m_5825_());
            for (Entity entity2 : entities) {
                entity2.m_20254_(3);
            }
        }
    }
}

