/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.actors;

import com.simibubi.create.content.contraptions.fluids.actors.FluidManipulationBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.utility.BBHelper;
import com.simibubi.create.foundation.utility.Iterate;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.fluids.FluidStack;

public class FluidDrainingBehaviour
extends FluidManipulationBehaviour {
    public static final BehaviourType<FluidDrainingBehaviour> TYPE = new BehaviourType();
    Fluid fluid;
    Set<BlockPos> validationSet;
    PriorityQueue<FluidManipulationBehaviour.BlockPosEntry> queue;
    boolean isValid;
    List<FluidManipulationBehaviour.BlockPosEntry> validationFrontier;
    Set<BlockPos> validationVisited = new HashSet<BlockPos>();
    Set<BlockPos> newValidationSet;

    public FluidDrainingBehaviour(SmartTileEntity te) {
        super(te);
        this.validationFrontier = new ArrayList<FluidManipulationBehaviour.BlockPosEntry>();
        this.validationSet = new HashSet<BlockPos>();
        this.newValidationSet = new HashSet<BlockPos>();
        this.queue = new ObjectHeapPriorityQueue(this::comparePositions);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public boolean pullNext(BlockPos root, boolean simulate) {
        if (!this.frontier.isEmpty()) {
            return false;
        }
        if (!Objects.equals(root, this.rootPos)) {
            this.rebuildContext(root);
            return false;
        }
        if (this.counterpartActed) {
            this.counterpartActed = false;
            this.softReset(root);
            return false;
        }
        if (this.affectedArea == null) {
            this.affectedArea = BoundingBox.m_162375_((Vec3i)root, (Vec3i)root);
        }
        Level world = this.getWorld();
        if (!this.queue.isEmpty() && !this.isValid) {
            this.rebuildContext(root);
            return false;
        }
        if (this.validationFrontier.isEmpty() && !this.queue.isEmpty() && !simulate && this.revalidateIn == 0) {
            this.revalidate(root);
        }
        while (!this.queue.isEmpty()) {
            Fluid fluid;
            BlockState emptied;
            BlockPos currentPos;
            block21: {
                BlockState blockState;
                currentPos = ((FluidManipulationBehaviour.BlockPosEntry)this.queue.first()).pos();
                emptied = blockState = world.m_8055_(currentPos);
                fluid = Fluids.f_76191_;
                if (blockState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                    emptied = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
                    fluid = Fluids.f_76193_;
                } else {
                    if (blockState.m_60734_() instanceof LiquidBlock) {
                        LiquidBlock flowingFluid = (LiquidBlock)blockState.m_60734_();
                        emptied = Blocks.f_50016_.m_49966_();
                        if ((Integer)blockState.m_61143_((Property)LiquidBlock.f_54688_) == 0) {
                            fluid = flowingFluid.getFluid();
                            break block21;
                        } else {
                            this.affectedArea = BBHelper.encapsulate(this.affectedArea, BoundingBox.m_162375_((Vec3i)currentPos, (Vec3i)currentPos));
                            if (!this.tileEntity.isVirtual()) {
                                world.m_7731_(currentPos, emptied, 18);
                            }
                            this.queue.dequeue();
                            if (!this.queue.isEmpty()) continue;
                            this.isValid = this.checkValid(world, this.rootPos);
                            this.reset();
                            continue;
                        }
                    }
                    if (blockState.m_60819_().m_76152_() != Fluids.f_76191_ && blockState.m_60742_((BlockGetter)world, currentPos, CollisionContext.m_82749_()).m_83281_()) {
                        fluid = blockState.m_60819_().m_76152_();
                        emptied = Blocks.f_50016_.m_49966_();
                    }
                }
            }
            if (this.fluid == null) {
                this.fluid = fluid;
            }
            if (!this.fluid.m_6212_(fluid)) {
                this.queue.dequeue();
                if (!this.queue.isEmpty()) continue;
                this.isValid = this.checkValid(world, this.rootPos);
                this.reset();
                continue;
            }
            if (simulate) {
                return true;
            }
            this.playEffect(world, currentPos, fluid, true);
            this.tileEntity.award(AllAdvancements.HOSE_PULLEY);
            if (this.infinite) {
                if (!FluidHelper.isLava(fluid)) return true;
                this.tileEntity.award(AllAdvancements.HOSE_PULLEY_LAVA);
                return true;
            }
            if (!this.tileEntity.isVirtual()) {
                world.m_7731_(currentPos, emptied, 18);
            }
            this.affectedArea = BBHelper.encapsulate(this.affectedArea, currentPos);
            this.queue.dequeue();
            if (this.queue.isEmpty()) {
                this.isValid = this.checkValid(world, this.rootPos);
                this.reset();
                return true;
            }
            if (this.validationSet.contains(currentPos)) return true;
            this.reset();
            return true;
        }
        if (this.rootPos == null) {
            return false;
        }
        if (!this.isValid) return false;
        this.rebuildContext(root);
        return false;
    }

    protected void softReset(BlockPos root) {
        this.queue.clear();
        this.validationSet.clear();
        this.newValidationSet.clear();
        this.validationFrontier.clear();
        this.validationVisited.clear();
        this.visited.clear();
        this.infinite = false;
        this.setValidationTimer();
        this.frontier.add(new FluidManipulationBehaviour.BlockPosEntry(root, 0));
        this.tileEntity.sendData();
    }

    protected boolean checkValid(Level world, BlockPos root) {
        BlockPos currentPos = root;
        for (int timeout = 1000; timeout > 0 && !root.equals((Object)this.tileEntity.m_58899_()); --timeout) {
            FluidBlockType canPullFluidsFrom = this.canPullFluidsFrom(world.m_8055_(currentPos), currentPos);
            if (canPullFluidsFrom == FluidBlockType.FLOWING) {
                for (Direction d : Iterate.directions) {
                    BlockPos side = currentPos.m_142300_(d);
                    if (this.canPullFluidsFrom(world.m_8055_(side), side) != FluidBlockType.SOURCE) continue;
                    return true;
                }
            } else {
                if (canPullFluidsFrom != FluidBlockType.SOURCE) break;
                return true;
            }
            currentPos = currentPos.m_7494_();
        }
        return false;
    }

    @Override
    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (!clientPacket && this.affectedArea != null) {
            this.frontier.add(new FluidManipulationBehaviour.BlockPosEntry(this.rootPos, 0));
        }
    }

    protected FluidBlockType canPullFluidsFrom(BlockState blockState, BlockPos pos) {
        if (blockState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            return FluidBlockType.SOURCE;
        }
        if (blockState.m_60734_() instanceof LiquidBlock) {
            return (Integer)blockState.m_61143_((Property)LiquidBlock.f_54688_) == 0 ? FluidBlockType.SOURCE : FluidBlockType.FLOWING;
        }
        if (blockState.m_60819_().m_76152_() != Fluids.f_76191_ && blockState.m_60742_((BlockGetter)this.getWorld(), pos, CollisionContext.m_82749_()).m_83281_()) {
            return FluidBlockType.SOURCE;
        }
        return FluidBlockType.NONE;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.rootPos != null) {
            this.isValid = this.checkValid(this.getWorld(), this.rootPos);
        }
        if (!this.frontier.isEmpty()) {
            this.continueSearch();
            return;
        }
        if (!this.validationFrontier.isEmpty()) {
            this.continueValidation();
            return;
        }
        if (this.revalidateIn > 0) {
            --this.revalidateIn;
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
    }

    public void rebuildContext(BlockPos root) {
        this.reset();
        this.rootPos = root;
        this.affectedArea = BoundingBox.m_162375_((Vec3i)this.rootPos, (Vec3i)this.rootPos);
        if (this.isValid) {
            this.frontier.add(new FluidManipulationBehaviour.BlockPosEntry(root, 0));
        }
    }

    public void revalidate(BlockPos root) {
        this.validationFrontier.clear();
        this.validationVisited.clear();
        this.newValidationSet.clear();
        this.validationFrontier.add(new FluidManipulationBehaviour.BlockPosEntry(root, 0));
        this.setValidationTimer();
    }

    private void continueSearch() {
        try {
            this.fluid = this.search(this.fluid, this.frontier, this.visited, (e, d) -> {
                this.queue.enqueue((Object)new FluidManipulationBehaviour.BlockPosEntry((BlockPos)e, (int)d));
                this.validationSet.add((BlockPos)e);
            }, false);
        }
        catch (FluidManipulationBehaviour.ChunkNotLoadedException e2) {
            this.tileEntity.sendData();
            this.frontier.clear();
            this.visited.clear();
        }
        Level world = this.getWorld();
        int maxBlocks = this.maxBlocks();
        if (this.visited.size() > maxBlocks && this.canDrainInfinitely(this.fluid) && !this.queue.isEmpty()) {
            BlockPos first;
            this.infinite = true;
            while (this.canPullFluidsFrom(world.m_8055_(first = ((FluidManipulationBehaviour.BlockPosEntry)this.queue.first()).pos()), first) != FluidBlockType.SOURCE) {
                this.queue.dequeue();
            }
            BlockPos firstValid = ((FluidManipulationBehaviour.BlockPosEntry)this.queue.first()).pos();
            this.frontier.clear();
            this.visited.clear();
            this.queue.clear();
            this.queue.enqueue((Object)new FluidManipulationBehaviour.BlockPosEntry(firstValid, 0));
            this.tileEntity.sendData();
            return;
        }
        if (!this.frontier.isEmpty()) {
            return;
        }
        this.tileEntity.sendData();
        this.visited.clear();
    }

    private void continueValidation() {
        try {
            this.search(this.fluid, this.validationFrontier, this.validationVisited, (e, d) -> this.newValidationSet.add((BlockPos)e), false);
        }
        catch (FluidManipulationBehaviour.ChunkNotLoadedException e2) {
            this.validationFrontier.clear();
            this.validationVisited.clear();
            this.setLongValidationTimer();
            return;
        }
        int maxBlocks = this.maxBlocks();
        if (this.validationVisited.size() > maxBlocks && this.canDrainInfinitely(this.fluid)) {
            if (!this.infinite) {
                this.reset();
            }
            this.validationFrontier.clear();
            this.setLongValidationTimer();
            return;
        }
        if (!this.validationFrontier.isEmpty()) {
            return;
        }
        if (this.infinite) {
            this.reset();
            return;
        }
        this.validationSet = this.newValidationSet;
        this.newValidationSet = new HashSet<BlockPos>();
        this.validationVisited.clear();
    }

    @Override
    public void reset() {
        super.reset();
        this.fluid = null;
        this.rootPos = null;
        this.queue.clear();
        this.validationSet.clear();
        this.newValidationSet.clear();
        this.validationFrontier.clear();
        this.validationVisited.clear();
        this.tileEntity.sendData();
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    protected boolean isSearching() {
        return !this.frontier.isEmpty();
    }

    public FluidStack getDrainableFluid(BlockPos rootPos) {
        return this.fluid == null || this.isSearching() || !this.pullNext(rootPos, true) ? FluidStack.EMPTY : new FluidStack(this.fluid, 1000);
    }

    static enum FluidBlockType {
        NONE,
        SOURCE,
        FLOWING;

    }
}

