/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.actors;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.fluids.actors.FluidSplashPacket;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;

public abstract class FluidManipulationBehaviour
extends TileEntityBehaviour {
    BoundingBox affectedArea;
    BlockPos rootPos;
    boolean infinite;
    protected boolean counterpartActed;
    static final int searchedPerTick = 1024;
    static final int validationTimerMin = 160;
    List<BlockPosEntry> frontier;
    Set<BlockPos> visited;
    int revalidateIn;

    public FluidManipulationBehaviour(SmartTileEntity te) {
        super(te);
        this.setValidationTimer();
        this.infinite = false;
        this.visited = new HashSet<BlockPos>();
        this.frontier = new ArrayList<BlockPosEntry>();
    }

    public void counterpartActed() {
        this.counterpartActed = true;
    }

    protected int validationTimer() {
        int maxBlocks = this.maxBlocks();
        return maxBlocks < 0 ? 160 : Math.max(160, maxBlocks / 1024 + 1);
    }

    protected int setValidationTimer() {
        this.revalidateIn = this.validationTimer();
        return this.revalidateIn;
    }

    protected int setLongValidationTimer() {
        this.revalidateIn = this.validationTimer() * 2;
        return this.revalidateIn;
    }

    protected int maxRange() {
        return (Integer)AllConfigs.SERVER.fluids.hosePulleyRange.get();
    }

    protected int maxBlocks() {
        return (Integer)AllConfigs.SERVER.fluids.hosePulleyBlockThreshold.get();
    }

    protected boolean fillInfinite() {
        return (Boolean)AllConfigs.SERVER.fluids.fillInfinite.get();
    }

    public void reset() {
        if (this.affectedArea != null) {
            this.scheduleUpdatesInAffectedArea();
        }
        this.affectedArea = null;
        this.setValidationTimer();
        this.frontier.clear();
        this.visited.clear();
        this.infinite = false;
    }

    @Override
    public void destroy() {
        this.reset();
        super.destroy();
    }

    protected void scheduleUpdatesInAffectedArea() {
        Level world = this.getWorld();
        BlockPos.m_121990_((BlockPos)new BlockPos(this.affectedArea.m_162395_() - 1, this.affectedArea.m_162396_() - 1, this.affectedArea.m_162398_() - 1), (BlockPos)new BlockPos(this.affectedArea.m_162399_() + 1, this.affectedArea.m_162400_() + 1, this.affectedArea.m_162401_() + 1)).forEach(pos -> {
            FluidState nextFluidState = world.m_6425_(pos);
            if (nextFluidState.m_76178_()) {
                return;
            }
            world.m_186469_(pos, nextFluidState.m_76152_(), world.m_5822_().nextInt(5));
        });
    }

    protected int comparePositions(BlockPosEntry e1, BlockPosEntry e2) {
        Vec3 centerOfRoot = VecHelper.getCenterOf((Vec3i)this.rootPos);
        BlockPos pos2 = e2.pos;
        BlockPos pos1 = e1.pos;
        if (pos1.m_123342_() != pos2.m_123342_()) {
            return Integer.compare(pos2.m_123342_(), pos1.m_123342_());
        }
        int compareDistance = Integer.compare(e2.distance, e1.distance);
        if (compareDistance != 0) {
            return compareDistance;
        }
        return Double.compare(VecHelper.getCenterOf((Vec3i)pos2).m_82557_(centerOfRoot), VecHelper.getCenterOf((Vec3i)pos1).m_82557_(centerOfRoot));
    }

    protected Fluid search(Fluid fluid, List<BlockPosEntry> frontier, Set<BlockPos> visited, BiConsumer<BlockPos, Integer> add, boolean searchDownward) throws ChunkNotLoadedException {
        Level world = this.getWorld();
        int maxBlocks = this.maxBlocks();
        int maxRange = this.canDrainInfinitely(fluid) ? this.maxRange() : this.maxRange() / 2;
        int maxRangeSq = maxRange * maxRange;
        for (int i = 0; !(i >= 1024 || frontier.isEmpty() || visited.size() > maxBlocks && this.canDrainInfinitely(fluid)); ++i) {
            BlockPosEntry entry = frontier.remove(0);
            BlockPos currentPos = entry.pos;
            if (visited.contains(currentPos)) continue;
            visited.add(currentPos);
            if (!world.m_46749_(currentPos)) {
                throw new ChunkNotLoadedException();
            }
            FluidState fluidState = world.m_6425_(currentPos);
            if (fluidState.m_76178_()) continue;
            Fluid currentFluid = FluidHelper.convertToStill(fluidState.m_76152_());
            if (fluid == null) {
                fluid = currentFluid;
            }
            if (!currentFluid.m_6212_(fluid)) continue;
            add.accept(currentPos, entry.distance);
            for (Direction side : Iterate.directions) {
                Fluid nextFluid;
                FluidState nextFluidState;
                if (!searchDownward && side == Direction.DOWN) continue;
                BlockPos offsetPos = currentPos.m_142300_(side);
                if (!world.m_46749_(offsetPos)) {
                    throw new ChunkNotLoadedException();
                }
                if (visited.contains(offsetPos) || offsetPos.m_123331_((Vec3i)this.rootPos) > (double)maxRangeSq || (nextFluidState = world.m_6425_(offsetPos)).m_76178_() || (nextFluid = nextFluidState.m_76152_()) == FluidHelper.convertToFlowing(nextFluid) && side == Direction.UP && !VecHelper.onSameAxis(this.rootPos, offsetPos, Direction.Axis.Y)) continue;
                frontier.add(new BlockPosEntry(offsetPos, entry.distance + 1));
            }
        }
        return fluid;
    }

    protected void playEffect(Level world, BlockPos pos, Fluid fluid, boolean fillSound) {
        SoundEvent soundevent;
        BlockPos splooshPos = pos == null ? this.tileEntity.m_58899_() : pos;
        SoundEvent soundEvent = soundevent = fillSound ? fluid.getAttributes().getFillSound() : fluid.getAttributes().getEmptySound();
        if (soundevent == null) {
            soundevent = FluidHelper.isTag(fluid, (TagKey<Fluid>)FluidTags.f_13132_) ? (fillSound ? SoundEvents.f_11783_ : SoundEvents.f_11780_) : (fillSound ? SoundEvents.f_11781_ : SoundEvents.f_11778_);
        }
        world.m_5594_(null, splooshPos, soundevent, SoundSource.BLOCKS, 0.3f, 1.0f);
        if (world instanceof ServerLevel) {
            AllPackets.sendToNear(world, splooshPos, 10, new FluidSplashPacket(splooshPos, new FluidStack(fluid, 1)));
        }
    }

    protected boolean canDrainInfinitely(Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        return this.maxBlocks() != -1 && ((BottomlessFluidMode)AllConfigs.SERVER.fluids.bottomlessFluidMode.get()).test(fluid);
    }

    @Override
    public void write(CompoundTag nbt, boolean clientPacket) {
        if (this.infinite) {
            NBTHelper.putMarker(nbt, "Infinite");
        }
        if (this.rootPos != null) {
            nbt.m_128365_("LastPos", (Tag)NbtUtils.m_129224_((BlockPos)this.rootPos));
        }
        if (this.affectedArea != null) {
            nbt.m_128365_("AffectedAreaFrom", (Tag)NbtUtils.m_129224_((BlockPos)new BlockPos(this.affectedArea.m_162395_(), this.affectedArea.m_162396_(), this.affectedArea.m_162398_())));
            nbt.m_128365_("AffectedAreaTo", (Tag)NbtUtils.m_129224_((BlockPos)new BlockPos(this.affectedArea.m_162399_(), this.affectedArea.m_162400_(), this.affectedArea.m_162401_())));
        }
        super.write(nbt, clientPacket);
    }

    @Override
    public void read(CompoundTag nbt, boolean clientPacket) {
        this.infinite = nbt.m_128441_("Infinite");
        if (nbt.m_128441_("LastPos")) {
            this.rootPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("LastPos"));
        }
        if (nbt.m_128441_("AffectedAreaFrom") && nbt.m_128441_("AffectedAreaTo")) {
            this.affectedArea = BoundingBox.m_162375_((Vec3i)NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("AffectedAreaFrom")), (Vec3i)NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("AffectedAreaTo")));
        }
        super.read(nbt, clientPacket);
    }

    public record BlockPosEntry(BlockPos pos, int distance) {
    }

    public static class ChunkNotLoadedException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static enum BottomlessFluidMode implements Predicate<Fluid>
    {
        ALLOW_ALL(fluid -> true),
        DENY_ALL(fluid -> false),
        ALLOW_BY_TAG(fluid -> AllTags.AllFluidTags.BOTTOMLESS_ALLOW.matches((Fluid)fluid)),
        DENY_BY_TAG(fluid -> !AllTags.AllFluidTags.BOTTOMLESS_DENY.matches((Fluid)fluid));

        private final Predicate<Fluid> predicate;

        private BottomlessFluidMode(Predicate<Fluid> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean test(Fluid fluid) {
            return this.predicate.test(fluid);
        }
    }
}

