/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.pipes;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.ITransformableTE;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.contraptions.fluids.FluidPropagator;
import com.simibubi.create.content.contraptions.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.contraptions.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.contraptions.relays.elementary.BracketedTileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FluidPipeTileEntity
extends SmartTileEntity
implements ITransformableTE {
    public FluidPipeTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        behaviours.add(new StandardPipeFluidTransportBehaviour(this));
        behaviours.add(new BracketedTileEntityBehaviour(this, this::canHaveBracket));
        this.registerAwardables(behaviours, FluidPropagator.getSharedTriggers());
    }

    @Override
    public void transform(StructureTransform transform) {
        BracketedTileEntityBehaviour bracketBehaviour = this.getBehaviour(BracketedTileEntityBehaviour.TYPE);
        if (bracketBehaviour != null) {
            bracketBehaviour.transformBracket(transform);
        }
    }

    private boolean canHaveBracket(BlockState state) {
        return !(state.m_60734_() instanceof EncasedPipeBlock);
    }

    class StandardPipeFluidTransportBehaviour
    extends FluidTransportBehaviour {
        public StandardPipeFluidTransportBehaviour(SmartTileEntity te) {
            super(te);
        }

        @Override
        public boolean canHaveFlowToward(BlockState state, Direction direction) {
            return (FluidPipeBlock.isPipe(state) || state.m_60734_() instanceof EncasedPipeBlock) && (Boolean)state.m_61143_((Property)FluidPipeBlock.f_55154_.get(direction)) != false;
        }

        @Override
        public FluidTransportBehaviour.AttachmentTypes getRenderedRimAttachment(BlockAndTintGetter world, BlockPos pos, BlockState state, Direction direction) {
            FluidTransportBehaviour pipeBehaviour;
            FluidTransportBehaviour.AttachmentTypes attachment = super.getRenderedRimAttachment(world, pos, state, direction);
            BlockPos offsetPos = pos.m_142300_(direction);
            BlockState otherState = world.m_8055_(offsetPos);
            if (attachment == FluidTransportBehaviour.AttachmentTypes.RIM && !FluidPipeBlock.isPipe(otherState) && !AllBlocks.MECHANICAL_PUMP.has(otherState) && !AllBlocks.ENCASED_FLUID_PIPE.has(otherState) && (pipeBehaviour = TileEntityBehaviour.get((BlockGetter)world, offsetPos, FluidTransportBehaviour.TYPE)) != null && pipeBehaviour.canHaveFlowToward(otherState, direction.m_122424_())) {
                return FluidTransportBehaviour.AttachmentTypes.CONNECTION;
            }
            if (attachment == FluidTransportBehaviour.AttachmentTypes.RIM && !FluidPipeBlock.shouldDrawRim(world, pos, state, direction)) {
                return FluidTransportBehaviour.AttachmentTypes.CONNECTION;
            }
            if (attachment == FluidTransportBehaviour.AttachmentTypes.NONE && ((Boolean)state.m_61143_((Property)FluidPipeBlock.f_55154_.get(direction))).booleanValue()) {
                return FluidTransportBehaviour.AttachmentTypes.CONNECTION;
            }
            return attachment;
        }
    }
}

