/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.processing.BasinRecipe;
import com.simibubi.create.content.contraptions.processing.BasinTileEntity;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.simple.DeferralBehaviour;
import com.simibubi.create.foundation.utility.recipe.RecipeFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BasinOperatingTileEntity
extends KineticTileEntity {
    public DeferralBehaviour basinChecker;
    public boolean basinRemoved;
    protected Recipe<?> currentRecipe;

    public BasinOperatingTileEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.basinChecker = new DeferralBehaviour(this, this::updateBasin);
        behaviours.add(this.basinChecker);
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        if (this.getSpeed() == 0.0f) {
            this.basinRemoved = true;
        }
        this.basinRemoved = false;
        this.basinChecker.scheduleUpdate();
    }

    @Override
    public void tick() {
        if (this.basinRemoved) {
            this.basinRemoved = false;
            this.onBasinRemoved();
            this.sendData();
            return;
        }
        super.tick();
    }

    protected boolean updateBasin() {
        if (!this.isSpeedRequirementFulfilled()) {
            return true;
        }
        if (this.getSpeed() == 0.0f) {
            return true;
        }
        if (this.isRunning()) {
            return true;
        }
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return true;
        }
        Optional<BasinTileEntity> basin = this.getBasin();
        if (!basin.filter(BasinTileEntity::canContinueProcessing).isPresent()) {
            return true;
        }
        List<Recipe<?>> recipes = this.getMatchingRecipes();
        if (recipes.isEmpty()) {
            return true;
        }
        this.currentRecipe = recipes.get(0);
        this.startProcessingBasin();
        this.sendData();
        return true;
    }

    protected abstract boolean isRunning();

    public void startProcessingBasin() {
    }

    public boolean continueWithPreviousRecipe() {
        return true;
    }

    protected <C extends Container> boolean matchBasinRecipe(Recipe<C> recipe) {
        if (recipe == null) {
            return false;
        }
        Optional<BasinTileEntity> basin = this.getBasin();
        if (!basin.isPresent()) {
            return false;
        }
        return BasinRecipe.match(basin.get(), recipe);
    }

    protected void applyBasinRecipe() {
        if (this.currentRecipe == null) {
            return;
        }
        Optional<BasinTileEntity> optionalBasin = this.getBasin();
        if (!optionalBasin.isPresent()) {
            return;
        }
        BasinTileEntity basin = optionalBasin.get();
        boolean wasEmpty = basin.canContinueProcessing();
        if (!BasinRecipe.apply(basin, this.currentRecipe)) {
            return;
        }
        this.getProcessedRecipeTrigger().ifPresent(this::award);
        basin.inputTank.sendDataImmediately();
        if (wasEmpty && this.matchBasinRecipe(this.currentRecipe)) {
            this.continueWithPreviousRecipe();
            this.sendData();
        }
        basin.notifyChangeOfContents();
    }

    protected List<Recipe<?>> getMatchingRecipes() {
        if (this.getBasin().map(BasinTileEntity::isEmpty).orElse(true).booleanValue()) {
            return new ArrayList();
        }
        List<Recipe<?>> list = RecipeFinder.get(this.getRecipeCacheKey(), this.f_58857_, this::matchStaticFilters);
        return list.stream().filter(this::matchBasinRecipe).sorted((r1, r2) -> r2.m_7527_().size() - r1.m_7527_().size()).collect(Collectors.toList());
    }

    protected abstract void onBasinRemoved();

    protected Optional<BasinTileEntity> getBasin() {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        BlockEntity basinTE = this.f_58857_.m_7702_(this.f_58858_.m_6625_(2));
        if (!(basinTE instanceof BasinTileEntity)) {
            return Optional.empty();
        }
        return Optional.of((BasinTileEntity)basinTE);
    }

    protected Optional<CreateAdvancement> getProcessedRecipeTrigger() {
        return Optional.empty();
    }

    protected abstract <C extends Container> boolean matchStaticFilters(Recipe<C> var1);

    protected abstract Object getRecipeCacheKey();
}

