/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.mechanicalArm;

import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmAngleTarget;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmInteractionPointType;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ArmInteractionPoint {
    protected final ArmInteractionPointType type;
    protected Level level;
    protected final BlockPos pos;
    protected Mode mode = Mode.DEPOSIT;
    protected BlockState cachedState;
    protected LazyOptional<IItemHandler> cachedHandler = LazyOptional.empty();
    protected ArmAngleTarget cachedAngles;

    public ArmInteractionPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
        this.type = type;
        this.level = level;
        this.pos = pos;
        this.cachedState = state;
    }

    public ArmInteractionPointType getType() {
        return this.type;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void cycleMode() {
        this.mode = this.mode == Mode.DEPOSIT ? Mode.TAKE : Mode.DEPOSIT;
    }

    protected Vec3 getInteractionPositionVector() {
        return VecHelper.getCenterOf((Vec3i)this.pos);
    }

    protected Direction getInteractionDirection() {
        return Direction.DOWN;
    }

    public ArmAngleTarget getTargetAngles(BlockPos armPos, boolean ceiling) {
        if (this.cachedAngles == null) {
            this.cachedAngles = new ArmAngleTarget(armPos, this.getInteractionPositionVector(), this.getInteractionDirection(), ceiling);
        }
        return this.cachedAngles;
    }

    public void updateCachedState() {
        this.cachedState = this.level.m_8055_(this.pos);
    }

    public boolean isValid() {
        this.updateCachedState();
        return this.type.canCreatePoint(this.level, this.pos, this.cachedState);
    }

    public void keepAlive() {
    }

    @Nullable
    protected IItemHandler getHandler() {
        if (!this.cachedHandler.isPresent()) {
            BlockEntity te = this.level.m_7702_(this.pos);
            if (te == null) {
                return null;
            }
            this.cachedHandler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP);
        }
        return (IItemHandler)this.cachedHandler.orElse(null);
    }

    public ItemStack insert(ItemStack stack, boolean simulate) {
        IItemHandler handler = this.getHandler();
        if (handler == null) {
            return stack;
        }
        return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
    }

    public ItemStack extract(int slot, int amount, boolean simulate) {
        IItemHandler handler = this.getHandler();
        if (handler == null) {
            return ItemStack.f_41583_;
        }
        return handler.extractItem(slot, amount, simulate);
    }

    public ItemStack extract(int slot, boolean simulate) {
        return this.extract(slot, 64, simulate);
    }

    public int getSlotCount() {
        IItemHandler handler = this.getHandler();
        if (handler == null) {
            return 0;
        }
        return handler.getSlots();
    }

    protected void serialize(CompoundTag nbt, BlockPos anchor) {
        NBTHelper.writeEnum(nbt, "Mode", this.mode);
    }

    protected void deserialize(CompoundTag nbt, BlockPos anchor) {
        this.mode = NBTHelper.readEnum(nbt, "Mode", Mode.class);
    }

    public final CompoundTag serialize(BlockPos anchor) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Type", this.type.getId().toString());
        nbt.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)this.pos.m_141950_((Vec3i)anchor)));
        this.serialize(nbt, anchor);
        return nbt;
    }

    @Nullable
    public static ArmInteractionPoint deserialize(CompoundTag nbt, Level level, BlockPos anchor) {
        BlockState state;
        ResourceLocation id = ResourceLocation.m_135820_((String)nbt.m_128461_("Type"));
        if (id == null) {
            return null;
        }
        ArmInteractionPointType type = ArmInteractionPointType.get(id);
        if (type == null) {
            return null;
        }
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Pos")).m_141952_((Vec3i)anchor);
        if (!type.canCreatePoint(level, pos, state = level.m_8055_(pos))) {
            return null;
        }
        ArmInteractionPoint point = type.createPoint(level, pos, state);
        if (point == null) {
            return null;
        }
        point.deserialize(nbt, anchor);
        return point;
    }

    public static void transformPos(CompoundTag nbt, StructureTransform transform) {
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Pos"));
        pos = transform.applyWithoutOffset(pos);
        nbt.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
    }

    public static boolean isInteractable(Level level, BlockPos pos, BlockState state) {
        return ArmInteractionPointType.getPrimaryType(level, pos, state) != null;
    }

    @Nullable
    public static ArmInteractionPoint create(Level level, BlockPos pos, BlockState state) {
        ArmInteractionPointType type = ArmInteractionPointType.getPrimaryType(level, pos, state);
        if (type == null) {
            return null;
        }
        return type.createPoint(level, pos, state);
    }

    public static enum Mode {
        DEPOSIT("mechanical_arm.deposit_to", 14532966),
        TAKE("mechanical_arm.extract_from", 8375776);

        private final String translationKey;
        private final int color;

        private Mode(String translationKey, int color) {
            this.translationKey = translationKey;
            this.color = color;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public int getColor() {
            return this.color;
        }
    }
}

