/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.logistics.item.LecternControllerTileEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public abstract class LinkedControllerPacketBase
extends SimplePacketBase {
    private BlockPos lecternPos;

    public LinkedControllerPacketBase(BlockPos lecternPos) {
        this.lecternPos = lecternPos;
    }

    public LinkedControllerPacketBase(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            this.lecternPos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
        }
    }

    protected boolean inLectern() {
        return this.lecternPos != null;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.inLectern());
        if (this.inLectern()) {
            buffer.writeInt(this.lecternPos.m_123341_());
            buffer.writeInt(this.lecternPos.m_123342_());
            buffer.writeInt(this.lecternPos.m_123343_());
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            if (this.inLectern()) {
                BlockEntity te = player.f_19853_.m_7702_(this.lecternPos);
                if (!(te instanceof LecternControllerTileEntity)) {
                    return;
                }
                this.handleLectern(player, (LecternControllerTileEntity)te);
            } else {
                ItemStack controller = player.m_21205_();
                if (!AllItems.LINKED_CONTROLLER.isIn(controller) && !AllItems.LINKED_CONTROLLER.isIn(controller = player.m_21206_())) {
                    return;
                }
                this.handleItem(player, controller);
            }
        });
        context.get().setPacketHandled(true);
    }

    protected abstract void handleItem(ServerPlayer var1, ItemStack var2);

    protected abstract void handleLectern(ServerPlayer var1, LecternControllerTileEntity var2);
}

