/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.entity;

import com.simibubi.create.content.logistics.trains.TrackEdge;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.TrackNode;
import com.simibubi.create.content.logistics.trains.entity.Carriage;
import com.simibubi.create.content.logistics.trains.entity.CarriageBogey;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.logistics.trains.entity.TravellingPoint;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Vector;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class CarriageSyncData {
    public Vector<Pair<Couple<Integer>, Float>> wheelLocations = new Vector(4);
    public Pair<Vec3, Couple<Vec3>> fallbackLocations = null;
    public float distanceToDestination;
    public boolean leadingCarriage = false;
    private Pair<Vec3, Couple<Vec3>> fallbackPointSnapshot = null;
    private TravellingPoint[] pointsToApproach;
    private float[] pointDistanceSnapshot = new float[4];
    private float destinationDistanceSnapshot = 0.0f;
    private int ticksSince = 0;
    private boolean isDirty;

    public CarriageSyncData() {
        this.pointsToApproach = new TravellingPoint[4];
        for (int i = 0; i < 4; ++i) {
            this.wheelLocations.add(null);
            this.pointsToApproach[i] = new TravellingPoint();
        }
    }

    public CarriageSyncData copy() {
        CarriageSyncData data = new CarriageSyncData();
        for (int i = 0; i < 4; ++i) {
            data.wheelLocations.set(i, this.wheelLocations.get(i));
        }
        if (this.fallbackLocations != null) {
            data.fallbackLocations = this.fallbackLocations.copy();
        }
        data.distanceToDestination = this.distanceToDestination;
        data.leadingCarriage = this.leadingCarriage;
        return data;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.leadingCarriage);
        buffer.writeBoolean(this.fallbackLocations != null);
        if (this.fallbackLocations != null) {
            Vec3 contraptionAnchor = this.fallbackLocations.getFirst();
            Couple<Vec3> rotationAnchors = this.fallbackLocations.getSecond();
            VecHelper.write(contraptionAnchor, buffer);
            VecHelper.write((Vec3)rotationAnchors.getFirst(), buffer);
            VecHelper.write((Vec3)rotationAnchors.getSecond(), buffer);
            return;
        }
        for (Pair<Couple<Integer>, Float> pair : this.wheelLocations) {
            buffer.writeBoolean(pair == null);
            if (pair == null) break;
            pair.getFirst().forEach(arg_0 -> ((FriendlyByteBuf)buffer).writeInt(arg_0));
            buffer.writeFloat(pair.getSecond().floatValue());
        }
        buffer.writeFloat(this.distanceToDestination);
    }

    public void read(FriendlyByteBuf buffer) {
        this.leadingCarriage = buffer.readBoolean();
        boolean fallback = buffer.readBoolean();
        this.ticksSince = 0;
        if (fallback) {
            this.fallbackLocations = Pair.of(VecHelper.read(buffer), Couple.create(VecHelper.read(buffer), VecHelper.read(buffer)));
            return;
        }
        this.fallbackLocations = null;
        for (int i = 0; i < 4 && !buffer.readBoolean(); ++i) {
            this.wheelLocations.set(i, Pair.of(Couple.create(() -> ((FriendlyByteBuf)buffer).readInt()), Float.valueOf(buffer.readFloat())));
        }
        this.distanceToDestination = buffer.readFloat();
    }

    public void update(CarriageContraptionEntity entity, Carriage carriage) {
        Carriage.DimensionalCarriageEntity dce = carriage.getDimensional(entity.f_19853_);
        TrackGraph graph = carriage.train.graph;
        if (graph == null) {
            this.fallbackLocations = Pair.of(dce.positionAnchor, dce.rotationAnchors);
            dce.pointsInitialised = true;
            this.setDirty(true);
            return;
        }
        this.fallbackLocations = null;
        this.leadingCarriage = entity.carriageIndex == (carriage.train.speed >= 0.0 ? 0 : carriage.train.carriages.size() - 1);
        for (boolean first : Iterate.trueAndFalse) {
            if (!first && !carriage.isOnTwoBogeys()) break;
            CarriageBogey bogey = carriage.bogeys.get(first);
            for (boolean firstPoint : Iterate.trueAndFalse) {
                TravellingPoint point = bogey.points.get(firstPoint);
                int index = (first ? 0 : 2) + (firstPoint ? 0 : 1);
                Pair<Couple<Integer>, Float> pair = Pair.of(Couple.create(point.node1.getNetId(), point.node2.getNetId()), Float.valueOf((float)point.position));
                this.wheelLocations.set(index, pair);
            }
        }
        this.distanceToDestination = (float)carriage.train.navigation.distanceToDestination;
        this.setDirty(true);
    }

    public void apply(CarriageContraptionEntity entity, Carriage carriage) {
        Pair<Couple<Integer>, Float> pair;
        Carriage.DimensionalCarriageEntity dce = carriage.getDimensional(entity.f_19853_);
        this.fallbackPointSnapshot = null;
        if (this.fallbackLocations != null) {
            this.fallbackPointSnapshot = Pair.of(dce.positionAnchor, dce.rotationAnchors);
            dce.pointsInitialised = true;
            return;
        }
        TrackGraph graph = carriage.train.graph;
        if (graph == null) {
            return;
        }
        for (int i = 0; i < this.wheelLocations.size() && (pair = this.wheelLocations.get(i)) != null; ++i) {
            TrackEdge edge;
            CarriageBogey bogey = carriage.bogeys.get(i / 2 == 0);
            TravellingPoint bogeyPoint = bogey.points.get(i % 2 == 0);
            TravellingPoint point = dce.pointsInitialised ? this.pointsToApproach[i] : bogeyPoint;
            Couple<TrackNode> nodes = pair.getFirst().map(graph::getNode);
            if (nodes.either(Objects::isNull) || (edge = graph.getConnectionsFrom((TrackNode)nodes.getFirst()).get(nodes.getSecond())) == null) continue;
            point.node1 = (TrackNode)nodes.getFirst();
            point.node2 = (TrackNode)nodes.getSecond();
            point.edge = edge;
            point.position = pair.getSecond().floatValue();
            if (!dce.pointsInitialised) continue;
            float foundDistance = -1.0f;
            boolean direction = false;
            for (boolean forward : Iterate.trueAndFalse) {
                float distanceTo = this.getDistanceTo(graph, bogeyPoint, point, foundDistance, forward);
                if (!(distanceTo > 0.0f) || foundDistance != -1.0f && !(distanceTo < foundDistance)) continue;
                foundDistance = distanceTo;
                direction = forward;
            }
            if (foundDistance != -1.0f) {
                this.pointDistanceSnapshot[i] = (float)(direction ? 1 : -1) * foundDistance;
                continue;
            }
            bogeyPoint.node1 = point.node1;
            bogeyPoint.node2 = point.node2;
            bogeyPoint.edge = point.edge;
            bogeyPoint.position = point.position;
            this.pointDistanceSnapshot[i] = 0.0f;
        }
        if (!dce.pointsInitialised) {
            carriage.train.navigation.distanceToDestination = this.distanceToDestination;
            dce.pointsInitialised = true;
            return;
        }
        if (!this.leadingCarriage) {
            return;
        }
        this.destinationDistanceSnapshot = (float)((double)this.distanceToDestination - carriage.train.navigation.distanceToDestination);
    }

    public void approach(CarriageContraptionEntity entity, Carriage carriage, float partialIn) {
        Carriage.DimensionalCarriageEntity dce = carriage.getDimensional(entity.f_19853_);
        int updateInterval = entity.m_6095_().m_20682_();
        if (this.ticksSince >= updateInterval * 2) {
            partialIn /= (float)(this.ticksSince - updateInterval * 2 + 1);
        }
        float partial = partialIn *= ServerSpeedProvider.get();
        ++this.ticksSince;
        if (this.fallbackLocations != null && this.fallbackPointSnapshot != null) {
            dce.positionAnchor = this.approachVector(partial, dce.positionAnchor, this.fallbackLocations.getFirst(), this.fallbackPointSnapshot.getFirst());
            dce.rotationAnchors.replaceWithContext((current, first) -> this.approachVector(partial, (Vec3)current, this.fallbackLocations.getSecond().get((boolean)first), this.fallbackPointSnapshot.getSecond().get((boolean)first)));
            return;
        }
        TrackGraph graph = carriage.train.graph;
        if (graph == null) {
            return;
        }
        carriage.train.navigation.distanceToDestination += (double)(partial * this.destinationDistanceSnapshot);
        for (boolean first2 : Iterate.trueAndFalse) {
            if (!first2 && !carriage.isOnTwoBogeys()) break;
            CarriageBogey bogey = carriage.bogeys.get(first2);
            boolean[] blArray = Iterate.trueAndFalse;
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                boolean firstPoint;
                int index = (first2 ? 0 : 2) + ((firstPoint = blArray[i]) ? 0 : 1);
                float f = this.pointDistanceSnapshot[index];
                if (Mth.m_14033_((float)f, (float)0.0f)) continue;
                TravellingPoint point = bogey.points.get(firstPoint);
                MutableBoolean success = new MutableBoolean(true);
                TravellingPoint toApproach = this.pointsToApproach[index];
                TravellingPoint.ITrackSelector trackSelector = point.follow(toApproach, b -> success.setValue(success.booleanValue() && b != false));
                point.travel(graph, partial * f, trackSelector);
                if (success.booleanValue()) continue;
                point.node1 = toApproach.node1;
                point.node2 = toApproach.node2;
                point.edge = toApproach.edge;
                point.position = toApproach.position;
                this.pointDistanceSnapshot[index] = 0.0f;
            }
        }
    }

    private Vec3 approachVector(float partial, Vec3 current, Vec3 target, Vec3 snapshot) {
        if (current == null || snapshot == null) {
            return target;
        }
        return current.m_82549_(target.m_82546_(snapshot).m_82490_((double)partial));
    }

    public float getDistanceTo(TrackGraph graph, TravellingPoint current, TravellingPoint target, float maxDistance, boolean forward) {
        if (maxDistance == -1.0f) {
            maxDistance = 32.0f;
        }
        HashSet<TrackEdge> visited = new HashSet<TrackEdge>();
        IdentityHashMap<TrackEdge, Pair<Boolean, TrackEdge>> reachedVia = new IdentityHashMap<TrackEdge, Pair<Boolean, TrackEdge>>();
        PriorityQueue<Pair<Double, Pair<Couple<TrackNode>, TrackEdge>>> frontier = new PriorityQueue<Pair<Double, Pair<Couple<TrackNode>, TrackEdge>>>((p1, p2) -> Double.compare((Double)p1.getFirst(), (Double)p2.getFirst()));
        TrackNode initialNode1 = forward ? current.node1 : current.node2;
        TrackNode initialNode2 = forward ? current.node2 : current.node1;
        TrackEdge initialEdge = graph.getConnectionsFrom(initialNode1).get(initialNode2);
        if (initialEdge == null) {
            return -1.0f;
        }
        TrackNode targetNode1 = forward ? target.node1 : target.node2;
        TrackNode targetNode2 = forward ? target.node2 : target.node1;
        TrackEdge targetEdge = graph.getConnectionsFrom(targetNode1).get(targetNode2);
        double distanceToNode2 = forward ? initialEdge.getLength() - current.position : current.position;
        frontier.add(Pair.of(distanceToNode2, Pair.of(Couple.create(initialNode1, initialNode2), initialEdge)));
        while (!frontier.isEmpty()) {
            Pair poll = (Pair)frontier.poll();
            double distance = (Double)poll.getFirst();
            Pair currentEntry = (Pair)poll.getSecond();
            TrackNode node2 = (TrackNode)((Couple)currentEntry.getFirst()).getSecond();
            TrackEdge edge = (TrackEdge)currentEntry.getSecond();
            if (edge == targetEdge) {
                return (float)(distance - (forward ? edge.getLength() - target.position : target.position));
            }
            if (distance > (double)maxDistance) continue;
            ArrayList<Map.Entry<TrackNode, TrackEdge>> validTargets = new ArrayList<Map.Entry<TrackNode, TrackEdge>>();
            Map<TrackNode, TrackEdge> connectionsFrom = graph.getConnectionsFrom(node2);
            for (Map.Entry<TrackNode, TrackEdge> entry : connectionsFrom.entrySet()) {
                Vec3 newDirection;
                TrackEdge newEdge = entry.getValue();
                Vec3 currentDirection = edge.getDirection(false);
                if (currentDirection.m_82526_(newDirection = newEdge.getDirection(true)) < 0.875 || !visited.add(entry.getValue())) continue;
                validTargets.add(entry);
            }
            if (validTargets.isEmpty()) continue;
            for (Map.Entry<TrackNode, TrackEdge> entry : validTargets) {
                TrackNode newNode = entry.getKey();
                TrackEdge newEdge = entry.getValue();
                reachedVia.put(newEdge, Pair.of(validTargets.size() > 1, edge));
                frontier.add(Pair.of(newEdge.getLength() + distance, Pair.of(Couple.create(node2, newNode), newEdge)));
            }
        }
        return -1.0f;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public boolean isDirty() {
        return this.isDirty;
    }
}

