/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.entity;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.DimensionPalette;
import com.simibubi.create.content.logistics.trains.GraphLocation;
import com.simibubi.create.content.logistics.trains.TrackEdge;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.TrackNode;
import com.simibubi.create.content.logistics.trains.TrackNodeLocation;
import com.simibubi.create.content.logistics.trains.management.edgePoint.EdgeData;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.TrackEdgePoint;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class TravellingPoint {
    public TrackNode node1;
    public TrackNode node2;
    public TrackEdge edge;
    public double position;
    public boolean blocked;

    public TravellingPoint() {
    }

    public TravellingPoint(TrackNode node1, TrackNode node2, TrackEdge edge, double position) {
        this.node1 = node1;
        this.node2 = node2;
        this.edge = edge;
        this.position = position;
    }

    public IEdgePointListener ignoreEdgePoints() {
        return (d, c) -> false;
    }

    public ITurnListener ignoreTurns() {
        return (d, c) -> {};
    }

    public IPortalListener ignorePortals() {
        return $ -> false;
    }

    public ITrackSelector random() {
        return (graph, pair) -> (Map.Entry)((List)pair.getSecond()).get(Create.RANDOM.nextInt(((List)pair.getSecond()).size()));
    }

    public ITrackSelector follow(TravellingPoint other) {
        return this.follow(other, null);
    }

    public ITrackSelector follow(TravellingPoint other, @Nullable Consumer<Boolean> success) {
        return (graph, pair) -> {
            Map.Entry entry;
            List validTargets = (List)pair.getSecond();
            boolean forward = (Boolean)pair.getFirst();
            TrackNode target = forward ? other.node1 : other.node2;
            TrackNode secondary = forward ? other.node2 : other.node1;
            for (Map.Entry entry2 : validTargets) {
                if (entry2.getKey() != target && entry2.getKey() != secondary) continue;
                if (success != null) {
                    success.accept(true);
                }
                return entry2;
            }
            Vector frontiers = new Vector(validTargets.size());
            Vector visiteds = new Vector(validTargets.size());
            for (int j = 0; j < validTargets.size(); ++j) {
                ArrayList<Map.Entry> e = new ArrayList<Map.Entry>();
                entry = (Map.Entry)validTargets.get(j);
                e.add(entry);
                frontiers.add(e);
                HashSet<TrackEdge> e2 = new HashSet<TrackEdge>();
                e2.add((TrackEdge)entry.getValue());
                visiteds.add(e2);
            }
            for (int i = 0; i < 20; ++i) {
                for (int j = 0; j < validTargets.size(); ++j) {
                    entry = (Map.Entry)validTargets.get(j);
                    List frontier = (List)frontiers.get(j);
                    if (frontier.isEmpty()) continue;
                    Map.Entry currentEntry = (Map.Entry)frontier.remove(0);
                    for (Map.Entry<TrackNode, TrackEdge> nextEntry : graph.getConnectionsFrom((TrackNode)currentEntry.getKey()).entrySet()) {
                        TrackEdge nextEdge = nextEntry.getValue();
                        if (!((Set)visiteds.get(j)).add(nextEdge) || !((TrackEdge)currentEntry.getValue()).canTravelTo(nextEdge)) continue;
                        TrackNode nextNode = nextEntry.getKey();
                        if (nextNode == target) {
                            if (success != null) {
                                success.accept(true);
                            }
                            return entry;
                        }
                        frontier.add(nextEntry);
                    }
                }
            }
            if (success != null) {
                success.accept(false);
            }
            return (Map.Entry)validTargets.get(0);
        };
    }

    public ITrackSelector steer(SteerDirection direction, Vec3 upNormal) {
        return (graph, pair) -> {
            List validTargets = (List)pair.getSecond();
            double closest = Double.MAX_VALUE;
            Map.Entry best = null;
            for (Map.Entry entry : validTargets) {
                Vec3 trajectory = this.edge.getDirection(false);
                Vec3 entryTrajectory = ((TrackEdge)entry.getValue()).getDirection(true);
                Vec3 normal = trajectory.m_82537_(upNormal);
                double dot = normal.m_82526_(entryTrajectory);
                double diff = Math.abs((double)direction.targetDot - dot);
                if (diff > closest) continue;
                closest = diff;
                best = entry;
            }
            if (best == null) {
                Create.LOGGER.warn("Couldn't find steer target, choosing first");
                return (Map.Entry)validTargets.get(0);
            }
            return best;
        };
    }

    public double travel(TrackGraph graph, double distance, ITrackSelector trackSelector) {
        return this.travel(graph, distance, trackSelector, this.ignoreEdgePoints());
    }

    public double travel(TrackGraph graph, double distance, ITrackSelector trackSelector, IEdgePointListener signalListener) {
        return this.travel(graph, distance, trackSelector, signalListener, this.ignoreTurns());
    }

    public double travel(TrackGraph graph, double distance, ITrackSelector trackSelector, IEdgePointListener signalListener, ITurnListener turnListener) {
        return this.travel(graph, distance, trackSelector, signalListener, turnListener, this.ignorePortals());
    }

    public double travel(TrackGraph graph, double distance, ITrackSelector trackSelector, IEdgePointListener signalListener, ITurnListener turnListener, IPortalListener portalListener) {
        double collectedDistance;
        this.blocked = false;
        if (this.edge == null) {
            return 0.0;
        }
        double edgeLength = this.edge.getLength();
        if (Mth.m_14082_((double)distance, (double)0.0)) {
            return 0.0;
        }
        double prevPos = this.position;
        double traveled = distance;
        double currentT = edgeLength == 0.0 ? 0.0 : this.position / edgeLength;
        double incrementT = this.edge.incrementT(currentT, distance);
        this.position = incrementT * edgeLength;
        ArrayList<Map.Entry<TrackNode, TrackEdge>> validTargets = new ArrayList<Map.Entry<TrackNode, TrackEdge>>();
        boolean forward = distance > 0.0;
        Double blockedLocation = this.edgeTraversedFrom(graph, forward, signalListener, turnListener, prevPos, collectedDistance = forward ? -prevPos : -edgeLength + prevPos);
        if (blockedLocation != null) {
            this.position = blockedLocation;
            traveled = this.position - prevPos;
            return traveled;
        }
        if (forward) {
            while (this.position > edgeLength) {
                Map.Entry entry;
                validTargets.clear();
                for (Map.Entry<TrackNode, TrackEdge> entry2 : graph.getConnectionsFrom(this.node2).entrySet()) {
                    TrackEdge newEdge;
                    TrackNode newNode = entry2.getKey();
                    if (newNode == this.node1 || !this.edge.canTravelTo(newEdge = entry2.getValue())) continue;
                    validTargets.add(entry2);
                }
                if (validTargets.isEmpty()) {
                    traveled -= this.position - edgeLength;
                    this.position = edgeLength;
                    this.blocked = true;
                    break;
                }
                Map.Entry entry3 = entry = validTargets.size() == 1 ? (Map.Entry)validTargets.get(0) : (Map.Entry)trackSelector.apply(graph, Pair.of(true, validTargets));
                if (((TrackEdge)entry.getValue()).getLength() == 0.0 && portalListener.test(Couple.create(this.node2.getLocation(), ((TrackNode)entry.getKey()).getLocation()))) {
                    traveled -= this.position - edgeLength;
                    this.position = edgeLength;
                    this.blocked = true;
                    break;
                }
                this.node1 = this.node2;
                this.node2 = (TrackNode)entry.getKey();
                this.edge = (TrackEdge)entry.getValue();
                this.position -= edgeLength;
                collectedDistance += edgeLength;
                if (this.edge.isTurn()) {
                    turnListener.accept(collectedDistance, this.edge);
                }
                if ((blockedLocation = this.edgeTraversedFrom(graph, forward, signalListener, turnListener, 0.0, collectedDistance)) != null) {
                    traveled -= this.position;
                    this.position = blockedLocation;
                    traveled += this.position;
                    break;
                }
                prevPos = 0.0;
                edgeLength = this.edge.getLength();
            }
        } else {
            while (this.position < 0.0) {
                validTargets.clear();
                Object entry = graph.getConnectionsFrom(this.node1).entrySet().iterator();
                while (entry.hasNext()) {
                    Map.Entry<TrackNode, TrackEdge> entry4 = entry.next();
                    TrackNode newNode = entry4.getKey();
                    if (newNode == this.node2 || !graph.getConnectionsFrom(newNode).get(this.node1).canTravelTo(this.edge)) continue;
                    validTargets.add(entry4);
                }
                if (validTargets.isEmpty()) {
                    traveled -= this.position;
                    this.position = 0.0;
                    this.blocked = true;
                } else {
                    Object object = entry = validTargets.size() == 1 ? (Map.Entry)validTargets.get(0) : (Map.Entry)trackSelector.apply(graph, Pair.of(false, validTargets));
                    if (((TrackEdge)entry.getValue()).getLength() == 0.0 && portalListener.test(Couple.create(((TrackNode)entry.getKey()).getLocation(), this.node1.getLocation()))) {
                        traveled -= this.position;
                        this.position = 0.0;
                        this.blocked = true;
                    } else {
                        this.node2 = this.node1;
                        this.node1 = (TrackNode)entry.getKey();
                        this.edge = graph.getConnectionsFrom(this.node1).get(this.node2);
                        edgeLength = this.edge.getLength();
                        this.position += edgeLength;
                        blockedLocation = this.edgeTraversedFrom(graph, forward, signalListener, turnListener, edgeLength, collectedDistance += edgeLength);
                        if (blockedLocation == null) continue;
                        traveled -= this.position;
                        this.position = blockedLocation;
                        traveled += this.position;
                    }
                }
                break;
            }
        }
        return traveled;
    }

    private Double edgeTraversedFrom(TrackGraph graph, boolean forward, IEdgePointListener edgePointListener, ITurnListener turnListener, double prevPos, double totalDistance) {
        if (this.edge.isTurn()) {
            turnListener.accept(Math.max(0.0, totalDistance), this.edge);
        }
        double from = forward ? prevPos : this.position;
        double to = forward ? this.position : prevPos;
        EdgeData edgeData = this.edge.getEdgeData();
        List<TrackEdgePoint> edgePoints = edgeData.getPoints();
        double length = this.edge.getLength();
        for (int i = 0; i < edgePoints.size(); ++i) {
            double distance;
            int index = forward ? i : edgePoints.size() - i - 1;
            TrackEdgePoint nextBoundary = edgePoints.get(index);
            double locationOn = nextBoundary.getLocationOn(this.edge);
            double d = distance = forward ? locationOn : length - locationOn;
            if (forward ? locationOn < from || locationOn >= to : locationOn <= from || locationOn > to) continue;
            Couple<TrackNode> nodes = Couple.create(this.node1, this.node2);
            if (!edgePointListener.test(totalDistance + distance, Pair.of(nextBoundary, forward ? nodes : nodes.swap()))) continue;
            return locationOn;
        }
        return null;
    }

    public void reverse(TrackGraph graph) {
        TrackNode n = this.node1;
        this.node1 = this.node2;
        this.node2 = n;
        this.position = this.edge.getLength() - this.position;
        this.edge = graph.getConnectionsFrom(this.node1).get(this.node2);
    }

    public Vec3 getPosition() {
        return this.getPositionWithOffset(0.0);
    }

    public Vec3 getPositionWithOffset(double offset) {
        double t = (this.position + offset) / this.edge.getLength();
        return this.edge.getPosition(t).m_82549_(this.edge.getNormal(this.node1, this.node2, t).m_82490_(1.0));
    }

    public void migrateTo(List<GraphLocation> locations) {
        GraphLocation location = locations.remove(0);
        TrackGraph graph = location.graph;
        this.node1 = graph.locateNode((TrackNodeLocation)((Object)location.edge.getFirst()));
        this.node2 = graph.locateNode((TrackNodeLocation)((Object)location.edge.getSecond()));
        this.position = location.position;
        this.edge = graph.getConnectionsFrom(this.node1).get(this.node2);
    }

    public CompoundTag write(DimensionPalette dimensions) {
        CompoundTag tag = new CompoundTag();
        Couple<TrackNode> nodes = Couple.create(this.node1, this.node2);
        if (nodes.either(Objects::isNull)) {
            return tag;
        }
        tag.m_128365_("Nodes", (Tag)nodes.map(TrackNode::getLocation).serializeEach(loc -> loc.write(dimensions)));
        tag.m_128347_("Position", this.position);
        return tag;
    }

    public static TravellingPoint read(CompoundTag tag, TrackGraph graph, DimensionPalette dimensions) {
        Couple<Object> locs;
        if (graph == null) {
            return new TravellingPoint(null, null, null, 0.0);
        }
        Couple<Object> couple = tag.m_128441_("Nodes") ? Couple.deserializeEach(tag.m_128437_("Nodes", 10), c -> TrackNodeLocation.read(c, dimensions)).map(graph::locateNode) : (locs = Couple.create(null, null));
        if (locs.either(Objects::isNull)) {
            return new TravellingPoint(null, null, null, 0.0);
        }
        double position = tag.m_128459_("Position");
        return new TravellingPoint((TrackNode)locs.getFirst(), (TrackNode)locs.getSecond(), graph.getConnectionsFrom((TrackNode)locs.getFirst()).get(locs.getSecond()), position);
    }

    public static interface IEdgePointListener
    extends BiPredicate<Double, Pair<TrackEdgePoint, Couple<TrackNode>>> {
    }

    public static interface ITurnListener
    extends BiConsumer<Double, TrackEdge> {
    }

    public static interface IPortalListener
    extends Predicate<Couple<TrackNodeLocation>> {
    }

    public static interface ITrackSelector
    extends BiFunction<TrackGraph, Pair<Boolean, List<Map.Entry<TrackNode, TrackEdge>>>, Map.Entry<TrackNode, TrackEdge>> {
    }

    public static enum SteerDirection {
        NONE(0.0f),
        LEFT(-1.0f),
        RIGHT(1.0f);

        float targetDot;

        private SteerDirection(float targetDot) {
            this.targetDot = targetDot;
        }
    }
}

