/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.edgePoint.station;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.logistics.trains.entity.Carriage;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.entity.TrainIconType;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.AbstractStationScreen;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.AssemblyScreen;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.GlobalStation;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.NoShadowFontWrapper;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationEditPacket;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationTileEntity;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.TrainEditPacket;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.WideIconButton;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public class StationScreen
extends AbstractStationScreen {
    private EditBox nameBox;
    private EditBox trainNameBox;
    private IconButton newTrainButton;
    private IconButton disassembleTrainButton;
    private IconButton dropScheduleButton;
    private int leavingAnimation;
    private LerpedFloat trainPosition;
    private boolean switchingToAssemblyMode;

    public StationScreen(StationTileEntity te, GlobalStation station) {
        super(te, station);
        this.background = AllGuiTextures.STATION;
        this.leavingAnimation = 0;
        this.trainPosition = LerpedFloat.linear().startWithValue(0.0);
        this.switchingToAssemblyMode = false;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int x = this.guiLeft;
        int y = this.guiTop;
        Consumer<String> onTextChanged = s -> {
            this.nameBox.f_93620_ = this.nameBoxX((String)s, this.nameBox);
        };
        this.nameBox = new EditBox((Font)new NoShadowFontWrapper(this.f_96547_), x + 23, y + 4, this.background.width - 20, 10, (Component)Components.literal(this.station.name));
        this.nameBox.m_94182_(false);
        this.nameBox.m_94199_(25);
        this.nameBox.m_94202_(0x442000);
        this.nameBox.m_94144_(this.station.name);
        this.nameBox.m_5755_(false);
        this.nameBox.m_6375_(0.0, 0.0, 0);
        this.nameBox.m_94151_(onTextChanged);
        this.nameBox.f_93620_ = this.nameBoxX(this.nameBox.m_94155_(), this.nameBox);
        this.m_142416_((GuiEventListener)this.nameBox);
        Runnable assemblyCallback = () -> {
            this.switchingToAssemblyMode = true;
            this.f_96541_.m_91152_((Screen)new AssemblyScreen(this.te, this.station));
        };
        this.newTrainButton = new WideIconButton(x + 84, y + 65, AllGuiTextures.I_NEW_TRAIN);
        this.newTrainButton.withCallback(assemblyCallback);
        this.m_142416_(this.newTrainButton);
        this.disassembleTrainButton = new WideIconButton(x + 94, y + 65, AllGuiTextures.I_DISASSEMBLE_TRAIN);
        this.disassembleTrainButton.f_93623_ = false;
        this.disassembleTrainButton.f_93624_ = false;
        this.disassembleTrainButton.withCallback(assemblyCallback);
        this.m_142416_(this.disassembleTrainButton);
        this.dropScheduleButton = new IconButton(x + 73, y + 65, AllIcons.I_VIEW_SCHEDULE);
        this.dropScheduleButton.f_93623_ = false;
        this.dropScheduleButton.f_93624_ = false;
        this.dropScheduleButton.withCallback(() -> AllPackets.channel.sendToServer((Object)StationEditPacket.dropSchedule(this.te.m_58899_())));
        this.m_142416_(this.dropScheduleButton);
        onTextChanged = s -> {
            this.trainNameBox.f_93620_ = this.nameBoxX((String)s, this.trainNameBox);
        };
        this.trainNameBox = new EditBox(this.f_96547_, x + 23, y + 47, this.background.width - 75, 10, Components.immutableEmpty());
        this.trainNameBox.m_94182_(false);
        this.trainNameBox.m_94199_(35);
        this.trainNameBox.m_94202_(0xC6C6C6);
        this.trainNameBox.m_5755_(false);
        this.trainNameBox.m_6375_(0.0, 0.0, 0);
        this.trainNameBox.m_94151_(onTextChanged);
        this.trainNameBox.f_93623_ = false;
        this.tickTrainDisplay();
    }

    @Override
    public void m_96624_() {
        this.tickTrainDisplay();
        if (this.m_7222_() != this.nameBox) {
            this.nameBox.m_94196_(this.nameBox.m_94155_().length());
            this.nameBox.m_94208_(this.nameBox.m_94207_());
        }
        if (this.m_7222_() != this.trainNameBox || !this.trainNameBox.f_93623_) {
            this.trainNameBox.m_94196_(this.trainNameBox.m_94155_().length());
            this.trainNameBox.m_94208_(this.trainNameBox.m_94207_());
        }
        super.m_96624_();
        this.updateAssemblyTooltip(this.te.edgePoint.isOnCurve() ? "no_assembly_curve" : (!this.te.edgePoint.isOrthogonal() ? "no_assembly_diagonal" : (this.trainPresent() && !this.te.trainCanDisassemble ? "train_not_aligned" : null)));
    }

    private void tickTrainDisplay() {
        Train train = (Train)this.displayedTrain.get();
        if (train == null) {
            if (this.trainNameBox.f_93623_) {
                this.trainNameBox.f_93623_ = false;
                this.m_169411_((GuiEventListener)this.trainNameBox);
            }
            this.leavingAnimation = 0;
            this.newTrainButton.f_93623_ = this.te.edgePoint.isOrthogonal();
            this.newTrainButton.f_93624_ = true;
            Train imminentTrain = this.getImminent();
            if (imminentTrain != null) {
                this.displayedTrain = new WeakReference<Train>(imminentTrain);
                this.newTrainButton.f_93623_ = false;
                this.newTrainButton.f_93624_ = false;
                this.disassembleTrainButton.f_93623_ = false;
                this.disassembleTrainButton.f_93624_ = true;
                this.dropScheduleButton.f_93623_ = this.te.trainHasSchedule;
                this.dropScheduleButton.f_93624_ = true;
                this.trainNameBox.f_93623_ = true;
                this.trainNameBox.m_94144_(imminentTrain.name.getString());
                this.trainNameBox.f_93620_ = this.nameBoxX(this.trainNameBox.m_94155_(), this.trainNameBox);
                this.m_142416_((GuiEventListener)this.trainNameBox);
                int trainIconWidth = this.getTrainIconWidth(imminentTrain);
                int targetPos = this.background.width / 2 - trainIconWidth / 2;
                if (trainIconWidth > 130) {
                    targetPos -= trainIconWidth - 130;
                }
                float f = (float)(imminentTrain.navigation.distanceToDestination / 15.0);
                if (this.trainPresent()) {
                    f = 0.0f;
                }
                this.trainPosition.startWithValue((float)targetPos - (float)(targetPos + 5) * f);
            }
            return;
        }
        int trainIconWidth = this.getTrainIconWidth(train);
        int targetPos = this.background.width / 2 - trainIconWidth / 2;
        if (trainIconWidth > 130) {
            targetPos -= trainIconWidth - 130;
        }
        if (this.leavingAnimation > 0) {
            this.disassembleTrainButton.f_93623_ = false;
            float f = 1.0f - (float)this.leavingAnimation / 80.0f;
            this.trainPosition.setValue((float)targetPos + f * f * f * (float)(this.background.width - targetPos + 5));
            --this.leavingAnimation;
            if (this.leavingAnimation > 0) {
                return;
            }
            this.displayedTrain = new WeakReference<Object>(null);
            this.disassembleTrainButton.f_93624_ = false;
            this.dropScheduleButton.f_93623_ = false;
            this.dropScheduleButton.f_93624_ = false;
            return;
        }
        if (this.getImminent() != train) {
            this.leavingAnimation = 80;
            return;
        }
        boolean trainAtStation = this.trainPresent();
        this.disassembleTrainButton.f_93623_ = trainAtStation && this.te.trainCanDisassemble && this.te.edgePoint.isOrthogonal();
        this.dropScheduleButton.f_93623_ = this.te.trainHasSchedule;
        if (this.te.trainHasSchedule) {
            this.dropScheduleButton.setToolTip((Component)Lang.translateDirect(this.te.trainHasAutoSchedule ? "station.remove_auto_schedule" : "station.remove_schedule", new Object[0]));
        } else {
            this.dropScheduleButton.getToolTip().clear();
        }
        float f = trainAtStation ? 0.0f : (float)(train.navigation.distanceToDestination / 30.0);
        this.trainPosition.setValue((float)targetPos - (float)(targetPos + trainIconWidth) * f);
    }

    private int nameBoxX(String s, EditBox nameBox) {
        return this.guiLeft + this.background.width / 2 - (Math.min(this.f_96547_.m_92895_(s), nameBox.m_5711_()) + 10) / 2;
    }

    private void updateAssemblyTooltip(String key) {
        if (key == null) {
            this.disassembleTrainButton.setToolTip((Component)Lang.translateDirect("station.disassemble_train", new Object[0]));
            this.newTrainButton.setToolTip((Component)Lang.translateDirect("station.create_train", new Object[0]));
            return;
        }
        for (IconButton ib : new IconButton[]{this.disassembleTrainButton, this.newTrainButton}) {
            List<Component> toolTip = ib.getToolTip();
            toolTip.clear();
            toolTip.add((Component)Lang.translateDirect("station." + key, new Object[0]).m_130940_(ChatFormatting.GRAY));
            toolTip.add((Component)Lang.translateDirect("station." + key + "_1", new Object[0]).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    protected void renderWindow(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        Train train;
        super.renderWindow(ms, mouseX, mouseY, partialTicks);
        int x = this.guiLeft;
        int y = this.guiTop;
        String text = this.nameBox.m_94155_();
        if (!this.nameBox.m_93696_()) {
            AllGuiTextures.STATION_EDIT_NAME.render(ms, this.nameBoxX(text, this.nameBox) + this.f_96547_.m_92895_(text) + 5, y + 1);
        }
        if ((train = (Train)this.displayedTrain.get()) == null) {
            MutableComponent header = Lang.translateDirect("station.idle", new Object[0]);
            this.f_96547_.m_92889_(ms, (Component)header, (float)(x + 97 - this.f_96547_.m_92852_((FormattedText)header) / 2), (float)(y + 47), 0x7A7A7A);
            return;
        }
        float position = this.trainPosition.getValue(partialTicks);
        ms.m_85836_();
        RenderSystem.m_69478_();
        ms.m_85837_((double)position, 0.0, 0.0);
        TrainIconType icon = train.icon;
        int offset = 0;
        List<Carriage> carriages = train.carriages;
        for (int i = carriages.size() - 1; i > 0; --i) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, Math.min((position + (float)offset - 10.0f) / 30.0f, ((float)(this.background.width - 40) - position - (float)offset) / 30.0f)));
            Carriage carriage = carriages.get(this.te.trainBackwards ? carriages.size() - i - 1 : i);
            offset += icon.render(carriage.bogeySpacing, ms, x + offset, y + 20) + 1;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, Math.min((position + (float)offset - 10.0f) / 30.0f, ((float)(this.background.width - 40) - position - (float)offset) / 30.0f)));
        offset += icon.render(-1, ms, x + offset, y + 20);
        RenderSystem.m_69461_();
        ms.m_85849_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        UIRenderHelper.drawStretched(ms, x + 21, y + 43, 150, 46, -100, AllGuiTextures.STATION_TEXTBOX_MIDDLE);
        AllGuiTextures.STATION_TEXTBOX_TOP.render(ms, x + 21, y + 42);
        AllGuiTextures.STATION_TEXTBOX_BOTTOM.render(ms, x + 21, y + 86);
        ms.m_85836_();
        ms.m_85837_((double)Mth.m_14036_((float)(position + (float)offset - 13.0f), (float)25.0f, (float)159.0f), 0.0, 0.0);
        AllGuiTextures.STATION_TEXTBOX_SPEECH.render(ms, x, y + 38);
        ms.m_85849_();
        text = this.trainNameBox.m_94155_();
        if (!this.trainNameBox.m_93696_()) {
            int buttonX = this.nameBoxX(text, this.trainNameBox) + this.f_96547_.m_92895_(text) + 5;
            AllGuiTextures.STATION_EDIT_TRAIN_NAME.render(ms, Math.min(buttonX, this.guiLeft + 156), y + 44);
            if (this.f_96547_.m_92895_(text) > this.trainNameBox.m_5711_()) {
                this.f_96547_.m_92750_(ms, "...", (float)(this.guiLeft + 26), (float)(this.guiTop + 47), 0xA6A6A6);
            }
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (!this.nameBox.m_93696_() && pMouseY > (double)this.guiTop && pMouseY < (double)(this.guiTop + 14) && pMouseX > (double)this.guiLeft && pMouseX < (double)(this.guiLeft + this.background.width)) {
            this.nameBox.m_94178_(true);
            this.nameBox.m_94208_(0);
            this.m_7522_((GuiEventListener)this.nameBox);
            return true;
        }
        if (this.trainNameBox.f_93623_ && !this.trainNameBox.m_93696_() && pMouseY > (double)(this.guiTop + 45) && pMouseY < (double)(this.guiTop + 58) && pMouseX > (double)(this.guiLeft + 25) && pMouseX < (double)(this.guiLeft + 168)) {
            this.trainNameBox.m_94178_(true);
            this.trainNameBox.m_94208_(0);
            this.m_7522_((GuiEventListener)this.trainNameBox);
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    @Override
    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        boolean hitEnter;
        boolean bl = hitEnter = this.m_7222_() instanceof EditBox && (pKeyCode == 257 || pKeyCode == 335);
        if (hitEnter && this.nameBox.m_93696_()) {
            this.nameBox.m_94178_(false);
            this.syncStationName();
            return true;
        }
        if (hitEnter && this.trainNameBox.m_93696_()) {
            this.trainNameBox.m_94178_(false);
            this.syncTrainName();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    private void syncTrainName() {
        Train train = (Train)this.displayedTrain.get();
        if (train != null && !this.trainNameBox.m_94155_().equals(train.name.getString())) {
            AllPackets.channel.sendToServer((Object)new TrainEditPacket(train.id, this.trainNameBox.m_94155_(), train.icon.getId()));
        }
    }

    private void syncStationName() {
        if (!this.nameBox.m_94155_().equals(this.station.name)) {
            AllPackets.channel.sendToServer((Object)StationEditPacket.configure(this.te.m_58899_(), false, this.nameBox.m_94155_()));
        }
    }

    public void m_7861_() {
        super.m_7861_();
        AllPackets.channel.sendToServer((Object)StationEditPacket.configure(this.te.m_58899_(), this.switchingToAssemblyMode, this.nameBox.m_94155_()));
        Train train = (Train)this.displayedTrain.get();
        if (train == null) {
            return;
        }
        if (!this.switchingToAssemblyMode) {
            AllPackets.channel.sendToServer((Object)new TrainEditPacket(train.id, this.trainNameBox.m_94155_(), train.icon.getId()));
        } else {
            this.te.imminentTrain = null;
        }
    }

    @Override
    protected PartialModel getFlag(float partialTicks) {
        return this.te.flag.getValue(partialTicks) > 0.75f ? AllBlockPartials.STATION_ON : AllBlockPartials.STATION_OFF;
    }
}

