/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.processing.EmptyingByBasin;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.content.logistics.trains.entity.Carriage;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.management.schedule.condition.CargoThresholdCondition;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidThresholdCondition
extends CargoThresholdCondition {
    public ItemStack compareStack = ItemStack.f_41583_;
    public FluidStack fluidStack = null;

    @Override
    protected Component getUnit() {
        return Components.literal("b");
    }

    @Override
    protected ItemStack getIcon() {
        return this.compareStack;
    }

    @Override
    protected boolean test(Level level, Train train, CompoundTag context) {
        CargoThresholdCondition.Ops operator = this.getOperator();
        int target = this.getThreshold();
        int foundFluid = 0;
        for (Carriage carriage : train.carriages) {
            IFluidHandler fluids = carriage.storage.getFluids();
            for (int i = 0; i < fluids.getTanks(); ++i) {
                FluidStack fluidInTank = fluids.getFluidInTank(i);
                if (!FilterItem.test(level, fluidInTank, this.compareStack)) continue;
                foundFluid += fluidInTank.getAmount();
            }
        }
        this.requestStatusToUpdate(foundFluid / 1000, context);
        return operator.test(foundFluid, target * 1000);
    }

    @Override
    protected void writeAdditional(CompoundTag tag) {
        super.writeAdditional(tag);
        tag.m_128365_("Bucket", (Tag)this.compareStack.serializeNBT());
    }

    @Override
    protected void readAdditional(CompoundTag tag) {
        super.readAdditional(tag);
        this.compareStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Bucket"));
    }

    @Override
    public boolean tickCompletion(Level level, Train train, CompoundTag context) {
        return super.tickCompletion(level, train, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    private FluidStack loadFluid() {
        if (this.fluidStack != null) {
            return this.fluidStack;
        }
        this.fluidStack = FluidStack.EMPTY;
        if (!EmptyingByBasin.canItemBeEmptied((Level)Minecraft.m_91087_().f_91073_, this.compareStack)) {
            return this.fluidStack;
        }
        FluidStack fluidInFilter = EmptyingByBasin.emptyItem((Level)Minecraft.m_91087_().f_91073_, this.compareStack, true).getFirst();
        if (fluidInFilter == null) {
            return this.fluidStack;
        }
        this.fluidStack = fluidInFilter;
        return this.fluidStack;
    }

    @Override
    public List<Component> getTitleAs(String type) {
        return ImmutableList.of((Object)Lang.translateDirect("schedule.condition.threshold.train_holds", Lang.translateDirect("schedule.condition.threshold." + Lang.asId(this.getOperator().name()), new Object[0])), (Object)Lang.translateDirect("schedule.condition.threshold.x_units_of_item", this.getThreshold(), Lang.translateDirect("schedule.condition.threshold.buckets", new Object[0]), this.compareStack.m_41619_() ? Lang.translateDirect("schedule.condition.threshold.anything", new Object[0]) : (this.compareStack.m_41720_() instanceof FilterItem ? Lang.translateDirect("schedule.condition.threshold.matching_content", new Object[0]) : this.loadFluid().getDisplayName())).m_130940_(ChatFormatting.DARK_AQUA));
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        this.compareStack = stack;
    }

    @Override
    public ItemStack getItem(int slot) {
        return this.compareStack;
    }

    @Override
    public ResourceLocation getId() {
        return Create.asResource("fluid_threshold");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        super.initConfigurationWidgets(builder);
        builder.addSelectionScrollInput(71, 50, (i, l) -> i.forOptions((List<? extends Component>)ImmutableList.of((Object)Lang.translateDirect("schedule.condition.threshold.buckets", new Object[0]))).titled(null), "Measure");
    }

    @Override
    public MutableComponent getWaitingStatus(Level level, Train train, CompoundTag tag) {
        int lastDisplaySnapshot = this.getLastDisplaySnapshot(tag);
        if (lastDisplaySnapshot == -1) {
            return Components.empty();
        }
        int offset = this.getOperator() == CargoThresholdCondition.Ops.LESS ? -1 : (this.getOperator() == CargoThresholdCondition.Ops.GREATER ? 1 : 0);
        return Lang.translateDirect("schedule.condition.threshold.status", lastDisplaySnapshot, Math.max(0, this.getThreshold() + offset), Lang.translateDirect("schedule.condition.threshold.buckets", new Object[0]));
    }
}

