/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.simibubi.create.content.schematics.ISpecialBlockEntityItemRequirement;
import com.simibubi.create.content.schematics.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.ISpecialEntityItemRequirement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class ItemRequirement {
    public static final ItemRequirement NONE = new ItemRequirement(Collections.emptyList());
    public static final ItemRequirement INVALID = new ItemRequirement(Collections.emptyList());
    protected List<StackRequirement> requiredItems;

    public ItemRequirement(List<StackRequirement> requiredItems) {
        this.requiredItems = requiredItems;
    }

    public ItemRequirement(StackRequirement stackRequirement) {
        this(List.of(stackRequirement));
    }

    public ItemRequirement(ItemUseType usage, ItemStack stack) {
        this(new StackRequirement(stack, usage));
    }

    public ItemRequirement(ItemUseType usage, Item item) {
        this(usage, new ItemStack((ItemLike)item));
    }

    public ItemRequirement(ItemUseType usage, List<ItemStack> requiredItems) {
        this(requiredItems.stream().map(req -> new StackRequirement((ItemStack)req, usage)).collect(Collectors.toList()));
    }

    public static ItemRequirement of(BlockState state, BlockEntity te) {
        ItemRequirement requirement;
        Block block = state.m_60734_();
        if (block instanceof ISpecialBlockItemRequirement) {
            ISpecialBlockItemRequirement specialBlock = (ISpecialBlockItemRequirement)block;
            requirement = specialBlock.getRequiredItems(state, te);
        } else {
            requirement = ItemRequirement.defaultOf(state, te);
        }
        if (te instanceof ISpecialBlockEntityItemRequirement) {
            ISpecialBlockEntityItemRequirement specialBE = (ISpecialBlockEntityItemRequirement)te;
            requirement = requirement.union(specialBE.getRequiredItems(state));
        }
        return requirement;
    }

    private static ItemRequirement defaultOf(BlockState state, BlockEntity te) {
        Block block = state.m_60734_();
        if (block == Blocks.f_50016_) {
            return NONE;
        }
        Item item = block.m_5456_();
        if (item == Items.f_41852_) {
            return INVALID;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61397_) && state.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.DOUBLE) {
            return new ItemRequirement(ItemUseType.CONSUME, new ItemStack((ItemLike)item, 2));
        }
        if (block instanceof TurtleEggBlock) {
            return new ItemRequirement(ItemUseType.CONSUME, new ItemStack((ItemLike)item, ((Integer)state.m_61143_((Property)TurtleEggBlock.f_57754_)).intValue()));
        }
        if (block instanceof SeaPickleBlock) {
            return new ItemRequirement(ItemUseType.CONSUME, new ItemStack((ItemLike)item, ((Integer)state.m_61143_((Property)SeaPickleBlock.f_56074_)).intValue()));
        }
        if (block instanceof SnowLayerBlock) {
            return new ItemRequirement(ItemUseType.CONSUME, new ItemStack((ItemLike)item, ((Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_)).intValue()));
        }
        if (block instanceof FarmBlock || block instanceof DirtPathBlock) {
            return new ItemRequirement(ItemUseType.CONSUME, Items.f_42329_);
        }
        if (block instanceof AbstractBannerBlock && te instanceof BannerBlockEntity) {
            BannerBlockEntity bannerBE = (BannerBlockEntity)te;
            return new ItemRequirement(new StrictNbtStackRequirement(bannerBE.m_155043_(), ItemUseType.CONSUME));
        }
        return new ItemRequirement(ItemUseType.CONSUME, item);
    }

    public static ItemRequirement of(Entity entity) {
        if (entity instanceof ISpecialEntityItemRequirement) {
            ISpecialEntityItemRequirement specialEntity = (ISpecialEntityItemRequirement)entity;
            return specialEntity.getRequiredItems();
        }
        if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            ItemStack frame = new ItemStack((ItemLike)Items.f_42617_);
            ItemStack displayedItem = itemFrame.m_31822_();
            if (displayedItem.m_41619_()) {
                return new ItemRequirement(ItemUseType.CONSUME, Items.f_42617_);
            }
            return new ItemRequirement(ItemUseType.CONSUME, Arrays.asList(frame, displayedItem));
        }
        if (entity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            ArrayList<ItemStack> requirements = new ArrayList<ItemStack>();
            requirements.add(new ItemStack((ItemLike)Items.f_42650_));
            armorStand.m_20158_().forEach(requirements::add);
            return new ItemRequirement(ItemUseType.CONSUME, requirements);
        }
        ItemStack pickedStack = entity.m_142340_();
        if (pickedStack != null) {
            return new ItemRequirement(ItemUseType.CONSUME, pickedStack);
        }
        return INVALID;
    }

    public boolean isEmpty() {
        return NONE == this;
    }

    public boolean isInvalid() {
        return INVALID == this;
    }

    public List<StackRequirement> getRequiredItems() {
        return this.requiredItems;
    }

    public ItemRequirement union(ItemRequirement other) {
        if (this.isInvalid() || other.isInvalid()) {
            return INVALID;
        }
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        return new ItemRequirement(Stream.concat(this.requiredItems.stream(), other.requiredItems.stream()).collect(Collectors.toList()));
    }

    public static class StackRequirement {
        public final ItemStack stack;
        public final ItemUseType usage;

        public StackRequirement(ItemStack stack, ItemUseType usage) {
            this.stack = stack;
            this.usage = usage;
        }

        public boolean matches(ItemStack other) {
            return this.stack.m_41656_(other);
        }
    }

    public static enum ItemUseType {
        CONSUME,
        DAMAGE;

    }

    public static class StrictNbtStackRequirement
    extends StackRequirement {
        public StrictNbtStackRequirement(ItemStack stack, ItemUseType usage) {
            super(stack, usage);
        }

        @Override
        public boolean matches(ItemStack other) {
            return ItemStack.m_150942_((ItemStack)this.stack, (ItemStack)other);
        }
    }
}

