/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.block;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.block.inventories.CreativeCrateBlock;
import com.simibubi.create.content.schematics.block.SchematicannonContainer;
import com.simibubi.create.content.schematics.block.SchematicannonTileEntity;
import com.simibubi.create.content.schematics.packet.ConfigureSchematicannonPacket;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.container.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Indicator;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class SchematicannonScreen
extends AbstractSimiContainerScreen<SchematicannonContainer> {
    private static final AllGuiTextures BG_BOTTOM = AllGuiTextures.SCHEMATICANNON_BOTTOM;
    private static final AllGuiTextures BG_TOP = AllGuiTextures.SCHEMATICANNON_TOP;
    private final Component listPrinter = Lang.translateDirect("gui.schematicannon.listPrinter", new Object[0]);
    private final String _gunpowderLevel = "gui.schematicannon.gunpowderLevel";
    private final String _shotsRemaining = "gui.schematicannon.shotsRemaining";
    private final String _showSettings = "gui.schematicannon.showOptions";
    private final String _shotsRemainingWithBackup = "gui.schematicannon.shotsRemainingWithBackup";
    private final String _slotGunpowder = "gui.schematicannon.slot.gunpowder";
    private final String _slotListPrinter = "gui.schematicannon.slot.listPrinter";
    private final String _slotSchematic = "gui.schematicannon.slot.schematic";
    private final Component optionEnabled = Lang.translateDirect("gui.schematicannon.optionEnabled", new Object[0]);
    private final Component optionDisabled = Lang.translateDirect("gui.schematicannon.optionDisabled", new Object[0]);
    protected Vector<Indicator> replaceLevelIndicators;
    protected Vector<IconButton> replaceLevelButtons;
    protected IconButton skipMissingButton;
    protected Indicator skipMissingIndicator;
    protected IconButton skipTilesButton;
    protected Indicator skipTilesIndicator;
    protected IconButton playButton;
    protected Indicator playIndicator;
    protected IconButton pauseButton;
    protected Indicator pauseIndicator;
    protected IconButton resetButton;
    protected Indicator resetIndicator;
    private IconButton confirmButton;
    private IconButton showSettingsButton;
    private Indicator showSettingsIndicator;
    protected List<AbstractWidget> placementSettingWidgets;
    private final ItemStack renderedItem = AllBlocks.SCHEMATICANNON.asStack();
    private List<Rect2i> extraAreas = Collections.emptyList();

    public SchematicannonScreen(SchematicannonContainer container, Inventory inventory, Component title) {
        super(container, inventory, title);
        this.placementSettingWidgets = new ArrayList<AbstractWidget>();
    }

    @Override
    protected void m_7856_() {
        this.setWindowSize(SchematicannonScreen.BG_TOP.width, SchematicannonScreen.BG_TOP.height + SchematicannonScreen.BG_BOTTOM.height + 2 + AllGuiTextures.PLAYER_INVENTORY.height);
        this.setWindowOffset(-11, 0);
        super.m_7856_();
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.playButton = new IconButton(x + 75, y + 86, AllIcons.I_PLAY);
        this.playButton.withCallback(() -> this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.PLAY, true));
        this.playIndicator = new Indicator(x + 75, y + 79, Components.immutableEmpty());
        this.pauseButton = new IconButton(x + 93, y + 86, AllIcons.I_PAUSE);
        this.pauseButton.withCallback(() -> this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.PAUSE, true));
        this.pauseIndicator = new Indicator(x + 93, y + 79, Components.immutableEmpty());
        this.resetButton = new IconButton(x + 111, y + 86, AllIcons.I_STOP);
        this.resetButton.withCallback(() -> this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.STOP, true));
        this.resetIndicator = new Indicator(x + 111, y + 79, Components.immutableEmpty());
        this.resetIndicator.state = Indicator.State.RED;
        this.addRenderableWidgets(new AbstractSimiWidget[]{this.playButton, this.playIndicator, this.pauseButton, this.pauseIndicator, this.resetButton, this.resetIndicator});
        this.confirmButton = new IconButton(x + 180, y + 117, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.f_96541_.f_91074_.m_6915_());
        this.m_142416_(this.confirmButton);
        this.showSettingsButton = new IconButton(x + 9, y + 117, AllIcons.I_PLACEMENT_SETTINGS);
        this.showSettingsButton.withCallback(() -> {
            this.showSettingsIndicator.state = this.placementSettingsHidden() ? Indicator.State.GREEN : Indicator.State.OFF;
            this.initPlacementSettings();
        });
        this.showSettingsButton.setToolTip((Component)Lang.translateDirect("gui.schematicannon.showOptions", new Object[0]));
        this.m_142416_(this.showSettingsButton);
        this.showSettingsIndicator = new Indicator(x + 9, y + 111, Components.immutableEmpty());
        this.m_142416_(this.showSettingsIndicator);
        this.extraAreas = ImmutableList.of((Object)new Rect2i(x + SchematicannonScreen.BG_TOP.width, y + SchematicannonScreen.BG_TOP.height + SchematicannonScreen.BG_BOTTOM.height - 62, 84, 92));
        this.m_96624_();
    }

    private void initPlacementSettings() {
        this.removeWidgets(this.placementSettingWidgets);
        this.placementSettingWidgets.clear();
        if (this.placementSettingsHidden()) {
            return;
        }
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.replaceLevelButtons = new Vector(4);
        this.replaceLevelIndicators = new Vector(4);
        ImmutableList icons = ImmutableList.of((Object)AllIcons.I_DONT_REPLACE, (Object)AllIcons.I_REPLACE_SOLID, (Object)AllIcons.I_REPLACE_ANY, (Object)AllIcons.I_REPLACE_EMPTY);
        ImmutableList toolTips = ImmutableList.of((Object)Lang.translateDirect("gui.schematicannon.option.dontReplaceSolid", new Object[0]), (Object)Lang.translateDirect("gui.schematicannon.option.replaceWithSolid", new Object[0]), (Object)Lang.translateDirect("gui.schematicannon.option.replaceWithAny", new Object[0]), (Object)Lang.translateDirect("gui.schematicannon.option.replaceWithEmpty", new Object[0]));
        for (int i = 0; i < 4; ++i) {
            this.replaceLevelIndicators.add(new Indicator(x + 33 + i * 18, y + 111, Components.immutableEmpty()));
            IconButton replaceLevelButton = new IconButton(x + 33 + i * 18, y + 117, (ScreenElement)icons.get(i));
            int replaceMode = i;
            replaceLevelButton.withCallback(() -> {
                if (((SchematicannonTileEntity)((SchematicannonContainer)this.f_97732_).contentHolder).replaceMode != replaceMode) {
                    this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.values()[replaceMode], true);
                }
            });
            replaceLevelButton.setToolTip((Component)toolTips.get(i));
            this.replaceLevelButtons.add(replaceLevelButton);
        }
        this.placementSettingWidgets.addAll(this.replaceLevelButtons);
        this.placementSettingWidgets.addAll(this.replaceLevelIndicators);
        this.skipMissingButton = new IconButton(x + 111, y + 117, AllIcons.I_SKIP_MISSING);
        this.skipMissingButton.withCallback(() -> this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.SKIP_MISSING, !((SchematicannonTileEntity)((SchematicannonContainer)this.f_97732_).contentHolder).skipMissing));
        this.skipMissingButton.setToolTip((Component)Lang.translateDirect("gui.schematicannon.option.skipMissing", new Object[0]));
        this.skipMissingIndicator = new Indicator(x + 111, y + 111, Components.immutableEmpty());
        Collections.addAll(this.placementSettingWidgets, this.skipMissingButton, this.skipMissingIndicator);
        this.skipTilesButton = new IconButton(x + 129, y + 117, AllIcons.I_SKIP_TILES);
        this.skipTilesButton.withCallback(() -> this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.SKIP_TILES, !((SchematicannonTileEntity)((SchematicannonContainer)this.f_97732_).contentHolder).replaceTileEntities));
        this.skipTilesButton.setToolTip((Component)Lang.translateDirect("gui.schematicannon.option.skipTileEntities", new Object[0]));
        this.skipTilesIndicator = new Indicator(x + 129, y + 111, Components.immutableEmpty());
        Collections.addAll(this.placementSettingWidgets, this.skipTilesButton, this.skipTilesIndicator);
        this.addRenderableWidgets(this.placementSettingWidgets);
    }

    protected boolean placementSettingsHidden() {
        return this.showSettingsIndicator.state == Indicator.State.OFF;
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        SchematicannonTileEntity te = (SchematicannonTileEntity)((SchematicannonContainer)this.f_97732_).contentHolder;
        if (!this.placementSettingsHidden()) {
            for (int replaceMode = 0; replaceMode < this.replaceLevelButtons.size(); ++replaceMode) {
                this.replaceLevelButtons.get((int)replaceMode).f_93623_ = replaceMode != te.replaceMode;
                this.replaceLevelIndicators.get((int)replaceMode).state = replaceMode == te.replaceMode ? Indicator.State.ON : Indicator.State.OFF;
            }
            this.skipMissingIndicator.state = te.skipMissing ? Indicator.State.ON : Indicator.State.OFF;
            this.skipTilesIndicator.state = !te.replaceTileEntities ? Indicator.State.ON : Indicator.State.OFF;
        }
        this.playIndicator.state = Indicator.State.OFF;
        this.pauseIndicator.state = Indicator.State.OFF;
        this.resetIndicator.state = Indicator.State.OFF;
        switch (te.state) {
            case PAUSED: {
                this.pauseIndicator.state = Indicator.State.YELLOW;
                this.playButton.f_93623_ = true;
                this.pauseButton.f_93623_ = false;
                this.resetButton.f_93623_ = true;
                break;
            }
            case RUNNING: {
                this.playIndicator.state = Indicator.State.GREEN;
                this.playButton.f_93623_ = false;
                this.pauseButton.f_93623_ = true;
                this.resetButton.f_93623_ = true;
                break;
            }
            case STOPPED: {
                this.resetIndicator.state = Indicator.State.RED;
                this.playButton.f_93623_ = true;
                this.pauseButton.f_93623_ = false;
                this.resetButton.f_93623_ = false;
                break;
            }
        }
        this.handleTooltips();
    }

    protected void handleTooltips() {
        if (this.placementSettingsHidden()) {
            return;
        }
        for (AbstractWidget w : this.placementSettingWidgets) {
            IconButton button;
            if (!(w instanceof IconButton) || (button = (IconButton)w).getToolTip().isEmpty()) continue;
            button.setToolTip(button.getToolTip().get(0));
            button.getToolTip().add((Component)TooltipHelper.holdShift(ItemDescription.Palette.Blue, SchematicannonScreen.m_96638_()));
        }
        if (SchematicannonScreen.m_96638_()) {
            this.fillToolTip(this.skipMissingButton, this.skipMissingIndicator, "skipMissing");
            this.fillToolTip(this.skipTilesButton, this.skipTilesIndicator, "skipTileEntities");
            this.fillToolTip(this.replaceLevelButtons.get(0), this.replaceLevelIndicators.get(0), "dontReplaceSolid");
            this.fillToolTip(this.replaceLevelButtons.get(1), this.replaceLevelIndicators.get(1), "replaceWithSolid");
            this.fillToolTip(this.replaceLevelButtons.get(2), this.replaceLevelIndicators.get(2), "replaceWithAny");
            this.fillToolTip(this.replaceLevelButtons.get(3), this.replaceLevelIndicators.get(3), "replaceWithEmpty");
        }
    }

    private void fillToolTip(IconButton button, Indicator indicator, String tooltipKey) {
        if (!button.m_198029_()) {
            return;
        }
        boolean enabled = indicator.state == Indicator.State.ON;
        List<Component> tip = button.getToolTip();
        tip.add((Component)(enabled ? this.optionEnabled : this.optionDisabled).m_6879_().m_130940_(ChatFormatting.BLUE));
        tip.addAll(TooltipHelper.cutTextComponent((Component)Lang.translateDirect("gui.schematicannon.option." + tooltipKey + ".description", new Object[0]), ChatFormatting.GRAY, ChatFormatting.GRAY));
    }

    protected void m_7286_(PoseStack ms, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.width);
        int invY = this.f_97736_ + SchematicannonScreen.BG_TOP.height + SchematicannonScreen.BG_BOTTOM.height + 2;
        this.renderPlayerInventory(ms, invX, invY);
        int x = this.f_97735_;
        int y = this.f_97736_;
        BG_TOP.render(ms, x, y, (GuiComponent)this);
        BG_BOTTOM.render(ms, x, y + SchematicannonScreen.BG_TOP.height, (GuiComponent)this);
        SchematicannonTileEntity te = (SchematicannonTileEntity)((SchematicannonContainer)this.f_97732_).contentHolder;
        this.renderPrintingProgress(ms, x, y, te.schematicProgress);
        this.renderFuelBar(ms, x, y, te.fuelLevel);
        this.renderChecklistPrinterProgress(ms, x, y, te.bookPrintingProgress);
        if (!te.inventory.getStackInSlot(0).m_41619_()) {
            this.renderBlueprintHighlight(ms, x, y);
        }
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of(this.renderedItem).at(x + SchematicannonScreen.BG_TOP.width, y + SchematicannonScreen.BG_TOP.height + SchematicannonScreen.BG_BOTTOM.height - 48, -200.0f)).scale(5.0).render(ms);
        SchematicannonScreen.m_93215_((PoseStack)ms, (Font)this.f_96547_, (Component)this.f_96539_, (int)(x + (SchematicannonScreen.BG_TOP.width - 8) / 2), (int)(y + 3), (int)0xFFFFFF);
        MutableComponent msg = Lang.translateDirect("schematicannon.status." + te.statusMsg, new Object[0]);
        int stringWidth = this.f_96547_.m_92852_((FormattedText)msg);
        if (te.missingItem != null) {
            stringWidth += 16;
            ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of(te.missingItem).at(x + 128, y + 49, 100.0f)).scale(1.0).render(ms);
        }
        this.f_96547_.m_92763_(ms, (Component)msg, (float)(x + 103 - stringWidth / 2), (float)(y + 53), 0xCCDDFF);
        if ("schematicErrored".equals(te.statusMsg)) {
            this.f_96547_.m_92763_(ms, (Component)Lang.translateDirect("schematicannon.status.schematicErroredCheckLogs", new Object[0]), (float)(x + 103 - stringWidth / 2), (float)(y + 65), 0xCCDDFF);
        }
    }

    protected void renderBlueprintHighlight(PoseStack matrixStack, int x, int y) {
        AllGuiTextures.SCHEMATICANNON_HIGHLIGHT.render(matrixStack, x + 10, y + 60, (GuiComponent)this);
    }

    protected void renderPrintingProgress(PoseStack matrixStack, int x, int y, float progress) {
        progress = Math.min(progress, 1.0f);
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_PROGRESS;
        sprite.bind();
        this.m_93228_(matrixStack, x + 44, y + 64, sprite.startX, sprite.startY, (int)((float)sprite.width * progress), sprite.height);
    }

    protected void renderChecklistPrinterProgress(PoseStack matrixStack, int x, int y, float progress) {
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_CHECKLIST_PROGRESS;
        sprite.bind();
        this.m_93228_(matrixStack, x + 154, y + 20, sprite.startX, sprite.startY, (int)((float)sprite.width * progress), sprite.height);
    }

    protected void renderFuelBar(PoseStack matrixStack, int x, int y, float amount) {
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_FUEL;
        if (((SchematicannonTileEntity)((SchematicannonContainer)this.f_97732_).contentHolder).hasCreativeCrate) {
            AllGuiTextures.SCHEMATICANNON_FUEL_CREATIVE.render(matrixStack, x + 36, y + 19, (GuiComponent)this);
            return;
        }
        sprite.bind();
        this.m_93228_(matrixStack, x + 36, y + 19, sprite.startX, sprite.startY, (int)((float)sprite.width * amount), sprite.height);
    }

    @Override
    protected void renderForeground(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        SchematicannonTileEntity te = (SchematicannonTileEntity)((SchematicannonContainer)this.f_97732_).contentHolder;
        int x = this.f_97735_;
        int y = this.f_97736_;
        int fuelX = x + 36;
        int fuelY = y + 19;
        if (mouseX >= fuelX && mouseY >= fuelY && mouseX <= fuelX + AllGuiTextures.SCHEMATICANNON_FUEL.width && mouseY <= fuelY + AllGuiTextures.SCHEMATICANNON_FUEL.height) {
            List<Component> tooltip = this.getFuelLevelTooltip(te);
            this.m_96597_(matrixStack, tooltip, mouseX, mouseY);
        }
        if (this.f_97734_ != null && !this.f_97734_.m_6657_()) {
            if (this.f_97734_.f_40219_ == 0) {
                this.m_96597_(matrixStack, TooltipHelper.cutTextComponent((Component)Lang.translateDirect("gui.schematicannon.slot.schematic", new Object[0]), ChatFormatting.GRAY, ChatFormatting.BLUE), mouseX, mouseY);
            }
            if (this.f_97734_.f_40219_ == 2) {
                this.m_96597_(matrixStack, TooltipHelper.cutTextComponent((Component)Lang.translateDirect("gui.schematicannon.slot.listPrinter", new Object[0]), ChatFormatting.GRAY, ChatFormatting.BLUE), mouseX, mouseY);
            }
            if (this.f_97734_.f_40219_ == 4) {
                this.m_96597_(matrixStack, TooltipHelper.cutTextComponent((Component)Lang.translateDirect("gui.schematicannon.slot.gunpowder", new Object[0]), ChatFormatting.GRAY, ChatFormatting.BLUE), mouseX, mouseY);
            }
        }
        if (te.missingItem != null) {
            int missingBlockX = x + 128;
            int missingBlockY = y + 49;
            if (mouseX >= missingBlockX && mouseY >= missingBlockY && mouseX <= missingBlockX + 16 && mouseY <= missingBlockY + 16) {
                this.m_6057_(matrixStack, te.missingItem, mouseX, mouseY);
            }
        }
        int paperX = x + 112;
        int paperY = y + 19;
        if (mouseX >= paperX && mouseY >= paperY && mouseX <= paperX + 16 && mouseY <= paperY + 16) {
            this.m_96602_(matrixStack, this.listPrinter, mouseX, mouseY);
        }
        super.renderForeground(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected List<Component> getFuelLevelTooltip(SchematicannonTileEntity te) {
        double fuelUsageRate = te.getFuelUsageRate();
        int shotsLeft = (int)((double)te.fuelLevel / fuelUsageRate);
        int shotsLeftWithItems = (int)((double)shotsLeft + (double)te.inventory.getStackInSlot(4).m_41613_() * (te.getFuelAddedByGunPowder() / fuelUsageRate));
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (te.hasCreativeCrate) {
            tooltip.add((Component)Lang.translateDirect("gui.schematicannon.gunpowderLevel", "100"));
            tooltip.add((Component)Components.literal("(").m_7220_((Component)((CreativeCrateBlock)AllBlocks.CREATIVE_CRATE.get()).m_49954_()).m_130946_(")").m_130940_(ChatFormatting.DARK_PURPLE));
            return tooltip;
        }
        int fillPercent = (int)(te.fuelLevel * 100.0f);
        tooltip.add((Component)Lang.translateDirect("gui.schematicannon.gunpowderLevel", fillPercent));
        tooltip.add((Component)Lang.translateDirect("gui.schematicannon.shotsRemaining", Components.literal(Integer.toString(shotsLeft)).m_130940_(ChatFormatting.BLUE)).m_130940_(ChatFormatting.GRAY));
        if (shotsLeftWithItems != shotsLeft) {
            tooltip.add((Component)Lang.translateDirect("gui.schematicannon.shotsRemainingWithBackup", Components.literal(Integer.toString(shotsLeftWithItems)).m_130940_(ChatFormatting.BLUE)).m_130940_(ChatFormatting.GRAY));
        }
        return tooltip;
    }

    protected void sendOptionUpdate(ConfigureSchematicannonPacket.Option option, boolean set) {
        AllPackets.channel.sendToServer((Object)new ConfigureSchematicannonPacket(option, set));
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

