/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block.render;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class CustomBlockModels {
    private final Multimap<ResourceLocation, NonNullFunction<BakedModel, ? extends BakedModel>> modelFuncs = MultimapBuilder.hashKeys().arrayListValues().build();
    private final Map<Block, NonNullFunction<BakedModel, ? extends BakedModel>> finalModelFunc = new IdentityHashMap<Block, NonNullFunction<BakedModel, ? extends BakedModel>>();

    public void register(ResourceLocation block, NonNullFunction<BakedModel, ? extends BakedModel> func) {
        this.modelFuncs.put((Object)block, func);
    }

    public void forEach(NonNullBiConsumer<Block, NonNullFunction<BakedModel, ? extends BakedModel>> consumer) {
        this.loadEntriesIfMissing();
        this.finalModelFunc.forEach((BiConsumer<Block, NonNullFunction<BakedModel, ? extends BakedModel>>)consumer);
    }

    private void loadEntriesIfMissing() {
        if (this.finalModelFunc.isEmpty()) {
            this.loadEntries();
        }
    }

    private void loadEntries() {
        this.finalModelFunc.clear();
        this.modelFuncs.asMap().forEach((? super K location, ? super V funcList) -> {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
            if (block == null) {
                return;
            }
            NonNullFunction finalFunc = null;
            for (NonNullFunction func : funcList) {
                if (finalFunc == null) {
                    finalFunc = func;
                    continue;
                }
                finalFunc = finalFunc.andThen(func);
            }
            this.finalModelFunc.put(block, finalFunc);
        });
    }
}

