/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.ScreenBase;
import xaero.common.gui.dropdown.DropDownWidget;
import xaero.common.minimap.info.InfoDisplay;
import xaero.common.minimap.info.InfoDisplayManager;
import xaero.common.settings.ModSettings;

public class GuiInfoDisplayEdit
extends ScreenBase {
    private static final int FRAME_TOP_SIZE = 30;
    private static final int FRAME_BOTTOM_SIZE = 61;
    private static final int SELECTION_ITEM_HEIGHT = 24;
    private static final Component HELP_COMPONENT = new TranslatableComponent("gui.xaero_minimap_info_display_manager_help");
    private SelectionList selectionList;
    private final InfoDisplayManager manager;
    private List<String> currentOrder;
    private int selected;
    private int subSelected;
    private final Map<String, MoveableEntry> moveableEntries;

    protected GuiInfoDisplayEdit(IXaeroMinimap modMain, Screen parent, Screen escape) {
        super(modMain, parent, escape, (Component)new TranslatableComponent("gui.xaero_minimap_info_display_manager"));
        this.manager = modMain.getInterfaces().getMinimapInterface().getInfoDisplayManager();
        this.currentOrder = new ArrayList<String>();
        this.manager.getStream().forEach(info -> this.currentOrder.add(info.getId()));
        this.moveableEntries = new HashMap<String, MoveableEntry>();
        this.selected = -1;
        this.subSelected = -1;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.selectionList = new SelectionList();
        this.m_7787_(this.selectionList);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ - 34, 200, 20, (Component)new TranslatableComponent("gui.done", new Object[0]), b -> this.goBack()));
        this.moveableEntries.clear();
        for (String id : this.currentOrder) {
            InfoDisplay<?> infoDisplay = this.manager.get(id);
            MoveableEntry moveable = new MoveableEntry();
            this.addSubElements(moveable, infoDisplay);
            this.moveableEntries.put(id, moveable);
        }
    }

    public String[] createColorOptions(String symbol, boolean noneOption) {
        String[] options = new String[ModSettings.ENCHANT_COLOR_NAMES.length + (noneOption ? 1 : 0)];
        if (noneOption) {
            options[0] = "\u25a1\u25a1";
        }
        for (int i = 0; i < ModSettings.ENCHANT_COLOR_NAMES.length; ++i) {
            options[i + (noneOption ? 1 : 0)] = "\u00a7" + ModSettings.ENCHANT_COLORS[i] + symbol;
        }
        return options;
    }

    private <T> void addSubElements(MoveableEntry moveable, InfoDisplay<T> infoDisplay) {
        AbstractWidget stateWidget = infoDisplay.getWidgetFactory().create(this.f_96543_ / 2 + 150 - 102, 0, 100, 20, infoDisplay, this.modMain.getSettings());
        if (stateWidget != null) {
            moveable.addSubElement(stateWidget);
        }
        DropDownWidget textColorWidget = DropDownWidget.Builder.begin().setOptions(this.createColorOptions("Aa", false)).setX(this.f_96543_ / 2 - 147).setW(20).setSelected(infoDisplay.getTextColor() % ModSettings.ENCHANT_COLOR_NAMES.length).setContainer(this).setCallback((menu, index) -> {
            infoDisplay.setTextColor(index);
            try {
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }).setNarrationTitle((Component)new TranslatableComponent("gui.xaero_dropdown_info_display_text_color")).build();
        moveable.addSubElement(textColorWidget);
        int currentBackgroundIndex = infoDisplay.getBackgroundColor();
        DropDownWidget backgroundColorWidget = DropDownWidget.Builder.begin().setOptions(this.createColorOptions("\u25a0\u25a0", true)).setX(this.f_96543_ / 2 - 124).setW(20).setSelected(currentBackgroundIndex < 0 ? 0 : currentBackgroundIndex % ModSettings.ENCHANT_COLOR_NAMES.length + 1).setContainer(this).setCallback((menu, index) -> {
            infoDisplay.setBackgroundColor(index - 1);
            try {
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }).setNarrationTitle((Component)new TranslatableComponent("gui.xaero_dropdown_info_display_background_color")).build();
        moveable.addSubElement(backgroundColorWidget);
    }

    @Override
    public boolean m_6348_(double d, double e, int i) {
        if (this.selectionList != null) {
            this.selectionList.releaseDrag();
        }
        return super.m_6348_(d, e, i);
    }

    public void m_7522_(GuiEventListener guiEventListener) {
        super.m_7522_(guiEventListener);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.selectionList.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        GuiInfoDisplayEdit.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)5, (int)-1);
        GuiInfoDisplayEdit.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)HELP_COMPONENT, (int)(this.f_96543_ / 2), (int)(this.f_96544_ - 52), (int)-1);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    class SelectionList
    extends ObjectSelectionList<Entry> {
        private static final Component USAGE_NARRATION = new TranslatableComponent("narration.selection.usage");
        private static final Component LEFT_RIGHT_USAGE = new TranslatableComponent("narration.xaero_ui_list_left_right_usage");
        private boolean dragging;
        private int dragStartX;
        private int dragStartY;
        private int dragged;
        private int draggedOffsetX;
        private int draggedOffsetY;

        public SelectionList() {
            super(GuiInfoDisplayEdit.this.f_96541_, GuiInfoDisplayEdit.this.f_96543_, GuiInfoDisplayEdit.this.f_96544_, 30, GuiInfoDisplayEdit.this.f_96544_ - 61, 24);
            this.createEntries();
            if (GuiInfoDisplayEdit.this.selected != -1) {
                this.setSelected((Entry)this.m_93500_(GuiInfoDisplayEdit.this.selected));
            }
            this.dragged = -1;
        }

        public boolean m_5694_() {
            return GuiInfoDisplayEdit.this.m_7222_() == this;
        }

        public void setSelected(Entry entry) {
            Entry oldSelected;
            if (GuiInfoDisplayEdit.this.subSelected != -1 && (oldSelected = (Entry)this.m_93511_()) != null) {
                MoveableEntry moveable = oldSelected.getMoveable();
                moveable.subElements.get(GuiInfoDisplayEdit.this.subSelected).m_5755_(true);
            }
            GuiInfoDisplayEdit.this.selected = entry == null ? -1 : entry.index;
            GuiInfoDisplayEdit.this.subSelected = -1;
            super.m_6987_((AbstractSelectionList.Entry)entry);
            super.m_7522_((GuiEventListener)entry);
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
            super.m_142291_(narrationElementOutput);
            if (this.m_5694_()) {
                narrationElementOutput.m_169149_(NarratedElementType.USAGE, new Component[]{USAGE_NARRATION, LEFT_RIGHT_USAGE});
            }
        }

        private void createEntries() {
            for (int i = 0; i < GuiInfoDisplayEdit.this.manager.getCount(); ++i) {
                Entry entry = new Entry(i);
                this.m_7085_((AbstractSelectionList.Entry)entry);
            }
        }

        private void releaseDrag() {
            this.dragging = false;
            this.dragged = -1;
        }

        protected int m_5756_() {
            return this.f_93388_ / 2 + 164;
        }

        public int m_5759_() {
            return 300;
        }

        public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            if (this.dragging) {
                int hoveredIndex;
                Entry draggedEntry = (Entry)this.m_93500_(this.dragged);
                draggedEntry.renderNonInteractable(poseStack, mouseX + this.draggedOffsetX, mouseY + this.draggedOffsetY);
                Entry hoveredEntry = (Entry)this.m_93412_(mouseX, mouseY);
                int n = hoveredIndex = hoveredEntry == null ? -1 : hoveredEntry.index;
                if (hoveredIndex != -1 && hoveredIndex != this.dragged) {
                    String draggedId = GuiInfoDisplayEdit.this.currentOrder.get(this.dragged);
                    int slideDirection = hoveredIndex < this.dragged ? 1 : -1;
                    for (int i = this.dragged; i != hoveredIndex; i -= slideDirection) {
                        GuiInfoDisplayEdit.this.currentOrder.set(i, GuiInfoDisplayEdit.this.currentOrder.get(i - slideDirection));
                    }
                    GuiInfoDisplayEdit.this.currentOrder.set(hoveredIndex, draggedId);
                    GuiInfoDisplayEdit.this.manager.setOrder(GuiInfoDisplayEdit.this.currentOrder);
                    this.dragged = hoveredIndex;
                    try {
                        GuiInfoDisplayEdit.this.modMain.getSettings().saveSettings();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else if (this.dragged != -1 && (Math.abs(mouseX - this.dragStartX) > 5 || Math.abs(mouseY - this.dragStartY) > 5)) {
                this.dragging = true;
                this.setSelected(null);
            }
        }

        public class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private final int index;
            private int lastRenderX;
            private int lastRenderY;

            public Entry(int index) {
                this.index = index;
            }

            private void renderNonInteractable(PoseStack poseStack, int x, int y) {
                String infoDisplayId = GuiInfoDisplayEdit.this.currentOrder.get(this.index);
                InfoDisplay<?> infoDisplay = GuiInfoDisplayEdit.this.manager.get(infoDisplayId);
                GuiComponent.m_93243_((PoseStack)poseStack, (Font)GuiInfoDisplayEdit.this.f_96547_, (Component)infoDisplay.getName(), (int)(x + 48), (int)(y + 6), (int)-1);
            }

            private MoveableEntry getMoveable() {
                String infoDisplayId = GuiInfoDisplayEdit.this.currentOrder.get(this.index);
                return GuiInfoDisplayEdit.this.moveableEntries.get(infoDisplayId);
            }

            public void m_6311_(PoseStack poseStack, int index, int y, int x, int l, int m, int mouseX, int mouseY, boolean bl, float partialTicks) {
                this.lastRenderX = x;
                this.lastRenderY = y;
                if (SelectionList.this.dragging && SelectionList.this.dragged == index) {
                    return;
                }
                this.renderNonInteractable(poseStack, x, y);
                MoveableEntry moveableEntry = this.getMoveable();
                for (AbstractWidget subElement : moveableEntry.subElements) {
                    subElement.f_93621_ = y - 2 + 12 - subElement.m_93694_() / 2;
                    if (subElement instanceof DropDownWidget) {
                        --subElement.f_93621_;
                    }
                    subElement.m_6305_(poseStack, mouseX, mouseY, partialTicks);
                }
            }

            public boolean m_6375_(double d, double e, int i) {
                MoveableEntry moveableEntry = this.getMoveable();
                for (AbstractWidget subElement : moveableEntry.subElements) {
                    if (!subElement.m_5953_(d, e) || !subElement.m_6375_(d, e, i)) continue;
                    return true;
                }
                if (i == 0) {
                    if (SelectionList.this.m_93511_() != this) {
                        SelectionList.this.setSelected(this);
                    } else {
                        SelectionList.this.setSelected(null);
                    }
                    SelectionList.this.dragging = false;
                    SelectionList.this.dragged = this.index;
                    SelectionList.this.draggedOffsetX = (int)((double)this.lastRenderX - d);
                    SelectionList.this.draggedOffsetY = (int)((double)this.lastRenderY - e);
                    SelectionList.this.dragStartX = (int)d;
                    SelectionList.this.dragStartY = (int)e;
                } else {
                    SelectionList.this.setSelected(null);
                }
                return super.m_6375_(d, e, i);
            }

            public boolean m_6348_(double d, double e, int i) {
                MoveableEntry moveableEntry = this.getMoveable();
                for (AbstractWidget subElement : moveableEntry.subElements) {
                    subElement.m_6348_(d, e, i);
                }
                return super.m_6348_(d, e, i);
            }

            public void m_94757_(double d, double e) {
                MoveableEntry moveableEntry = this.getMoveable();
                for (AbstractWidget subElement : moveableEntry.subElements) {
                    if (!subElement.m_5953_(d, e)) continue;
                    subElement.m_94757_(d, e);
                }
                super.m_94757_(d, e);
            }

            public boolean m_7979_(double d, double e, int i, double f, double g) {
                MoveableEntry moveableEntry = this.getMoveable();
                for (AbstractWidget subElement : moveableEntry.subElements) {
                    if (!subElement.m_5953_(d, e) || !subElement.m_7979_(d, e, i, f, g)) continue;
                    return true;
                }
                return super.m_7979_(d, e, i, f, g);
            }

            public boolean m_6050_(double d, double e, double f) {
                MoveableEntry moveableEntry = this.getMoveable();
                for (AbstractWidget subElement : moveableEntry.subElements) {
                    if (!subElement.m_5953_(d, e) || !subElement.m_6050_(d, e, f)) continue;
                    return true;
                }
                return super.m_6050_(d, e, f);
            }

            public boolean m_7933_(int i, int j, int k) {
                MoveableEntry moveableEntry = this.getMoveable();
                if (i == 262 || i == 263) {
                    if (GuiInfoDisplayEdit.this.subSelected != -1) {
                        moveableEntry.subElements.get(GuiInfoDisplayEdit.this.subSelected).m_5755_(true);
                    }
                    if (i == 262) {
                        ++GuiInfoDisplayEdit.this.subSelected;
                        if (GuiInfoDisplayEdit.this.subSelected == moveableEntry.subElements.size()) {
                            GuiInfoDisplayEdit.this.subSelected = -1;
                        }
                    } else {
                        --GuiInfoDisplayEdit.this.subSelected;
                        if (GuiInfoDisplayEdit.this.subSelected < -1) {
                            GuiInfoDisplayEdit.this.subSelected = moveableEntry.subElements.size() - 1;
                        }
                    }
                    if (GuiInfoDisplayEdit.this.subSelected != -1) {
                        moveableEntry.subElements.get(GuiInfoDisplayEdit.this.subSelected).m_5755_(true);
                    }
                } else if (GuiInfoDisplayEdit.this.subSelected != -1 && moveableEntry.subElements.get(GuiInfoDisplayEdit.this.subSelected).m_7933_(i, j, k)) {
                    return true;
                }
                return super.m_7933_(i, j, k);
            }

            public boolean m_7920_(int i, int j, int k) {
                MoveableEntry moveableEntry = this.getMoveable();
                if (GuiInfoDisplayEdit.this.subSelected != -1 && moveableEntry.subElements.get(GuiInfoDisplayEdit.this.subSelected).m_7920_(i, j, k)) {
                    return true;
                }
                return super.m_7920_(i, j, k);
            }

            public boolean m_5534_(char c, int i) {
                MoveableEntry moveableEntry = this.getMoveable();
                if (GuiInfoDisplayEdit.this.subSelected != -1 && moveableEntry.subElements.get(GuiInfoDisplayEdit.this.subSelected).m_5534_(c, i)) {
                    return true;
                }
                return super.m_5534_(c, i);
            }

            public void m_142291_(NarrationElementOutput narrationElementOutput) {
                MoveableEntry moveableEntry = this.getMoveable();
                if (GuiInfoDisplayEdit.this.subSelected >= 0) {
                    moveableEntry.subElements.get(GuiInfoDisplayEdit.this.subSelected).m_142291_(narrationElementOutput);
                } else {
                    super.m_142291_(narrationElementOutput);
                }
            }

            public Component m_142172_() {
                String infoDisplayId = GuiInfoDisplayEdit.this.currentOrder.get(this.index);
                InfoDisplay<?> infoDisplay = GuiInfoDisplayEdit.this.manager.get(infoDisplayId);
                String narration = infoDisplay.getName().getString();
                return new TextComponent(I18n.m_118938_((String)"narrator.select", (Object[])new Object[]{narration}));
            }
        }
    }

    class MoveableEntry {
        private final List<AbstractWidget> subElements = new ArrayList<AbstractWidget>();

        public void addSubElement(AbstractWidget widget) {
            this.subElements.add(widget);
        }
    }
}

