/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.attachment;

import cofh.core.util.filter.BaseFluidFilter;
import cofh.core.util.filter.IFilter;
import cofh.lib.api.IConveyableData;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.dynamics.api.grid.IDuct;
import cofh.thermal.dynamics.attachment.IAttachment;
import cofh.thermal.dynamics.attachment.IFilterableAttachment;
import cofh.thermal.dynamics.attachment.IRedstoneControllableAttachment;
import cofh.thermal.dynamics.attachment.RedstoneControlLogic;
import cofh.thermal.dynamics.client.TDynTextures;
import cofh.thermal.dynamics.grid.Grid;
import cofh.thermal.dynamics.inventory.container.attachment.FluidServoAttachmentContainer;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidServoAttachment
implements IFilterableAttachment,
IRedstoneControllableAttachment,
IConveyableData,
MenuProvider {
    public static final Component DISPLAY_NAME = new TranslatableComponent("attachment.thermal.servo");
    public static final int TRANSFER = 50;
    protected final IDuct<?, ?> duct;
    protected final Direction side;
    protected BaseFluidFilter filter = new BaseFluidFilter(15);
    protected RedstoneControlLogic rsControl = new RedstoneControlLogic(this);
    protected LazyOptional<IFluidHandler> internalGridCap = LazyOptional.empty();
    protected LazyOptional<IFluidHandler> gridCap = LazyOptional.empty();
    protected LazyOptional<IFluidHandler> externalCap = LazyOptional.empty();

    public FluidServoAttachment(IDuct<?, ?> duct, Direction side) {
        this.duct = duct;
        this.side = side;
    }

    public final int getTransfer() {
        return 50;
    }

    @Override
    public IDuct<?, ?> duct() {
        return this.duct;
    }

    @Override
    public Direction side() {
        return this.side;
    }

    @Override
    public IAttachment read(CompoundTag nbt) {
        if (nbt.m_128456_()) {
            return this;
        }
        this.filter.read(nbt);
        this.rsControl.read(nbt);
        return this;
    }

    @Override
    public CompoundTag write(CompoundTag nbt) {
        nbt.m_128359_("Type", "servo");
        this.filter.write(nbt);
        this.rsControl.write(nbt);
        return nbt;
    }

    @Override
    public void tick() {
        if (!this.rsControl.getState()) {
            return;
        }
        if (!this.internalGridCap.isPresent()) {
            this.internalGridCap = ((Grid)this.duct.getGrid()).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        }
        this.externalCap.ifPresent(e -> this.internalGridCap.ifPresent(i -> i.fill(e.drain(i.fill(e.drain(this.getTransfer(), IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE)));
    }

    @Override
    public ItemStack getItem() {
        return new ItemStack((ItemLike)ThermalCore.ITEMS.get("servo_attachment"));
    }

    @Override
    public ResourceLocation getTexture() {
        return this.rsControl.getState() ? TDynTextures.SERVO_ATTACHMENT_ACTIVE_LOC : TDynTextures.SERVO_ATTACHMENT_LOC;
    }

    public Component m_5446_() {
        return DISPLAY_NAME;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new FluidServoAttachmentContainer(i, player.m_183503_(), this.pos(), this.side, inventory, player);
    }

    @Override
    public <T> LazyOptional<T> wrapGridCapability(@Nonnull Capability<T> cap, @Nonnull LazyOptional<T> gridLazOpt) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            Object t;
            if (this.gridCap.isPresent()) {
                return this.gridCap.cast();
            }
            Optional gridOpt = gridLazOpt.resolve();
            if (gridOpt.isPresent() && (t = gridOpt.get()) instanceof IFluidHandler) {
                IFluidHandler handler = (IFluidHandler)t;
                this.gridCap = LazyOptional.of(() -> new WrappedGridFluidHandler(handler));
                gridLazOpt.addListener(e -> this.gridCap.invalidate());
                return this.gridCap.cast();
            }
        }
        return gridLazOpt;
    }

    @Override
    public <T> LazyOptional<T> wrapExternalCapability(@Nonnull Capability<T> cap, @Nonnull LazyOptional<T> extLazOpt) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            Object t;
            if (this.externalCap.isPresent()) {
                return this.externalCap.cast();
            }
            Optional extOpt = extLazOpt.resolve();
            if (extOpt.isPresent() && (t = extOpt.get()) instanceof IFluidHandler) {
                IFluidHandler handler = (IFluidHandler)t;
                this.externalCap = LazyOptional.of(() -> new WrappedExternalFluidHandler(handler, e -> this.rsControl.getState() && this.filter.valid(e)));
                extLazOpt.addListener(e -> this.externalCap.invalidate());
                return this.externalCap.cast();
            }
        }
        return extLazOpt;
    }

    @Override
    public IFilter getFilter() {
        return this.filter;
    }

    @Override
    public FriendlyByteBuf getConfigPacket(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.filter.getAllowList());
        buffer.writeBoolean(this.filter.getCheckNBT());
        return buffer;
    }

    @Override
    public void handleConfigPacket(FriendlyByteBuf buffer) {
        this.filter.setAllowList(buffer.readBoolean());
        this.filter.setCheckNBT(buffer.readBoolean());
    }

    @Override
    public FriendlyByteBuf getControlPacket(FriendlyByteBuf buffer) {
        this.rsControl.writeToBuffer(buffer);
        return buffer;
    }

    @Override
    public void handleControlPacket(FriendlyByteBuf buffer) {
        this.rsControl.readFromBuffer(buffer);
    }

    @Override
    public RedstoneControlLogic redstoneControl() {
        return this.rsControl;
    }

    public void readConveyableData(Player player, CompoundTag tag) {
        this.rsControl.readSettings(tag);
        this.filter.read(tag);
    }

    public void writeConveyableData(Player player, CompoundTag tag) {
        this.rsControl.writeSettings(tag);
        this.filter.write(tag);
    }

    private static class WrappedExternalFluidHandler
    implements IFluidHandler {
        protected IFluidHandler wrappedHandler;
        protected Predicate<FluidStack> validator;

        public WrappedExternalFluidHandler(IFluidHandler wrappedHandler, Predicate<FluidStack> validator) {
            this.wrappedHandler = wrappedHandler;
            this.validator = validator;
        }

        public int getTanks() {
            return this.wrappedHandler.getTanks();
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return this.wrappedHandler.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.wrappedHandler.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return this.validator.test(stack) && this.wrappedHandler.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.validator.test(resource) ? this.wrappedHandler.drain(resource, action) : FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.validator.test(this.wrappedHandler.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE)) ? this.wrappedHandler.drain(maxDrain, action) : FluidStack.EMPTY;
        }
    }

    private static class WrappedGridFluidHandler
    implements IFluidHandler {
        protected IFluidHandler wrappedHandler;

        public WrappedGridFluidHandler(IFluidHandler wrappedHandler) {
            this.wrappedHandler = wrappedHandler;
        }

        public int getTanks() {
            return this.wrappedHandler.getTanks();
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return this.wrappedHandler.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.wrappedHandler.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return this.wrappedHandler.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }
}

