/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.command;

import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.stream.Stream;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.command.ArgumentBuilderBuilder;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.gui.screen.HomeScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class ClientCommand<S> {
    private final ArgumentBuilderFactory<S> argument;

    protected ClientCommand(ArgumentBuilderFactory<S> argument) {
        this.argument = argument;
    }

    protected abstract FeedbackSender feedback(S var1);

    public final void register(CommandDispatcher<S> dispatcher) {
        ArgumentBuilderBuilder<S> command = new ArgumentBuilderBuilder<S>(this.argument.literal("wailac")).then((ArgumentBuilder<S, ?>)this.argument.literal("config")).then((ArgumentBuilder<S, ?>)this.argument.literal("open")).executes(context -> {
            Minecraft client = Minecraft.m_91087_();
            client.m_6937_(() -> client.m_91152_((Screen)new HomeScreen(client.f_91080_)));
            return 1;
        }).pop("open").then((ArgumentBuilder<S, ?>)this.argument.literal("plugin")).then((ArgumentBuilder<S, ?>)this.argument.required("id", ResourceLocationArgument.m_106984_())).suggests((context, builder) -> SharedSuggestionProvider.m_82926_(PluginConfig.getAllKeys(), (SuggestionsBuilder)builder)).executes(context -> {
            FeedbackSender feedback = this.feedback(context.getSource());
            ResourceLocation id = (ResourceLocation)context.getArgument("id", ResourceLocation.class);
            ConfigEntry entry = PluginConfig.getEntry(id);
            if (entry == null) {
                feedback.fail((Component)new TranslatableComponent("command.waila.config.unknown_id", new Object[]{id}));
                return 0;
            }
            feedback.success((Component)new TranslatableComponent("command.waila.config.get.id", new Object[]{id}));
            feedback.success((Component)new TranslatableComponent("command.waila.config.get.synced", new Object[]{entry.isSynced()}));
            feedback.success((Component)new TranslatableComponent("command.waila.config.get.current_value", new Object[]{entry.getValue(false).toString()}));
            feedback.success((Component)new TranslatableComponent("command.waila.config.get.default_value", new Object[]{entry.getDefaultValue().toString()}));
            if (entry.isServerRequired()) {
                feedback.success((Component)new TranslatableComponent("command.waila.config.get.client_only_value", new Object[]{entry.getClientOnlyValue().toString()}));
            }
            return 1;
        }).then((ArgumentBuilder<S, ?>)this.argument.required("value", StringArgumentType.word())).suggests((context, builder) -> {
            ResourceLocation id = (ResourceLocation)context.getArgument("id", ResourceLocation.class);
            ConfigEntry entry = PluginConfig.getEntry(id);
            if (entry != null) {
                if (entry.getType().equals(ConfigEntry.BOOLEAN)) {
                    return SharedSuggestionProvider.m_82967_((String[])new String[]{String.valueOf((Boolean)entry.getValue(false) == false)}, (SuggestionsBuilder)builder);
                }
                if (entry.getType().equals(ConfigEntry.ENUM)) {
                    Stream<String> suggestions = Arrays.stream(entry.getLocalValue().getClass().getEnumConstants()).filter(e -> e != entry.getLocalValue()).map(e -> ((Enum)e).name());
                    return SharedSuggestionProvider.m_82981_(suggestions, (SuggestionsBuilder)builder);
                }
            }
            return SharedSuggestionProvider.m_82967_((String[])new String[0], (SuggestionsBuilder)builder);
        }).executes(context -> {
            FeedbackSender feedback = this.feedback(context.getSource());
            ResourceLocation id = (ResourceLocation)context.getArgument("id", ResourceLocation.class);
            ConfigEntry entry = PluginConfig.getEntry(id);
            if (entry == null) {
                feedback.fail((Component)new TranslatableComponent("command.waila.config.unknown_id", new Object[]{id}));
                return 0;
            }
            if (entry.blocksClientEdit() && Minecraft.m_91087_().m_91089_() != null) {
                feedback.fail((Component)new TranslatableComponent("command.waila.config.set.synced", new Object[]{id}));
            }
            JsonPrimitive jsonValue = new JsonPrimitive((String)context.getArgument("value", String.class));
            try {
                entry.setLocalValue(entry.getType().parser.apply(jsonValue, (JsonPrimitive)entry.getDefaultValue()));
                feedback.success((Component)new TranslatableComponent("command.waila.config.set.success", new Object[]{id, entry.getLocalValue()}));
                return 1;
            }
            catch (Throwable throwable) {
                feedback.fail((Component)new TranslatableComponent("command.waila.config.set.parse_fail", new Object[]{throwable.getMessage()}));
                throwable.printStackTrace();
                return 0;
            }
        }).pop("value", "id", "plugin", "config").then((ArgumentBuilder<S, ?>)this.argument.literal("overlay")).then((ArgumentBuilder<S, ?>)this.argument.required("enabled", BoolArgumentType.bool())).suggests((context, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{String.valueOf(!Waila.CONFIG.get().getGeneral().isDisplayTooltip())}, (SuggestionsBuilder)builder)).executes(context -> {
            FeedbackSender feedback = this.feedback(context.getSource());
            boolean enabled = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
            Waila.CONFIG.get().getGeneral().setDisplayTooltip(enabled);
            feedback.success((Component)new TranslatableComponent("command.waila.overlay." + enabled));
            return enabled ? 1 : 0;
        }).pop("enabled", "overlay");
        if (Waila.ENABLE_DEBUG_COMMAND) {
            command.then((ArgumentBuilder<S, ?>)this.argument.literal("debug")).then((ArgumentBuilder<S, ?>)this.argument.literal("showComponentBounds")).then((ArgumentBuilder<S, ?>)this.argument.required("enabled", BoolArgumentType.bool())).suggests((context, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{String.valueOf(!WailaClient.showComponentBounds)}, (SuggestionsBuilder)builder)).executes(context -> {
                FeedbackSender feedback = this.feedback(context.getSource());
                boolean enabled = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
                Minecraft.m_91087_().execute(() -> {
                    WailaClient.showComponentBounds = enabled;
                });
                feedback.success((Component)new TextComponent((enabled ? "En" : "Dis") + "abled component bounds"));
                return enabled ? 1 : 0;
            }).pop("enabled", "showComponentBounds", "debug");
        }
        command.register(dispatcher);
    }

    protected static interface ArgumentBuilderFactory<S> {
        public LiteralArgumentBuilder<S> literal(String var1);

        public <T> RequiredArgumentBuilder<S, T> required(String var1, ArgumentType<T> var2);
    }

    protected static interface FeedbackSender {
        public void success(Component var1);

        public void fail(Component var1);
    }
}

