/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing;

import com.jozufozu.flywheel.backend.model.BufferBuilderExtension;
import com.jozufozu.flywheel.backend.model.DirectVertexConsumer;
import com.mojang.blaze3d.platform.MemoryTracker;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.ApiStatus;

public class DrawBuffer {
    private final RenderType parent;
    private ByteBuffer backingBuffer;
    private int expectedVertices;

    @ApiStatus.Internal
    public DrawBuffer(RenderType parent) {
        this.parent = parent;
    }

    public DirectVertexConsumer begin(int vertexCount) {
        if (this.expectedVertices != 0) {
            throw new IllegalStateException("Already drawing");
        }
        this.expectedVertices = vertexCount;
        VertexFormat format = this.parent.m_110508_();
        int byteSize = format.m_86020_() * (vertexCount + 1);
        if (this.backingBuffer == null) {
            this.backingBuffer = MemoryTracker.m_182527_((int)byteSize);
        }
        if (byteSize > this.backingBuffer.capacity()) {
            this.backingBuffer = MemoryTracker.m_182529_((ByteBuffer)this.backingBuffer, (int)byteSize);
        }
        return new DirectVertexConsumer(this.backingBuffer, format, vertexCount);
    }

    public void inject(BufferBuilderExtension bufferBuilder) {
        bufferBuilder.flywheel$injectForRender(this.backingBuffer, this.parent.m_110508_(), this.expectedVertices);
    }

    public boolean hasVertices() {
        return this.expectedVertices > 0;
    }

    public void reset() {
        this.expectedVertices = 0;
    }
}

