/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.config;

import com.jozufozu.flywheel.config.BackendType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class FlwConfig {
    private static final FlwConfig INSTANCE = new FlwConfig();
    public final ClientConfig client;

    public FlwConfig() {
        Pair client = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        this.client = (ClientConfig)client.getLeft();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)client.getRight());
    }

    public static FlwConfig get() {
        return INSTANCE;
    }

    public BackendType getBackendType() {
        return (BackendType)((Object)this.client.backend.get());
    }

    public boolean debugNormals() {
        return (Boolean)this.client.debugNormals.get();
    }

    public boolean limitUpdates() {
        return (Boolean)this.client.limitUpdates.get();
    }

    public static void init() {
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.EnumValue<BackendType> backend;
        public final ForgeConfigSpec.BooleanValue debugNormals;
        public final ForgeConfigSpec.BooleanValue limitUpdates;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            this.backend = builder.comment("Select the backend to use.").defineEnum("backend", (Enum)BackendType.INSTANCING);
            this.debugNormals = builder.comment("Enable or disable a debug overlay that colors pixels by their normal.").define("debugNormals", false);
            this.limitUpdates = builder.comment("Enable or disable instance update limiting with distance.").define("limitUpdates", true);
        }
    }
}

