/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.model;

import com.jozufozu.flywheel.api.vertex.VertexList;
import com.jozufozu.flywheel.api.vertex.VertexType;
import com.jozufozu.flywheel.core.Formats;
import com.jozufozu.flywheel.core.model.BakedModelBuilder;
import com.jozufozu.flywheel.core.model.Bufferable;
import com.jozufozu.flywheel.core.model.Model;
import com.jozufozu.flywheel.core.model.ShadeSeparatedBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.block.state.BlockState;

public class BlockModel
implements Model {
    private final VertexList reader;
    private final String name;

    public BlockModel(BlockState state) {
        this(Minecraft.m_91087_().m_91289_().m_110910_(state), state);
    }

    public BlockModel(BakedModel model, BlockState referenceState) {
        this(new BakedModelBuilder(model).withReferenceState(referenceState), referenceState.toString());
    }

    public BlockModel(BakedModel model, BlockState referenceState, PoseStack ms) {
        this(new BakedModelBuilder(model).withReferenceState(referenceState).withPoseStack(ms), referenceState.toString());
    }

    public BlockModel(Bufferable bufferable, String name) {
        this(bufferable.build(), name);
    }

    public BlockModel(ShadeSeparatedBufferBuilder bufferBuilder, String name) {
        this.name = name;
        this.reader = Formats.BLOCK.createReader(bufferBuilder);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int vertexCount() {
        return this.reader.getVertexCount();
    }

    @Override
    public VertexList getReader() {
        return this.reader;
    }

    @Override
    public VertexType getType() {
        return Formats.BLOCK;
    }

    @Override
    public void delete() {
        VertexList vertexList = this.reader;
        if (vertexList instanceof AutoCloseable) {
            AutoCloseable closeable = (AutoCloseable)((Object)vertexList);
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

