/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.vertex;

import com.jozufozu.flywheel.api.vertex.ShadedVertexList;
import com.jozufozu.flywheel.core.vertex.AbstractVertexList;
import com.jozufozu.flywheel.util.RenderMath;
import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;

public class BlockVertexListUnsafe
extends AbstractVertexList {
    public BlockVertexListUnsafe(ByteBuffer copyFrom, int vertexCount) {
        super(copyFrom, vertexCount);
    }

    private long ptr(long index) {
        return this.base + index * 32L;
    }

    @Override
    public boolean isEmpty() {
        return this.vertexCount == 0;
    }

    @Override
    public float getX(int index) {
        return MemoryUtil.memGetFloat((long)this.ptr(index));
    }

    @Override
    public float getY(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr(index) + 4L));
    }

    @Override
    public float getZ(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr(index) + 8L));
    }

    @Override
    public byte getR(int index) {
        return MemoryUtil.memGetByte((long)(this.ptr(index) + 12L));
    }

    @Override
    public byte getG(int index) {
        return MemoryUtil.memGetByte((long)(this.ptr(index) + 13L));
    }

    @Override
    public byte getB(int index) {
        return MemoryUtil.memGetByte((long)(this.ptr(index) + 14L));
    }

    @Override
    public byte getA(int index) {
        return MemoryUtil.memGetByte((long)(this.ptr(index) + 15L));
    }

    @Override
    public float getU(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr(index) + 16L));
    }

    @Override
    public float getV(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr(index) + 20L));
    }

    @Override
    public int getLight(int index) {
        return MemoryUtil.memGetInt((long)(this.ptr(index) + 24L));
    }

    @Override
    public float getNX(int index) {
        return RenderMath.f(MemoryUtil.memGetByte((long)(this.ptr(index) + 28L)));
    }

    @Override
    public float getNY(int index) {
        return RenderMath.f(MemoryUtil.memGetByte((long)(this.ptr(index) + 29L)));
    }

    @Override
    public float getNZ(int index) {
        return RenderMath.f(MemoryUtil.memGetByte((long)(this.ptr(index) + 30L)));
    }

    public static class Shaded
    extends BlockVertexListUnsafe
    implements ShadedVertexList {
        private final int unshadedStartVertex;

        public Shaded(ByteBuffer buffer, int vertexCount, int unshadedStartVertex) {
            super(buffer, vertexCount);
            this.unshadedStartVertex = unshadedStartVertex;
        }

        @Override
        public boolean isShaded(int index) {
            return index < this.unshadedStartVertex;
        }
    }
}

