/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.tinkering;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.enchantment.Enchantment;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierId;

public abstract class AbstractEnchantmentToModifierProvider
extends GenericDataProvider {
    private final JsonObject enchantmentMap = new JsonObject();

    public AbstractEnchantmentToModifierProvider(DataGenerator generator) {
        super(generator, PackType.SERVER_DATA, "tinkering");
    }

    protected abstract void addEnchantmentMappings();

    public void m_6865_(HashCache pCache) throws IOException {
        this.enchantmentMap.entrySet().clear();
        this.addEnchantmentMappings();
        this.saveThing(pCache, TConstruct.getResource("enchantments_to_modifiers"), this.enchantmentMap);
    }

    protected void add(Enchantment enchantment, ModifierId modifierId) {
        String key = Objects.requireNonNull(enchantment.getRegistryName()).toString();
        if (this.enchantmentMap.has(key)) {
            throw new IllegalArgumentException("Duplicate enchantment " + key);
        }
        this.enchantmentMap.addProperty(key, modifierId.toString());
    }

    protected void add(TagKey<Enchantment> tag, ModifierId modifierId) {
        String key = "#" + tag.f_203868_();
        if (this.enchantmentMap.has(key)) {
            throw new IllegalArgumentException("Duplicate enchantment tag " + tag.f_203868_());
        }
        this.enchantmentMap.addProperty(key, modifierId.toString());
    }

    protected void add(ResourceLocation tag, ModifierId modifierId) {
        this.add((TagKey<Enchantment>)TagKey.m_203882_((ResourceKey)Registry.f_122902_, (ResourceLocation)tag), modifierId);
    }
}

