/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.mantle.client.ResourceColorManager;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.modifiers.util.ModifierLevelDisplay;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.RestrictedCompoundTag;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.library.utils.Util;

public class Modifier
implements GenericLoaderRegistry.IHaveLoader<Modifier> {
    public static final GenericLoaderRegistry.IGenericLoader<Modifier> DEFAULT_LOADER = new GenericLoaderRegistry.IGenericLoader<Modifier>(){

        public Modifier deserialize(JsonObject json) {
            return new Modifier();
        }

        public Modifier fromNetwork(FriendlyByteBuf buffer) {
            return new Modifier();
        }

        public void serialize(Modifier object, JsonObject json) {
            if (object.getClass() != Modifier.class) {
                throw new IllegalStateException("Attempting to serialize a subclass of Modifier using the default modifier loader, this likely means the modifier did not override getLoader()");
            }
        }

        public void toNetwork(Modifier object, FriendlyByteBuf buffer) {
        }
    };
    protected static Random RANDOM = new Random();
    public static final int DEFAULT_PRIORITY = 100;
    private ModifierId id;
    @Nullable
    private String translationKey;
    @Nullable
    private Component displayName;
    @Nullable
    protected List<Component> descriptionList;
    @Nullable
    private Component description;
    private final ModifierHookMap hooks;

    protected Modifier(ModifierHookMap hooks) {
        this.hooks = hooks;
    }

    public Modifier() {
        ModifierHookMap.Builder hookBuilder = new ModifierHookMap.Builder();
        this.registerHooks(hookBuilder);
        this.hooks = hookBuilder.build();
    }

    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
    }

    public GenericLoaderRegistry.IGenericLoader<? extends Modifier> getLoader() {
        return DEFAULT_LOADER;
    }

    public int getPriority() {
        return 100;
    }

    final void setId(ModifierId name) {
        if (this.id != null) {
            throw new IllegalStateException("Attempted to set registry name with existing registry name! New: " + name + " Old: " + this.id);
        }
        this.id = name;
    }

    public ModifierId getId() {
        return Objects.requireNonNull(this.id, "Modifier has null registry name");
    }

    public final boolean is(TagKey<Modifier> tag) {
        return ModifierManager.isInTag(this.getId(), tag);
    }

    public void clearCache(PackType packType) {
        if (packType == PackType.CLIENT_RESOURCES) {
            this.displayName = null;
        }
    }

    public final TextColor getTextColor() {
        return ResourceColorManager.getTextColor((String)this.getTranslationKey());
    }

    public final int getColor() {
        return this.getTextColor().m_131265_();
    }

    protected String makeTranslationKey() {
        return Util.makeTranslationKey("modifier", Objects.requireNonNull(this.id));
    }

    public final String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = this.makeTranslationKey();
        }
        return this.translationKey;
    }

    protected Component makeDisplayName() {
        return new TranslatableComponent(this.getTranslationKey());
    }

    public MutableComponent applyStyle(MutableComponent component) {
        return component.m_130938_(style -> style.m_131148_(this.getTextColor()));
    }

    public Component getDisplayName() {
        if (this.displayName == null) {
            this.displayName = new TranslatableComponent(this.getTranslationKey()).m_130938_(style -> style.m_131148_(this.getTextColor()));
        }
        return this.displayName;
    }

    public Component getDisplayName(int level) {
        return ModifierLevelDisplay.DEFAULT.nameForLevel(this, level);
    }

    public Component getDisplayName(IToolStackView tool, int level) {
        return this.getDisplayName(level);
    }

    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
    }

    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, slimeknights.mantle.client.TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        this.addInformation(tool, level, player, tooltip, TooltipKey.fromMantle(tooltipKey), tooltipFlag);
    }

    public List<Component> getDescriptionList() {
        if (this.descriptionList == null) {
            this.descriptionList = Arrays.asList(new TranslatableComponent(this.getTranslationKey() + ".flavor").m_130940_(ChatFormatting.ITALIC), new TranslatableComponent(this.getTranslationKey() + ".description"));
        }
        return this.descriptionList;
    }

    public List<Component> getDescriptionList(int level) {
        return this.getDescriptionList();
    }

    public List<Component> getDescriptionList(IToolStackView tool, int level) {
        return this.getDescriptionList(level);
    }

    private static Component listToComponent(List<Component> list) {
        if (list.isEmpty()) {
            return TextComponent.f_131282_;
        }
        TextComponent textComponent = new TextComponent("");
        Iterator<Component> iterator = list.iterator();
        textComponent.m_7220_(iterator.next());
        while (iterator.hasNext()) {
            textComponent.m_130946_("\n");
            textComponent.m_7220_(iterator.next());
        }
        return textComponent;
    }

    public final Component getDescription() {
        if (this.description == null) {
            this.description = Modifier.listToComponent(this.getDescriptionList());
        }
        return this.description;
    }

    public final Component getDescription(int level) {
        List<Component> extendedDescription = this.getDescriptionList(level);
        if (extendedDescription == this.getDescriptionList()) {
            return this.getDescription();
        }
        return Modifier.listToComponent(extendedDescription);
    }

    public final Component getDescription(IToolStackView tool, int level) {
        List<Component> extendedDescription = this.getDescriptionList(tool, level);
        if (extendedDescription == this.getDescriptionList()) {
            return this.getDescription();
        }
        return Modifier.listToComponent(extendedDescription);
    }

    public float getEffectiveLevel(IToolContext tool, int level) {
        return level;
    }

    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
    }

    public void addToolStats(ToolRebuildContext context, int level, ModifierStatsBuilder builder) {
    }

    public void addAttributes(IToolStackView tool, int level, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
    }

    public void addRawData(IToolStackView tool, int level, RestrictedCompoundTag tag) {
    }

    public ValidatedResult validate(IToolStackView tool, int level) {
        return ValidatedResult.PASS;
    }

    public void beforeRemoved(IToolStackView tool, RestrictedCompoundTag tag) {
    }

    public void onRemoved(IToolStackView tool) {
    }

    public int onDamageTool(IToolStackView tool, int level, int amount, @Nullable LivingEntity holder) {
        return amount;
    }

    public float getRepairFactor(IToolStackView toolStack, int level, float factor) {
        return factor;
    }

    public void onInventoryTick(IToolStackView tool, int level, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
    }

    public List<ItemStack> processLoot(IToolStackView tool, int level, List<ItemStack> generatedLoot, LootContext context) {
        return generatedLoot;
    }

    @Deprecated
    public InteractionResult beforeBlockUse(IToolStackView tool, int level, UseOnContext context, EquipmentSlot slot) {
        return InteractionResult.PASS;
    }

    @Deprecated
    public InteractionResult afterBlockUse(IToolStackView tool, int level, UseOnContext context, EquipmentSlot slot) {
        return InteractionResult.PASS;
    }

    @Deprecated
    public InteractionResult beforeEntityUse(IToolStackView tool, int level, Player player, Entity target, InteractionHand hand, EquipmentSlot slot) {
        return InteractionResult.PASS;
    }

    @Deprecated
    public InteractionResult afterEntityUse(IToolStackView tool, int level, Player player, LivingEntity target, InteractionHand hand, EquipmentSlot slot) {
        return InteractionResult.PASS;
    }

    @Deprecated
    public InteractionResult onToolUse(IToolStackView tool, int level, Level world, Player player, InteractionHand hand, EquipmentSlot slot) {
        return InteractionResult.PASS;
    }

    @Deprecated
    public boolean onStoppedUsing(IToolStackView tool, int level, Level world, LivingEntity entity, int timeLeft) {
        return false;
    }

    @Deprecated
    public boolean onFinishUsing(IToolStackView tool, int level, Level world, LivingEntity entity) {
        return false;
    }

    @Deprecated
    public int getUseDuration(IToolStackView tool, int level) {
        return 0;
    }

    @Deprecated
    public UseAnim getUseAction(IToolStackView tool, int level) {
        return UseAnim.NONE;
    }

    public boolean canPerformAction(IToolStackView tool, int level, ToolAction toolAction) {
        return false;
    }

    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
    }

    @Deprecated
    public void applyHarvestEnchantments(IToolStackView tool, int level, ToolHarvestContext context, BiConsumer<Enchantment, Integer> consumer) {
    }

    @Deprecated
    public int getLootingValue(IToolStackView tool, int level, LivingEntity holder, Entity target, @Nullable DamageSource damageSource, int looting) {
        return looting;
    }

    @Nullable
    public Boolean removeBlock(IToolStackView tool, int level, ToolHarvestContext context) {
        return null;
    }

    public void afterBlockBreak(IToolStackView tool, int level, ToolHarvestContext context) {
    }

    public void finishBreakingBlocks(IToolStackView tool, int level, ToolHarvestContext context) {
    }

    public float getEntityDamage(IToolStackView tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        return damage;
    }

    public float beforeEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        return knockback;
    }

    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        return 0;
    }

    public void failedEntityHit(IToolStackView tool, int level, ToolAttackContext context) {
    }

    public float getProtectionModifier(IToolStackView tool, int level, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float modifierValue) {
        return modifierValue;
    }

    public boolean isSourceBlocked(IToolStackView tool, int level, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount) {
        return false;
    }

    public void onAttacked(IToolStackView tool, int level, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
    }

    public void attackWithArmor(IToolStackView tool, int level, EquipmentContext context, EquipmentSlot slotType, LivingEntity target, DamageSource source, float amount, boolean isDirectDamage) {
    }

    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
    }

    public void onEquip(IToolStackView tool, int level, EquipmentChangeContext context) {
    }

    public void onEquipmentChange(IToolStackView tool, int level, EquipmentChangeContext context, EquipmentSlot slotType) {
    }

    public boolean shouldDisplay(boolean advanced) {
        return true;
    }

    public double getDamagePercentage(IToolStackView tool, int level) {
        return Double.NaN;
    }

    @Nullable
    public Boolean showDurabilityBar(IToolStackView tool, int level) {
        return null;
    }

    public int getDurabilityRGB(IToolStackView tool, int level) {
        return -1;
    }

    @Nullable
    @Deprecated
    public <T> T getModule(Class<T> type) {
        return null;
    }

    public final <T> T getHook(ModifierHook<T> hook) {
        return this.hooks.getOrDefault(hook);
    }

    public String toString() {
        return "Modifier{" + this.id + "}";
    }

    @Nullable
    public static ToolStack getHeldTool(@Nullable LivingEntity living, InteractionHand hand) {
        return Modifier.getHeldTool(living, Util.getSlotType(hand));
    }

    @Nullable
    public static ToolStack getHeldTool(@Nullable LivingEntity living, EquipmentSlot slot) {
        if (living == null) {
            return null;
        }
        ItemStack stack = living.m_6844_(slot);
        if (stack.m_41619_() || !stack.m_204117_(TinkerTags.Items.MODIFIABLE)) {
            return null;
        }
        ToolStack tool = ToolStack.from(stack);
        return tool.isBroken() ? null : tool;
    }

    public static float getMiningModifier(LivingEntity entity) {
        MobEffectInstance miningFatigue;
        float modifier = 1.0f;
        if (MobEffectUtil.m_19584_((LivingEntity)entity)) {
            modifier *= 1.0f + (float)(MobEffectUtil.m_19586_((LivingEntity)entity) + 1) * 0.2f;
        }
        if ((miningFatigue = entity.m_21124_(MobEffects.f_19599_)) != null) {
            switch (miningFatigue.m_19564_()) {
                case 0: {
                    modifier *= 0.3f;
                    break;
                }
                case 1: {
                    modifier *= 0.09f;
                    break;
                }
                case 2: {
                    modifier *= 0.0027f;
                    break;
                }
                default: {
                    modifier *= 8.1E-4f;
                }
            }
        }
        if (entity.m_204029_(FluidTags.f_13131_) && !ModifierUtil.hasAquaAffinity(entity)) {
            modifier /= 5.0f;
        }
        if (!entity.m_20096_()) {
            modifier /= 5.0f;
        }
        return modifier;
    }

    protected void addFlatBoost(Component name, double bonus, List<Component> tooltip) {
        tooltip.add((Component)this.applyStyle(new TextComponent(Util.BONUS_FORMAT.format(bonus) + " ").m_7220_(name)));
    }

    protected void addPercentTooltip(Component name, double bonus, List<Component> tooltip) {
        tooltip.add((Component)this.applyStyle(new TextComponent(Util.PERCENT_BOOST_FORMAT.format(bonus) + " ").m_7220_(name)));
    }

    protected void addStatTooltip(IToolStackView tool, FloatToolStat stat, TagKey<Item> condition, float amount, List<Component> tooltip) {
        if (tool.hasTag(condition)) {
            this.addFlatBoost((Component)new TranslatableComponent(this.getTranslationKey() + "." + stat.getName().m_135815_()), amount * tool.getMultiplier(stat), tooltip);
        }
    }

    protected void addDamageTooltip(IToolStackView tool, float amount, List<Component> tooltip) {
        this.addStatTooltip(tool, ToolStats.ATTACK_DAMAGE, TinkerTags.Items.MELEE_OR_UNARMED, amount, tooltip);
    }

    @Nullable
    protected static <M, E> E tryModuleMatch(Class<E> expected, Class<M> moduleType, M module) {
        if (moduleType == expected) {
            return (E)module;
        }
        return null;
    }

    public ModifierHookMap getHooks() {
        return this.hooks;
    }
}

