/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.dynamic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.util.ModifierLevelDisplay;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.RestrictedCompoundTag;

public class EnchantmentModifier
extends Modifier {
    private final Enchantment enchantment;
    private final int enchantmentLevel;
    private final ModifierLevelDisplay levelDisplay;
    public static final GenericLoaderRegistry.IGenericLoader<EnchantmentModifier> LOADER = new GenericLoaderRegistry.IGenericLoader<EnchantmentModifier>(){

        public EnchantmentModifier deserialize(JsonObject json) {
            JsonObject enchantmentJson = GsonHelper.m_13930_((JsonObject)json, (String)"enchantment");
            Enchantment enchantment = (Enchantment)JsonHelper.getAsEntry((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (JsonObject)enchantmentJson, (String)"name");
            int level = GsonHelper.m_13824_((JsonObject)enchantmentJson, (String)"level", (int)1);
            ModifierLevelDisplay display = (ModifierLevelDisplay)ModifierLevelDisplay.LOADER.getAndDeserialize(json, "level_display");
            return new EnchantmentModifier(enchantment, level, display);
        }

        public void serialize(EnchantmentModifier object, JsonObject json) {
            json.add("level_display", ModifierLevelDisplay.LOADER.serialize((GenericLoaderRegistry.IHaveLoader)object.levelDisplay));
            JsonObject enchantmentJson = new JsonObject();
            enchantmentJson.addProperty("name", Objects.requireNonNull(object.enchantment.getRegistryName()).toString());
            enchantmentJson.addProperty("level", (Number)object.enchantmentLevel);
            json.add("enchantment", (JsonElement)enchantmentJson);
        }

        public EnchantmentModifier fromNetwork(FriendlyByteBuf buffer) {
            Enchantment enchantment = (Enchantment)buffer.readRegistryIdUnsafe(ForgeRegistries.ENCHANTMENTS);
            int level = buffer.m_130242_();
            ModifierLevelDisplay display = (ModifierLevelDisplay)ModifierLevelDisplay.LOADER.fromNetwork(buffer);
            return new EnchantmentModifier(enchantment, level, display);
        }

        public void toNetwork(EnchantmentModifier object, FriendlyByteBuf buffer) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.ENCHANTMENTS, (IForgeRegistryEntry)object.enchantment);
            buffer.m_130130_(object.enchantmentLevel);
            ModifierLevelDisplay.LOADER.toNetwork((GenericLoaderRegistry.IHaveLoader)object.levelDisplay, buffer);
        }
    };

    @Override
    public Component getDisplayName(int level) {
        return this.levelDisplay.nameForLevel(this, level);
    }

    @Override
    public void addRawData(IToolStackView tool, int level, RestrictedCompoundTag tag) {
        ListTag enchantments;
        if (tag.contains("Enchantments", 9)) {
            enchantments = tag.getList("Enchantments", 10);
        } else {
            enchantments = new ListTag();
            tag.put("Enchantments", (Tag)enchantments);
        }
        String id = Objects.requireNonNull(this.enchantment.getRegistryName()).toString();
        for (int i = 0; i < enchantments.size(); ++i) {
            CompoundTag enchantmentTag = enchantments.m_128728_(i);
            if (!id.equals(enchantmentTag.m_128461_("id"))) continue;
            EnchantmentHelper.m_182440_((CompoundTag)enchantmentTag, (int)(level * this.enchantmentLevel));
            return;
        }
        enchantments.add((Object)EnchantmentHelper.m_182443_((ResourceLocation)this.enchantment.getRegistryName(), (int)(level * this.enchantmentLevel)));
    }

    @Override
    public void beforeRemoved(IToolStackView tool, RestrictedCompoundTag tag) {
        if (tag.contains("Enchantments", 9)) {
            ListTag enchantments = tag.getList("Enchantments", 10);
            String id = Objects.requireNonNull(this.enchantment.getRegistryName()).toString();
            for (int i = 0; i < enchantments.size(); ++i) {
                CompoundTag enchantmentTag = enchantments.m_128728_(i);
                if (!id.equals(enchantmentTag.m_128461_("id"))) continue;
                enchantments.remove(i);
                if (!enchantments.isEmpty()) break;
                tag.remove("Enchantments");
                break;
            }
        }
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends Modifier> getLoader() {
        return LOADER;
    }

    public EnchantmentModifier(Enchantment enchantment, int enchantmentLevel, ModifierLevelDisplay levelDisplay) {
        this.enchantment = enchantment;
        this.enchantmentLevel = enchantmentLevel;
        this.levelDisplay = levelDisplay;
    }
}

