/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.dynamic;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class SwappableExtraSlotModifier
extends NoLevelsModifier {
    private static final String FORMAT = TConstruct.makeTranslationKey("modifier", "extra_modifier.type_format");
    private final int slots;
    private final boolean alwaysShow;
    private final Map<SlotType, SlotType> penalize;
    public static final GenericLoaderRegistry.IGenericLoader<SwappableExtraSlotModifier> LOADER = new GenericLoaderRegistry.IGenericLoader<SwappableExtraSlotModifier>(){

        public SwappableExtraSlotModifier deserialize(JsonObject json) {
            int slotCount = GsonHelper.m_13927_((JsonObject)json, (String)"slots");
            ImmutableMap penalties = Collections.emptyMap();
            if (json.has("penalize")) {
                ImmutableMap.Builder map = ImmutableMap.builder();
                for (Map.Entry entry : GsonHelper.m_13930_((JsonObject)json, (String)"penalize").entrySet()) {
                    String key = (String)entry.getKey();
                    SlotType result = SlotType.getOrCreate(GsonHelper.m_13805_((JsonElement)((JsonElement)entry.getValue()), (String)("penalize[" + (String)entry.getKey() + "]")));
                    map.put((Object)SlotType.getOrCreate(key), (Object)result);
                }
                penalties = map.build();
            }
            boolean alwaysShow = GsonHelper.m_13855_((JsonObject)json, (String)"always_show", (boolean)false);
            return new SwappableExtraSlotModifier(slotCount, alwaysShow, (Map<SlotType, SlotType>)penalties);
        }

        public void serialize(SwappableExtraSlotModifier object, JsonObject json) {
            json.addProperty("slots", (Number)object.slots);
            json.addProperty("always_show", Boolean.valueOf(object.alwaysShow));
            if (!object.penalize.isEmpty()) {
                JsonObject penaltyJson = new JsonObject();
                for (Map.Entry<SlotType, SlotType> entry : object.penalize.entrySet()) {
                    penaltyJson.addProperty(entry.getKey().getName(), entry.getValue().getName());
                }
                json.add("penalize", (JsonElement)penaltyJson);
            }
        }

        public SwappableExtraSlotModifier fromNetwork(FriendlyByteBuf buffer) {
            int slotCount = buffer.m_130242_();
            boolean alwaysShow = buffer.readBoolean();
            ImmutableMap.Builder penalize = ImmutableMap.builder();
            int size = buffer.m_130242_();
            for (int i = 0; i < size; ++i) {
                penalize.put((Object)SlotType.read(buffer), (Object)SlotType.read(buffer));
            }
            return new SwappableExtraSlotModifier(slotCount, alwaysShow, (Map<SlotType, SlotType>)penalize.build());
        }

        public void toNetwork(SwappableExtraSlotModifier object, FriendlyByteBuf buffer) {
            buffer.m_130130_(object.slots);
            buffer.writeBoolean(object.alwaysShow);
            buffer.m_130130_(object.penalize.size());
            for (Map.Entry<SlotType, SlotType> entry : object.penalize.entrySet()) {
                entry.getKey().write(buffer);
                entry.getValue().write(buffer);
            }
        }
    };

    public static Builder swappable() {
        return new Builder();
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return this.alwaysShow || advanced;
    }

    @Override
    public int getPriority() {
        return this.alwaysShow ? 60 : 50;
    }

    @Override
    public Component getDisplayName(IToolStackView tool, int level) {
        SlotType type;
        Component name = super.getDisplayName(tool, level);
        String slotName = tool.getPersistentData().getString(this.getId());
        if (!slotName.isEmpty() && (type = SlotType.getIfPresent(slotName)) != null) {
            name = new TranslatableComponent(FORMAT, new Object[]{name.m_6879_(), type.getDisplayName()}).m_130938_(style -> style.m_131148_(type.getColor()));
        }
        return name;
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        SlotType type;
        String slotName = context.getPersistentData().getString(this.getId());
        if (!slotName.isEmpty() && (type = SlotType.getIfPresent(slotName)) != null) {
            volatileData.addSlots(type, this.slots);
            SlotType penalty = this.penalize.get(type);
            if (penalty != null) {
                volatileData.addSlots(penalty, -this.slots);
            }
        }
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends Modifier> getLoader() {
        return LOADER;
    }

    private SwappableExtraSlotModifier(int slots, boolean alwaysShow, Map<SlotType, SlotType> penalize) {
        this.slots = slots;
        this.alwaysShow = alwaysShow;
        this.penalize = penalize;
    }

    public static class Builder {
        private final ImmutableMap.Builder<SlotType, SlotType> penalize = ImmutableMap.builder();
        private boolean alwaysShow = false;
        private int slotsPerLevel = 1;

        public Builder alwaysShow() {
            this.alwaysShow = true;
            return this;
        }

        public Builder penalize(SlotType added, SlotType penalty) {
            this.penalize.put((Object)added, (Object)penalty);
            return this;
        }

        public SwappableExtraSlotModifier build() {
            return new SwappableExtraSlotModifier(this.slotsPerLevel, this.alwaysShow, (Map<SlotType, SlotType>)this.penalize.build());
        }

        private Builder() {
        }

        public Builder slotsPerLevel(int slotsPerLevel) {
            this.slotsPerLevel = slotsPerLevel;
            return this;
        }
    }
}

