/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.spilling.effects;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.spilling.ISpillingEffect;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.utils.JsonUtils;

public record DamageSpillingEffect(DamageType type, float damage) implements ISpillingEffect
{
    public static final ResourceLocation ID = TConstruct.getResource("damage");
    public static JsonDeserializer<DamageSpillingEffect> LOADER = (element, classType, context) -> {
        JsonObject json = element.getAsJsonObject();
        String typeName = GsonHelper.m_13906_((JsonObject)json, (String)"damage_type");
        DamageType type = DamageType.byName(typeName);
        if (type == null) {
            throw new JsonSyntaxException("Unknown damage type '" + typeName + "'");
        }
        float damage = GsonHelper.m_13915_((JsonObject)json, (String)"damage_amount");
        return new DamageSpillingEffect(type, damage);
    };

    @Override
    public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
        Player player = context.getPlayerAttacker();
        DamageSource source = player != null ? DamageSource.m_19344_((Player)player) : DamageSource.m_19370_((LivingEntity)context.getAttacker());
        this.type.apply(source);
        ToolAttackUtil.attackEntitySecondary(source, this.damage * scale, context.getTarget(), context.getLivingTarget(), true);
    }

    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject json = JsonUtils.withType(ID);
        json.addProperty("damage_type", this.type.getName());
        json.addProperty("damage_amount", (Number)Float.valueOf(this.damage));
        return json;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum DamageType {
        NORMAL{

            @Override
            public void apply(DamageSource source) {
            }
        }
        ,
        FIRE{

            @Override
            public void apply(DamageSource source) {
                source.m_19383_();
            }
        }
        ,
        MAGIC{

            @Override
            public void apply(DamageSource source) {
                source.m_19389_();
            }
        }
        ,
        EXPLOSION{

            @Override
            public void apply(DamageSource source) {
                source.m_19375_();
            }
        }
        ,
        PIERCING{

            @Override
            public void apply(DamageSource source) {
                source.m_19380_();
            }
        };

        private final String name = this.name().toLowerCase(Locale.US);

        public abstract void apply(DamageSource var1);

        @Nullable
        public static DamageType byName(String name) {
            for (DamageType type : DamageType.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }
    }
}

