/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.util;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public interface ModifierStatBoost {
    default public boolean matchesTags(ToolRebuildContext context) {
        for (TagKey<Item> key : this.tagRequirements()) {
            if (context.hasTag(key)) continue;
            return false;
        }
        return true;
    }

    public List<TagKey<Item>> tagRequirements();

    public void apply(ToolRebuildContext var1, float var2, ModifierStatsBuilder var3);

    public JsonObject toJson();

    public void toNetwork(FriendlyByteBuf var1);

    public static ModifierStatBoost fromJson(JsonObject json) {
        IToolStat<?> stat = ToolStats.fromJson(GsonHelper.m_13906_((JsonObject)json, (String)"stat"));
        List tagRequirements = Collections.emptyList();
        if (json.has("tags")) {
            tagRequirements = JsonHelper.parseList((JsonObject)json, (String)"tags", (element, name) -> TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)JsonHelper.convertToResourceLocation((JsonElement)element, (String)name)));
        }
        if (stat instanceof INumericToolStat) {
            INumericToolStat numeric = (INumericToolStat)stat;
            return StatBoost.fromJson(json, numeric, tagRequirements);
        }
        return StatUpdate.fromJson(json, stat, tagRequirements);
    }

    public static ModifierStatBoost fromNetwork(FriendlyByteBuf buffer) {
        IToolStat<?> stat = ToolStats.fromNetwork(buffer);
        ImmutableList.Builder tagRequirements = ImmutableList.builder();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            tagRequirements.add((Object)TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)buffer.m_130281_()));
        }
        if (stat instanceof INumericToolStat) {
            INumericToolStat numeric = (INumericToolStat)stat;
            return StatBoost.fromNetwork(buffer, numeric, (List<TagKey<Item>>)tagRequirements.build());
        }
        return StatUpdate.fromNetwork(buffer, stat, (List<TagKey<Item>>)tagRequirements.build());
    }

    private static void serializeTags(JsonObject json, List<TagKey<Item>> tagRequirements) {
        if (!tagRequirements.isEmpty()) {
            JsonArray array = new JsonArray();
            for (TagKey<Item> tag : tagRequirements) {
                array.add(tag.f_203868_().toString());
            }
            json.add("tags", (JsonElement)array);
        }
    }

    public record StatBoost(INumericToolStat<?> stat, BoostType type, float amount, List<TagKey<Item>> tagRequirements) implements ModifierStatBoost
    {
        @Override
        public void apply(ToolRebuildContext context, float level, ModifierStatsBuilder builder) {
            if (this.matchesTags(context)) {
                this.type.apply(builder, this.stat, this.amount, level);
            }
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("stat", this.stat.getName().toString());
            json.addProperty("type", this.type.getName());
            json.addProperty("value", (Number)Float.valueOf(this.amount));
            ModifierStatBoost.serializeTags(json, this.tagRequirements);
            return json;
        }

        public static StatBoost fromJson(JsonObject json, INumericToolStat<?> stat, List<TagKey<Item>> tagRequirements) {
            String typeName = GsonHelper.m_13851_((JsonObject)json, (String)"type", (String)"add");
            BoostType boostType = BoostType.byName(typeName);
            if (boostType == null) {
                throw new JsonSyntaxException("Unknown stat type '" + typeName + "'");
            }
            float amount = GsonHelper.m_13915_((JsonObject)json, (String)"value");
            return new StatBoost(stat, boostType, amount, tagRequirements);
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.m_130070_(this.stat.getName().toString());
            buffer.m_130130_(this.tagRequirements.size());
            for (TagKey<Item> key : this.tagRequirements) {
                buffer.m_130085_(key.f_203868_());
            }
            buffer.m_130068_((Enum)this.type);
            buffer.writeFloat(this.amount);
        }

        public static StatBoost fromNetwork(FriendlyByteBuf buffer, INumericToolStat<?> stat, List<TagKey<Item>> tagRequirement) {
            BoostType type = (BoostType)buffer.m_130066_(BoostType.class);
            float amount = buffer.readFloat();
            return new StatBoost(stat, type, amount, tagRequirement);
        }
    }

    public record StatUpdate<T>(IToolStat<T> stat, T value, List<TagKey<Item>> tagRequirements) implements ModifierStatBoost
    {
        @Override
        public void apply(ToolRebuildContext context, float level, ModifierStatsBuilder builder) {
            this.stat.update(builder, this.value);
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("stat", this.stat.getName().toString());
            json.add("value", this.stat.serialize(this.value));
            ModifierStatBoost.serializeTags(json, this.tagRequirements);
            return json;
        }

        public static <T> StatUpdate<T> fromJson(JsonObject json, IToolStat<T> stat, List<TagKey<Item>> tagRequirements) {
            T value = stat.deserialize(JsonHelper.getElement((JsonObject)json, (String)"value"));
            return new StatUpdate<T>(stat, value, tagRequirements);
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.m_130070_(this.stat.getName().toString());
            buffer.m_130130_(this.tagRequirements.size());
            for (TagKey<Item> tag : this.tagRequirements) {
                buffer.m_130085_(tag.f_203868_());
            }
            this.stat.toNetwork(buffer, this.value);
        }

        public static <T> StatUpdate<T> fromNetwork(FriendlyByteBuf buffer, IToolStat<T> stat, List<TagKey<Item>> tagRequirements) {
            T value = stat.fromNetwork(buffer);
            return new StatUpdate<T>(stat, value, tagRequirements);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum BoostType {
        ADD{

            @Override
            public void apply(ModifierStatsBuilder builder, INumericToolStat<?> stat, float value, float level) {
                stat.add(builder, value * level);
            }
        }
        ,
        MULTIPLY_BASE{

            @Override
            public void apply(ModifierStatsBuilder builder, INumericToolStat<?> stat, float value, float level) {
                stat.multiply(builder, 1.0f + value * level);
            }
        }
        ,
        MULTIPLY_CONDITIONAL{

            @Override
            public void apply(ModifierStatsBuilder builder, INumericToolStat<?> stat, float value, float level) {
                builder.multiplier(stat, 1.0f + value * level);
            }
        }
        ,
        MULTIPLY_ALL{

            @Override
            public void apply(ModifierStatsBuilder builder, INumericToolStat<?> stat, float value, float level) {
                stat.multiplyAll(builder, 1.0f + value * level);
            }
        };

        private final String name = this.name().toLowerCase(Locale.ROOT);

        public abstract void apply(ModifierStatsBuilder var1, INumericToolStat<?> var2, float var3, float var4);

        @Nullable
        public static BoostType byName(String name) {
            for (BoostType type : BoostType.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }
    }
}

