/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.capability.InventoryModifierHookIterator;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.tools.menu.ToolContainerMenu;

public class ToolInventoryCapability
extends InventoryModifierHookIterator<ModifierEntry>
implements IItemHandlerModifiable {
    public static final ResourceLocation TOTAL_SLOTS = TConstruct.getResource("total_item_slots");
    public static final ResourceLocation INCLUDE_OFFHAND = TConstruct.getResource("inventory_show_offhand");
    public static final ModifierHook<InventoryModifierHook> HOOK = ModifierHooks.register(TConstruct.getResource("inventory"), InventoryModifierHook.class, new InventoryModifierHook(){

        @Override
        public int getSlots(IToolStackView tool, ModifierEntry modifier) {
            IInventoryModifier inventory = modifier.getModifier().getModule(IInventoryModifier.class);
            if (inventory != null) {
                return inventory.getSlots(tool, modifier.getLevel());
            }
            return 0;
        }

        @Override
        public ItemStack getStack(IToolStackView tool, ModifierEntry modifier, int slot) {
            IInventoryModifier inventory = modifier.getModifier().getModule(IInventoryModifier.class);
            if (inventory != null) {
                return inventory.getStack(tool, modifier.getLevel(), slot);
            }
            return ItemStack.f_41583_;
        }

        @Override
        public void setStack(IToolStackView tool, ModifierEntry modifier, int slot, ItemStack stack) {
            IInventoryModifier inventory = modifier.getModifier().getModule(IInventoryModifier.class);
            if (inventory != null) {
                inventory.setStack(tool, modifier.getLevel(), slot, stack);
            }
        }

        @Override
        public int getSlotLimit(IToolStackView tool, ModifierEntry modifier, int slot) {
            IInventoryModifier inventory = modifier.getModifier().getModule(IInventoryModifier.class);
            if (inventory != null) {
                return inventory.getSlotLimit(tool, slot);
            }
            return 0;
        }

        @Override
        public boolean isItemValid(IToolStackView tool, ModifierEntry modifier, int slot, ItemStack stack) {
            IInventoryModifier inventory = modifier.getModifier().getModule(IInventoryModifier.class);
            if (inventory != null) {
                return inventory.isItemValid(tool, slot, stack);
            }
            return false;
        }

        @Override
        @Nullable
        public Pattern getPattern(IToolStackView tool, ModifierEntry modifier, int slot, boolean hasStack) {
            IInventoryModifier inventory = modifier.getModifier().getModule(IInventoryModifier.class);
            if (inventory != null) {
                return inventory.getPattern(tool, modifier.getLevel(), slot, hasStack);
            }
            return null;
        }
    }, InventoryModifierHookMerger::new);
    private final Supplier<? extends IToolStackView> tool;
    private ItemStack[] cachedStacks;
    private int slots = -1;

    public int getSlots() {
        if (this.slots == -1) {
            this.slots = this.tool.get().getVolatileData().getInt(TOTAL_SLOTS);
        }
        return this.slots;
    }

    @Override
    protected Iterator<ModifierEntry> getIterator(IToolStackView tool) {
        return new ReversedListIterator<ModifierEntry>(tool.getModifierList());
    }

    @Override
    protected InventoryModifierHook getHook(ModifierEntry entry) {
        this.indexEntry = entry;
        return entry.getHook(HOOK);
    }

    public static boolean isBlacklisted(ItemStack stack) {
        return !stack.m_41720_().m_142095_() || stack.m_204117_(TinkerTags.Items.TOOL_INVENTORY_BLACKLIST) || stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (!stack.m_41619_() && ToolInventoryCapability.isBlacklisted(stack)) {
            return false;
        }
        IToolStackView tool = this.tool.get();
        InventoryModifierHook inventory = (InventoryModifierHook)this.findHook(tool, slot);
        if (inventory != null) {
            return inventory.isItemValid(tool, this.indexEntry, slot - this.startIndex, stack);
        }
        return false;
    }

    public int getSlotLimit(int slot) {
        IToolStackView tool = this.tool.get();
        InventoryModifierHook inventory = (InventoryModifierHook)this.findHook(tool, slot);
        if (inventory != null) {
            return inventory.getSlotLimit(tool, this.indexEntry, slot - this.startIndex);
        }
        return 0;
    }

    private void clearCache() {
        this.slots = -1;
        this.cachedStacks = null;
    }

    private void cacheStack(int slot, ItemStack stack) {
        int slots;
        if (slot >= 0 && slot < (slots = this.getSlots())) {
            if (this.cachedStacks == null) {
                this.cachedStacks = new ItemStack[this.getSlots()];
            }
            this.cachedStacks[slot] = stack;
        }
    }

    @Nullable
    private ItemStack getCachedStack(int slot) {
        if (this.cachedStacks != null && slot >= 0 && slot < this.getSlots()) {
            return this.cachedStacks[slot];
        }
        return null;
    }

    private void setAndCache(InventoryModifierHook inventory, int localSlot, int globalSlot, ItemStack stack) {
        inventory.setStack(this.tool.get(), this.indexEntry, localSlot, stack);
        this.cacheStack(globalSlot, stack);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        InventoryModifierHook inventory = (InventoryModifierHook)this.findHook(this.tool.get(), slot);
        if (inventory != null) {
            this.setAndCache(inventory, slot - this.startIndex, slot, stack);
        }
    }

    private ItemStack getAndCache(InventoryModifierHook inventory, int localSlot, int globalSlot) {
        ItemStack stack = inventory.getStack(this.tool.get(), this.indexEntry, localSlot);
        this.cacheStack(globalSlot, stack);
        return stack;
    }

    private ItemStack getCached(InventoryModifierHook inventory, int localSlot, int globalSlot) {
        ItemStack stack = this.getCachedStack(globalSlot);
        if (stack == null) {
            stack = this.getAndCache(inventory, localSlot, globalSlot);
        }
        return stack;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        ItemStack cached = this.getCachedStack(slot);
        if (cached != null) {
            return cached;
        }
        InventoryModifierHook inventory = (InventoryModifierHook)this.findHook(this.tool.get(), slot);
        if (inventory != null) {
            return this.getAndCache(inventory, slot - this.startIndex, slot);
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int leftover;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (ToolInventoryCapability.isBlacklisted(stack)) {
            return stack;
        }
        IToolStackView tool = this.tool.get();
        InventoryModifierHook inventory = (InventoryModifierHook)this.findHook(tool, slot);
        if (inventory == null) {
            return stack;
        }
        int localSlot = slot - this.startIndex;
        if (!inventory.isItemValid(tool, this.indexEntry, localSlot, stack)) {
            return stack;
        }
        ItemStack current = this.getCached(inventory, localSlot, slot);
        int slotLimit = inventory.getSlotLimit(tool, this.indexEntry, localSlot);
        if (current.m_41619_()) {
            int canInsert = Math.min(stack.m_41613_(), Math.min(stack.m_41741_(), slotLimit));
            leftover = stack.m_41613_() - canInsert;
            if (!simulate) {
                this.setAndCache(inventory, localSlot, slot, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)canInsert));
            }
        } else {
            int limit = Math.min(current.m_41741_(), slotLimit);
            if (current.m_41613_() >= limit || !current.m_41656_(stack)) {
                return stack;
            }
            int maxSize = current.m_41613_() + stack.m_41613_();
            int newSize = Math.min(maxSize, limit);
            leftover = maxSize - newSize;
            if (!simulate) {
                current.m_41764_(newSize);
                inventory.setStack(tool, this.indexEntry, localSlot, current);
            }
        }
        if (leftover == 0) {
            return ItemStack.f_41583_;
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)leftover);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0) {
            return ItemStack.f_41583_;
        }
        IToolStackView tool = this.tool.get();
        InventoryModifierHook inventory = (InventoryModifierHook)this.findHook(tool, slot);
        if (inventory == null) {
            return ItemStack.f_41583_;
        }
        int localSlot = slot - this.startIndex;
        ItemStack current = this.getCached(inventory, localSlot, slot);
        if (current.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (amount > current.m_41613_()) {
            amount = current.m_41613_();
        }
        ItemStack result = ItemHandlerHelper.copyStackWithSize((ItemStack)current, (int)amount);
        if (!simulate) {
            if (amount == current.m_41613_()) {
                this.setAndCache(inventory, localSlot, slot, ItemStack.f_41583_);
            } else {
                current.m_41774_(amount);
                inventory.setStack(tool, this.indexEntry, localSlot, current);
            }
        }
        return result;
    }

    public static void addSlots(ModDataNBT volatileData, int count) {
        volatileData.putInt(TOTAL_SLOTS, volatileData.getInt(TOTAL_SLOTS) + count);
    }

    public static InteractionResult tryOpenContainer(ItemStack stack, IToolStackView tool, Player player, EquipmentSlot slotType) {
        return ToolInventoryCapability.tryOpenContainer(stack, tool, tool.getDefinition(), player, slotType);
    }

    public static InteractionResult tryOpenContainer(ItemStack stack, @Nullable IToolStackView tool, ToolDefinition definition, Player player, EquipmentSlot slotType) {
        IItemHandler handler = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(cap -> cap instanceof IItemHandlerModifiable).orElse(null);
        if (handler != null) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((id, inventory, p) -> new ToolContainerMenu(id, inventory, stack, (IItemHandlerModifiable)handler, slotType), TooltipUtil.getDisplayName(stack, tool, definition)), buf -> buf.m_130068_((Enum)slotType));
            }
            return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public ToolInventoryCapability(Supplier<? extends IToolStackView> tool) {
        this.tool = tool;
    }

    private static class ReversedListIterator<T>
    implements Iterator<T> {
        private final List<T> list;
        private int index;

        public ReversedListIterator(List<T> list) {
            this.list = list;
            this.index = list.size() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public T next() {
            T element = this.list.get(this.index);
            --this.index;
            return element;
        }
    }

    public static interface InventoryModifierHook {
        public int getSlots(IToolStackView var1, ModifierEntry var2);

        public ItemStack getStack(IToolStackView var1, ModifierEntry var2, int var3);

        public void setStack(IToolStackView var1, ModifierEntry var2, int var3, ItemStack var4);

        default public int getSlotLimit(IToolStackView tool, ModifierEntry modifier, int slot) {
            return 64;
        }

        default public boolean isItemValid(IToolStackView tool, ModifierEntry modifier, int slot, ItemStack stack) {
            return true;
        }

        @Nullable
        default public Pattern getPattern(IToolStackView tool, ModifierEntry modifier, int slot, boolean hasStack) {
            return null;
        }
    }

    public static class Provider
    implements ToolCapabilityProvider.IToolCapabilityProvider {
        private final LazyOptional<ToolInventoryCapability> handler = LazyOptional.of(() -> new ToolInventoryCapability(tool));

        public Provider(ItemStack stack, Supplier<? extends IToolStackView> tool) {
        }

        @Override
        public <T> LazyOptional<T> getCapability(IToolStackView tool, Capability<T> cap) {
            if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && tool.getVolatileData().getInt(TOTAL_SLOTS) > 0) {
                return this.handler.cast();
            }
            return LazyOptional.empty();
        }

        @Override
        public void clearCache() {
            this.handler.ifPresent(ToolInventoryCapability::clearCache);
        }
    }

    private static class InventoryModifierHookMerger
    extends InventoryModifierHookIterator<InventoryModifierHook>
    implements InventoryModifierHook {
        private final Collection<InventoryModifierHook> modules;

        @Override
        protected Iterator<InventoryModifierHook> getIterator(IToolStackView tool) {
            return this.modules.iterator();
        }

        @Override
        protected InventoryModifierHook getHook(InventoryModifierHook hook) {
            return hook;
        }

        @Nullable
        private InventoryModifierHook findHook(IToolStackView tool, ModifierEntry modifier, int slot) {
            this.indexEntry = modifier;
            return (InventoryModifierHook)this.findHook(tool, slot);
        }

        @Override
        public int getSlots(IToolStackView tool, ModifierEntry modifier) {
            int sum = 0;
            for (InventoryModifierHook module : this.modules) {
                sum += module.getSlots(tool, modifier);
            }
            return sum;
        }

        @Override
        public ItemStack getStack(IToolStackView tool, ModifierEntry modifier, int slot) {
            InventoryModifierHook module = this.findHook(tool, modifier, slot);
            if (module != null) {
                return module.getStack(tool, modifier, slot - this.startIndex);
            }
            return ItemStack.f_41583_;
        }

        @Override
        public void setStack(IToolStackView tool, ModifierEntry modifier, int slot, ItemStack stack) {
            InventoryModifierHook module = this.findHook(tool, modifier, slot);
            if (module != null) {
                module.setStack(tool, modifier, slot - this.startIndex, stack);
            }
        }

        @Override
        public int getSlotLimit(IToolStackView tool, ModifierEntry modifier, int slot) {
            InventoryModifierHook module = this.findHook(tool, modifier, slot);
            if (module != null) {
                return module.getSlotLimit(tool, modifier, slot - this.startIndex);
            }
            return 0;
        }

        @Override
        public boolean isItemValid(IToolStackView tool, ModifierEntry modifier, int slot, ItemStack stack) {
            InventoryModifierHook module = this.findHook(tool, modifier, slot);
            if (module != null) {
                return module.isItemValid(tool, modifier, slot - this.startIndex, stack);
            }
            return false;
        }

        @Override
        @Nullable
        public Pattern getPattern(IToolStackView tool, ModifierEntry modifier, int slot, boolean hasStack) {
            InventoryModifierHook module = this.findHook(tool, modifier, slot);
            if (module != null) {
                return module.getPattern(tool, modifier, slot - this.startIndex, hasStack);
            }
            return null;
        }

        public InventoryModifierHookMerger(Collection<InventoryModifierHook> modules) {
            this.modules = modules;
        }
    }

    @Deprecated
    public static interface IInventoryModifier {
        public int getSlots(IToolStackView var1, int var2);

        public ItemStack getStack(IToolStackView var1, int var2, int var3);

        public void setStack(IToolStackView var1, int var2, int var3, ItemStack var4);

        default public int getSlotLimit(IToolStackView tool, int slot) {
            return 64;
        }

        default public boolean isItemValid(IToolStackView tool, int slot, ItemStack stack) {
            return true;
        }

        @Nullable
        default public Pattern getPattern(IToolStackView tool, int level, int slot, boolean hasStack) {
            return null;
        }
    }
}

