/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module.interaction;

import com.google.gson.JsonObject;
import java.util.Locale;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.json.predicate.modifier.ModifierPredicate;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.tools.definition.module.IToolModule;
import slimeknights.tconstruct.library.tools.definition.module.interaction.InteractionToolModule;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record PreferenceSetInteraction(InteractionSource preferredSource, IJsonPredicate<ModifierId> preferenceModifiers) implements InteractionToolModule,
IToolModule
{
    public static final GenericLoaderRegistry.IGenericLoader<PreferenceSetInteraction> LOADER = new GenericLoaderRegistry.IGenericLoader<PreferenceSetInteraction>(){

        public PreferenceSetInteraction deserialize(JsonObject json) {
            InteractionSource preferredSource = (InteractionSource)JsonHelper.getAsEnum((JsonObject)json, (String)"preferred_source", InteractionSource.class);
            IJsonPredicate preferenceModifiers = (IJsonPredicate)ModifierPredicate.LOADER.getAndDeserialize(json, "preferred_modifiers");
            return new PreferenceSetInteraction(preferredSource, (IJsonPredicate<ModifierId>)preferenceModifiers);
        }

        public PreferenceSetInteraction fromNetwork(FriendlyByteBuf buffer) {
            InteractionSource preferredSource = (InteractionSource)buffer.m_130066_(InteractionSource.class);
            IJsonPredicate preferenceModifiers = (IJsonPredicate)ModifierPredicate.LOADER.fromNetwork(buffer);
            return new PreferenceSetInteraction(preferredSource, (IJsonPredicate<ModifierId>)preferenceModifiers);
        }

        public void serialize(PreferenceSetInteraction object, JsonObject json) {
            json.addProperty("preferred_source", object.preferredSource.toString().toLowerCase(Locale.ROOT));
            json.add("preferred_modifiers", ModifierPredicate.LOADER.serialize(object.preferenceModifiers));
        }

        public void toNetwork(PreferenceSetInteraction object, FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)object.preferredSource);
            ModifierPredicate.LOADER.toNetwork(object.preferenceModifiers, buffer);
        }
    };

    @Override
    public boolean canInteract(IToolStackView tool, ModifierId modifier, InteractionSource source) {
        return source == this.preferredSource == this.preferenceModifiers.matches((Object)modifier);
    }

    public GenericLoaderRegistry.IGenericLoader<? extends IToolModule> getLoader() {
        return LOADER;
    }
}

