/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class DwarvenModifier
extends Modifier
implements ConditionalStatModifierHook {
    private static final Component MINING_SPEED = TConstruct.makeTranslation("modifier", "dwarven.mining_speed");
    private static final Component VELOCITY = TConstruct.makeTranslation("modifier", "dwarven.velocity");
    private static final float BOOST_DISTANCE = 64.0f;
    private static final float DEBUFF_RANGE = 128.0f;
    private static final float MINING_BONUS = 6.0f;
    private static final float VELOCITY_BONUS = 0.05f;

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, TinkerHooks.CONDITIONAL_STAT);
    }

    private static float getBoost(Level world, float y, int level, float baseSpeed, float modifier, float bonus) {
        if (y < 64.0f) {
            float scale = Mth.m_14036_((float)((64.0f - y) / 64.0f), (float)0.0f, (float)2.0f);
            return baseSpeed + (float)level * scale * bonus * modifier;
        }
        float baselineDebuff = Math.max((float)world.m_151558_() - 192.0f, 96.0f);
        if (y > baselineDebuff) {
            if (y >= baselineDebuff + 128.0f) {
                return baseSpeed * 0.25f;
            }
            return baseSpeed * (1.0f - (y - baselineDebuff) / 128.0f * 0.75f);
        }
        return baseSpeed;
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (!isEffective) {
            return;
        }
        event.setNewSpeed(DwarvenModifier.getBoost(event.getPlayer().f_19853_, event.getPos().m_123342_(), level, event.getNewSpeed(), miningSpeedModifier * tool.getMultiplier(ToolStats.MINING_SPEED), 6.0f));
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        if (stat == ToolStats.VELOCITY) {
            return DwarvenModifier.getBoost(living.f_19853_, (float)living.m_20186_(), modifier.getLevel(), baseValue, multiplier, 0.05f);
        }
        return baseValue;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if (harvest || tool.hasTag(TinkerTags.Items.RANGED)) {
            double boost;
            float baseBoost;
            Component prefix = harvest ? MINING_SPEED : VELOCITY;
            float f = baseBoost = harvest ? 6.0f : 0.05f;
            if (player != null && key == TooltipKey.SHIFT) {
                boost = DwarvenModifier.getBoost(player.f_19853_, (float)player.m_20186_(), level, 1.0f, 1.0f, baseBoost) - 1.0f;
                if (boost < 0.0) {
                    if (boost <= -0.01) {
                        this.addPercentTooltip(prefix, boost, tooltip);
                    }
                    return;
                }
            } else {
                boost = baseBoost * (float)level;
            }
            if (boost >= 0.01) {
                this.addFlatBoost(prefix, boost * (double)tool.getMultiplier(harvest ? ToolStats.MINING_SPEED : ToolStats.VELOCITY), tooltip);
            }
        }
    }
}

